/*
 * Copyright (c) 2021 Grizzly Software, https://grizzlysoftware.pl
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated
 * documentation files (the "Software"), to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and
 * to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 */

package pl.grizzlysoftware.dotykacka.client.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;

import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.HashSet;

/**
 * Created by Bartosz Pawłowski on 2019-07-01.
 */
public class Customer extends CloudEntity {
    @JsonProperty("barcode")
    public String barcode;

    @JsonProperty("_discountGroupId")
    public Long discountGroupId;

    @JsonProperty("_sellerId")
    public Long sellerGroupId;

    @JsonProperty("birthday")
    public Long birthday = 0L;

    @JsonProperty("email")
    public String email;

    @JsonProperty("firstName")
    public String firstName;

    @JsonProperty("lastName")
    public String lastName;

    @JsonUnwrapped
    public Address address;

    @JsonProperty("companyId")
    public String companyId = "";

    @JsonProperty("companyName")
    public String companyName = "";

    @JsonProperty("vatId")
    public String vatId = "";

    @JsonProperty("internalNote")
    public String note = "";

    @JsonProperty("phone")
    public String phone = "";

    @JsonProperty("display")
    public Boolean shouldBeDisplayed = true;

    @JsonProperty("points")
    public Double points = 0.0d;

    @JsonProperty("expireDate")
    public ZonedDateTime expiresAt;

    @JsonProperty("hexColor")
    public String hexColor = "#000000";

    @JsonProperty("headerPrint")
    public String headerPrint = "";

    @JsonProperty("tags")
    public Collection<String> tags = new HashSet<>();
}
