/*
 * Copyright 2019 Grizzly Software, https://grizzlysoftware.pl
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated
 * documentation files (the "Software"), to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and
 * to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package pl.grizzlysoftware;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import pl.grizzlysoftware.dotykacka.client.v1.DotykackaApiClient;
import pl.grizzlysoftware.dotykacka.client.v1.api.dto.product.ProductWithStockStatus;
import pl.grizzlysoftware.dotykacka.client.v1.api.dto.sales.ReceiptItem;
import pl.grizzlysoftware.dotykacka.model.Configuration;
import pl.grizzlysoftware.dotykacka.model.Credentials;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.function.Function;
import java.util.stream.Collectors;

import static java.util.stream.Collectors.toList;

/**
 * @author Bartosz Pawłowski, bpawlowski@grizzlysoftware.pl
 */
public class Application {
    public static void main(String[] args) throws Exception {
        var conf0 = new Configuration();
        conf0.cloudId = 344417928L;
        conf0.url = "https://api.dotykacka.cz";
        conf0.apiTokenAuthCredentials = new Credentials("demo@dotykacka.cz", "touchpo_84406");
        conf0.accessTokenAuthCredentials = new Credentials("touchpo", "touchPo!2016api");

        var conf1 = new Configuration();
        conf1.cloudId = 344417928L;
        conf1.url = "https://api.dotykacka.cz";
        conf1.apiTokenAuthCredentials = null;
        conf1.apiToken = "$6cbdac40a48ad3cd7a0cdfe9f9a35e0";
        conf1.accessTokenAuthCredentials = new Credentials("touchpo", "touchPo!2016api");
    }

    static boolean isNotOk(BigDecimal n) {
        return n == null || n.floatValue() == 0.0f;
    }

    static SimpleDateFormat frmttr = new SimpleDateFormat("MM.dd HH:mm");

    public static class func implements Function<Collection<ReceiptItem>, String> {

        @Override
        public String apply(Collection<ReceiptItem> es) {
            var e = es
                    .stream()
                    .sorted(Comparator.comparingLong(x -> x.orderId))
                    .findFirst()
                    .orElse(new ReceiptItem());
            return new StringBuilder()
                    .append("'")
                    .append(e.name)
                    .append("', ")
                    .append(e.ean)
                    .append(", ")
                    .append(e.pricePurchaseWithoutVat == null ? "" : e.pricePurchaseWithoutVat.setScale(2, RoundingMode.HALF_UP).toString())
                    .append(", ")
                    .append(e.priceBilledWithoutVat == null ? "" : e.priceBilledWithoutVat.setScale(2, RoundingMode.HALF_UP).toString())
                    .append(", ")
                    .append(isNotOk(e.priceBilledWithoutVat) ? "" : e.priceBilledWithoutVat.multiply(e.vat))
                    .append(", ")
                    .append(isNotOk(e.pricePurchaseWithoutVat) || isNotOk(e.priceBilledWithoutVat) ? "" :
                            e.priceBilledWithoutVat
                                    .subtract(e.pricePurchaseWithoutVat)
                                    .divide(e.pricePurchaseWithoutVat, 2, RoundingMode.HALF_UP)
                                    .abs())
                    .append(", ")
                    .append(isNotOk(e.pricePurchaseWithoutVat) || isNotOk(e.priceBilledWithoutVat) ? "" :
                            e.pricePurchaseWithoutVat
                                    .divide(e.priceBilledWithoutVat, 2, RoundingMode.HALF_UP)
                                    .subtract(BigDecimal.ONE)
                                    .abs())
                    .append(", ")
                    .append(es.size())
                    .append(", ")
                    .append(es.stream().map(k -> frmttr.format(k.completedAt)).collect(Collectors.joining("\\ ")))
                    .append('\n')
                    .toString();
        }
    }
}
