/*
 * Decompiled with CFR 0.152.
 */
package pl.grizzlysoftware.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import com.fasterxml.jackson.databind.type.TypeFactory;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.grizzlysoftware.util.LoggingJacksonResponseBodyConverter;
import retrofit2.Converter;

public class OkHttpNonEmptyBodyConverter<T>
implements Converter<ResponseBody, T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OkHttpNonEmptyBodyConverter.class);
    private Converter<ResponseBody, T> delegate;
    private TypeFactory typeFactory;

    public OkHttpNonEmptyBodyConverter(Converter<ResponseBody, T> delegate) {
        this.delegate = delegate;
        this.typeFactory = TypeFactory.defaultInstance();
    }

    public T convert(ResponseBody body) throws JsonProcessingException {
        try {
            Object out = this.delegate.convert((Object)body);
            return (T)out;
        }
        catch (MismatchedInputException e) {
            if (this.delegate instanceof LoggingJacksonResponseBodyConverter) {
                LoggingJacksonResponseBodyConverter conv = (LoggingJacksonResponseBodyConverter)this.delegate;
                JavaType type = this.typeFactory.constructType(conv.type);
                if (type.isContainerType()) {
                    return (T)conv.mapper.readValue("[]", type);
                }
                return (T)conv.mapper.readValue("{}", type);
            }
            LOGGER.warn("cannot deserialize", (Throwable)e);
            return null;
        }
        catch (Exception e) {
            LOGGER.warn("cannot deserialize", (Throwable)e);
            return null;
        }
    }
}

