/*
 * Copyright 2019 Grizzly Software, https://grizzlysoftware.pl
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated
 * documentation files (the "Software"), to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and
 * to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package pl.grizzlysoftware;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import pl.grizzlysoftware.dotykacka.client.v1.DotykackaApiClient;
import pl.grizzlysoftware.dotykacka.client.v1.api.dto.product.ProductWithStockStatus;
import pl.grizzlysoftware.dotykacka.client.v1.api.dto.sales.ReceiptItem;
import pl.grizzlysoftware.dotykacka.model.Configuration;
import pl.grizzlysoftware.dotykacka.model.Credentials;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;

import static java.util.stream.Collectors.toList;

/**
 * @author Bartosz Pawłowski, bpawlowski@grizzlysoftware.pl
 */
public class Application {
    public static void main(String[] args) throws Exception {
        var conf0 = new Configuration();
        conf0.cloudId = 344417928;
        conf0.url = "https://api.dotykacka.cz";
        conf0.apiTokenAuthCredentials = new Credentials("demo@dotykacka.cz", "touchpo_84406");
        conf0.accessTokenAuthCredentials = new Credentials("touchpo", "touchPo!2016api");

        var conf1 = new Configuration();
        conf1.cloudId = 344417928;
        conf1.url = "https://api.dotykacka.cz";
        conf1.apiTokenAuthCredentials = null;
        conf1.apiToken = "$6cbdac40a48ad3cd7a0cdfe9f9a35e0";
        conf1.accessTokenAuthCredentials = new Credentials("touchpo", "touchPo!2016api");

        var api0 = new DotykackaApiClient(conf0);
        var api1 = new DotykackaApiClient(conf1);

        long whId = 138716511L;
//        var res0 = api0.productService.getProductsWithStockStatus(whId,0, 50);
//        var res1 = api1.productService.getProductsWithStockStatus(whId,0, 50);

        var m = new ObjectMapper();

        var date0 = LocalDateTime.of(2019, 9, 1, 0, 0);
        var date1 = LocalDateTime.of(2019, 12, 1, 0, 0);


        var cal = Calendar.getInstance();
        cal.set(Calendar.YEAR, 2019);
        cal.set(Calendar.MONTH, 11);
        cal.set(Calendar.DAY_OF_MONTH, 1);
        cal.set(Calendar.HOUR_OF_DAY, 0);
        cal.set(Calendar.MINUTE, 0);
        cal.set(Calendar.SECOND, 0);
        cal.set(Calendar.MILLISECOND, 0);

        var timestamp0 = Date.from(LocalDateTime.of(2019, 11, 1, 0, 0).atZone(ZoneId.systemDefault()).toInstant()).getTime();
        var timestamp1 = Date.from(LocalDateTime.of(2019, 11, 30, 23, 59).atZone(ZoneId.systemDefault()).toInstant()).getTime();
//        var result = api1.productService.getProductsWithStockStatus(138716511);
//        m.writeValue(new File("D:\\productsWithStock.json"), result);

        var receipts = m.readValue(new File("D:\\receiptItems.json"), new TypeReference<Collection<ReceiptItem>>() {
        });
        var productsWithStock = m.readValue(new File("D:\\productsWithStock.json"), new TypeReference<Collection<ProductWithStockStatus>>() {
        });

        var out = receipts
                .stream()
                .collect(Collectors.groupingBy(e -> e.ean, Collectors.toList()));

        var mapper = new func();
        var out1 = out.entrySet()
                .stream()
                .sorted(Comparator.comparingLong(z -> z.getValue().size()))
                .peek(e -> e.getValue().removeIf(x -> x.completed < timestamp0 || x.completed > timestamp1))
                .filter(e -> e.getValue().size() > 0)
                .map(e -> mapper.apply(e.getValue()))
                .collect(toList());

        var fos = new FileOutputStream("D:\\receipts2.csv");
        String headers = "nazwa, ean, kupno[bv], sprzedaz[bv], sprzedaz[v], narzut[%], marza[%], sprzedanych[szt], kiedy sprzedane[mm.dd hh:mm]\n";
        fos.write(headers.getBytes("UTF-8"));
        out1.stream().forEach(e -> {
            try {
                fos.write(e.getBytes("UTF-8"));
            } catch (IOException ex) {
                ex.printStackTrace();
            }
        });

        System.out.println();
    }

    static boolean isNotOk(BigDecimal n) {
        return n == null || n.floatValue() == 0.0f;
    }

    static SimpleDateFormat frmttr = new SimpleDateFormat("MM.dd HH:mm");

    public static class func implements Function<Collection<ReceiptItem>, String> {

        @Override
        public String apply(Collection<ReceiptItem> es) {
            var e = es
                    .stream()
                    .sorted(Comparator.comparingLong(x -> x.orderId))
                    .findFirst()
                    .orElse(new ReceiptItem());
            return new StringBuilder()
                    .append("'")
                    .append(e.name)
                    .append("', ")
                    .append(e.ean)
                    .append(", ")
                    .append(e.pricePurchaseWithoutVat == null ? "" : e.pricePurchaseWithoutVat.setScale(2, RoundingMode.HALF_UP).toString())
                    .append(", ")
                    .append(e.priceBilledWithoutVat == null ? "" : e.priceBilledWithoutVat.setScale(2, RoundingMode.HALF_UP).toString())
                    .append(", ")
                    .append(isNotOk(e.priceBilledWithoutVat) ? "" : e.priceBilledWithoutVat.multiply(e.vat))
                    .append(", ")
                    .append(isNotOk(e.pricePurchaseWithoutVat) || isNotOk(e.priceBilledWithoutVat) ? "" :
                            e.priceBilledWithoutVat
                                    .subtract(e.pricePurchaseWithoutVat)
                                    .divide(e.pricePurchaseWithoutVat, 2, RoundingMode.HALF_UP)
                                    .abs())
                    .append(", ")
                    .append(isNotOk(e.pricePurchaseWithoutVat) || isNotOk(e.priceBilledWithoutVat) ? "" :
                            e.pricePurchaseWithoutVat
                                    .divide(e.priceBilledWithoutVat, 2, RoundingMode.HALF_UP)
                                    .subtract(BigDecimal.ONE)
                                    .abs())
                    .append(", ")
                    .append(es.size())
                    .append(", ")
                    .append(es.stream().map(k -> frmttr.format(new Date(k.completed))).collect(Collectors.joining("\\ ")))
                    .append('\n')
                    .toString();
        }
    }
}
