/*
 * Decompiled with CFR 0.152.
 */
package pl.databucket.examples.approach2.user;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import java.util.Map;
import pl.databucket.client.BaseBucket;
import pl.databucket.client.CustomDataDef;
import pl.databucket.client.Databucket;
import pl.databucket.client.Mapper;
import pl.databucket.client.MultiDataResponse;
import pl.databucket.client.RequestResponse;
import pl.databucket.client.Rules;
import pl.databucket.examples.approach2.user.YUser;

public class YBucketUsers
extends BaseBucket {
    public YBucketUsers(Databucket databucket, String bucketName) {
        super(databucket, bucketName);
    }

    public YUser insertUser(YUser user) {
        try {
            RequestResponse rr = this.insertData(user);
            if (rr.isResponseCorrect()) {
                return (YUser)Mapper.objectMapper.readValue(rr.getResponseBody(), YUser.class);
            }
            throw new RuntimeException(rr.getException());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void insertMultiUser(List<YUser> userList) {
        this.insertMultiData(userList);
    }

    public YUser getUser(Long dataId) {
        try {
            RequestResponse rr = this.getData(dataId);
            if (rr.isResponseCorrect()) {
                return (YUser)Mapper.objectMapper.readValue(rr.getResponseBody(), YUser.class);
            }
            throw new RuntimeException(rr.getException());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public YUser getUser(Rules rules) {
        try {
            RequestResponse rr = this.getData(rules);
            if (rr.isResponseCorrect()) {
                MultiDataResponse multiDataResponse = (MultiDataResponse)Mapper.objectMapper.readValue(rr.getResponseBody(), MultiDataResponse.class);
                if (multiDataResponse.getData() != null) {
                    List listOfUsers = (List)Mapper.objectMapper.convertValue(multiDataResponse.getData(), (TypeReference)new TypeReference<List<YUser>>(){});
                    return (YUser)listOfUsers.get(0);
                }
                return null;
            }
            throw new RuntimeException(rr.getException());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Map<String, Object> getUser(Rules rules, List<CustomDataDef> columns) {
        try {
            RequestResponse rr = this.getData(rules, columns);
            if (rr.isResponseCorrect()) {
                MultiDataResponse multiDataResponse = (MultiDataResponse)Mapper.objectMapper.readValue(rr.getResponseBody(), MultiDataResponse.class);
                if (multiDataResponse.getCustomData().size() > 0) {
                    return multiDataResponse.getCustomData().get(0);
                }
                return null;
            }
            throw new RuntimeException(rr.getException());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public YUser reserveUser(Rules rules) {
        try {
            RequestResponse rr = this.reserveData(rules, true);
            if (rr.isResponseCorrect()) {
                MultiDataResponse multiDataResponse = (MultiDataResponse)Mapper.objectMapper.readValue(rr.getResponseBody(), MultiDataResponse.class);
                if (multiDataResponse.getData() != null) {
                    List listOfUsers = (List)Mapper.objectMapper.convertValue(multiDataResponse.getData(), (TypeReference)new TypeReference<List<YUser>>(){});
                    return (YUser)listOfUsers.get(0);
                }
                return null;
            }
            throw new RuntimeException(rr.getException());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public YUser updateUser(YUser user) {
        try {
            RequestResponse rr = this.updateData(user);
            if (rr.isResponseCorrect()) {
                return (YUser)Mapper.objectMapper.readValue(rr.getRequestBody(), YUser.class);
            }
            throw new RuntimeException(rr.getException());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

