/*
 * Decompiled with CFR 0.152.
 */
package pl.databucket.examples.approach1.user;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.List;
import java.util.Map;
import pl.databucket.client.Bucket;
import pl.databucket.client.Data;
import pl.databucket.client.Databucket;
import pl.databucket.client.RequestResponse;
import pl.databucket.client.Rules;
import pl.databucket.examples.approach1.user.XUser;

public class XBucketUsers
extends Bucket {
    private final Gson gson = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();

    public XBucketUsers(Databucket databucket, String bucketName) {
        super(databucket, bucketName);
    }

    public String getErrorMessage(RequestResponse rr) {
        return "Response status: " + rr.getResponseStatus() + "\n\n" + rr.getResponseBody();
    }

    public XUser getUser(Rules rules) {
        RequestResponse rr = this.getData(rules);
        if (rr.isResponseCorrect()) {
            Map<String, Object> json = this.strToJson(rr.getResponseBody());
            if (json.containsKey("data")) {
                List dataList = (List)json.get("data");
                if (dataList.size() > 0) {
                    Data data = this.jsonToData((Map)dataList.get(0));
                    return new XUser(data);
                }
                return null;
            }
            return null;
        }
        throw new RuntimeException(this.getErrorMessage(rr));
    }

    public XUser getUser(Rules rules, List<String> fields) {
        RequestResponse rr = this.getData(rules, fields);
        if (rr.isResponseCorrect()) {
            Map<String, Object> json = this.strToJson(rr.getResponseBody());
            if (json.containsKey("customData")) {
                List dataList = (List)json.get("customData");
                if (dataList.size() > 0) {
                    Data data = this.customJsonToData((Map)dataList.get(0));
                    return new XUser(data);
                }
                return null;
            }
            return null;
        }
        throw new RuntimeException(this.getErrorMessage(rr));
    }

    public XUser reserveUser(Rules rules) {
        RequestResponse rr = this.reserveData(rules, true);
        if (rr.isResponseCorrect()) {
            Data data = this.strToData(rr.getResponseBody());
            return new XUser(data);
        }
        throw new RuntimeException(this.getErrorMessage(rr));
    }

    public XUser insertUser(XUser user) {
        RequestResponse rr = this.insertData(user);
        if (rr.isResponseCorrect()) {
            Data data = this.strToData(rr.getResponseBody());
            return new XUser(data);
        }
        throw new RuntimeException(this.getErrorMessage(rr));
    }

    public void insertMultiUser(List<XUser> userList) {
        this.insertMultiData(userList);
    }

    public XUser updateUser(XUser user) {
        RequestResponse rr = this.updateData(user);
        if (rr.isResponseCorrect()) {
            Data data = this.strToData(rr.getResponseBody());
            return new XUser(data);
        }
        throw new RuntimeException(this.getErrorMessage(rr));
    }

    private String getPrettyHeaders(MultivaluedMap<String, String> headers) {
        StringBuilder sb = new StringBuilder();
        headers.forEach((key, value) -> {
            String v = value.toString();
            sb.append((String)key).append(": ").append(v, 1, v.length() - 1).append("\n");
        });
        return sb.toString();
    }

    private String getPrettyBody(String content) {
        JsonElement je = JsonParser.parseString((String)content);
        return this.gson.toJson(je);
    }
}

