/*
 * Decompiled with CFR 0.152.
 */
package pl.databucket.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pl.databucket.client.LogicalOperator;
import pl.databucket.client.Operator;
import pl.databucket.client.PropertyEnum;
import pl.databucket.client.Rule;

public class Rules {
    LogicalOperator logicalOperator = LogicalOperator.and;
    List<Object> rules = new ArrayList<Object>();

    public Rules() {
    }

    public Rules(List<Rule> rules) {
        this.rules.addAll(rules);
    }

    public Rules(Rule rule) {
        this.rules.add(rule);
    }

    public Rules(Object leftObject, Operator operator, Object rightObject) {
        this.rules.add(new Rule(leftObject, operator, rightObject));
    }

    public Rules(LogicalOperator logicalOperator) {
        this.logicalOperator = logicalOperator;
    }

    public void addRule(Object leftObject, Operator operator, Object rightObject) {
        this.rules.add(new Rule(leftObject, operator, rightObject));
    }

    public void addRule(Rule rule) {
        this.rules.add(rule);
    }

    public void addRules(List<Rule> rules) {
        this.rules.addAll(rules);
    }

    public void addNestedRules(Rules rules) {
        this.rules.add(rules);
    }

    public List<Object> getOwnRules() {
        return this.rules;
    }

    public LogicalOperator getOwnOperator() {
        return this.logicalOperator;
    }

    public List<Object> toNativeObject() {
        ArrayList<Object> list = new ArrayList<Object>();
        if (this.getOwnRules().size() > 0) {
            if (this.getOwnOperator() == LogicalOperator.and) {
                this.getOwnRules().forEach(item -> {
                    if (item instanceof Rules) {
                        list.add(this.rulesToMap((Rules)item));
                    } else if (item instanceof Rule) {
                        list.add(this.ruleToList((Rule)item));
                    }
                });
            } else {
                list.add(this.rulesToMap(this));
            }
        }
        return list;
    }

    private Map<String, Object> rulesToMap(Rules rules) {
        ArrayList list = new ArrayList();
        rules.getOwnRules().forEach(item -> {
            if (item instanceof Rules) {
                list.add(this.rulesToMap((Rules)item));
            } else if (item instanceof Rule) {
                list.add(this.ruleToList((Rule)item));
            }
        });
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(rules.getOwnOperator().toString(), list);
        return map;
    }

    private List<Object> ruleToList(Rule rule) {
        Object enumValue;
        ArrayList<Object> list = new ArrayList<Object>();
        if (rule.getLeftObject() instanceof PropertyEnum) {
            enumValue = ((PropertyEnum)rule.getLeftObject()).getValue();
            list.add(enumValue);
        } else {
            list.add(rule.getLeftObject());
        }
        list.add(rule.getOperator().toString());
        if (rule.getRightObject() instanceof PropertyEnum) {
            enumValue = ((PropertyEnum)rule.getRightObject()).getValue();
            list.add(enumValue);
        } else {
            list.add(rule.getRightObject());
        }
        return list;
    }
}

