/*
 * Decompiled with CFR 0.152.
 */
package pl.databucket.client;

import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.message.BasicHeader;
import org.glassfish.jersey.client.ClientConfig;
import pl.databucket.client.ClientResponseFilterLog;
import pl.databucket.client.SignInRequestDTO;
import pl.databucket.client.SignInResponseDTO;

public class Databucket {
    private final String serviceUrl;
    private Client client;
    HttpClient httpClient;
    private MultivaluedMap<String, String> headers = new MultivaluedHashMap();

    public Databucket(String serviceUrl, boolean logs) {
        this.serviceUrl = serviceUrl;
        this.client = ClientBuilder.newClient();
        this.httpClient = HttpClientBuilder.create().build();
        if (logs) {
            this.client.register((Object)new ClientResponseFilterLog());
        }
        this.addBaseHeaders();
    }

    public Databucket(String serviceUrl, boolean logs, HttpHost proxy) {
        this.serviceUrl = serviceUrl;
        ClientConfig config = new ClientConfig();
        config.property("jersey.config.client.proxy.uri", (Object)(proxy.getSchemeName() + "://" + proxy.getHostName() + ":" + proxy.getPort()));
        this.client = (Client)ClientBuilder.newClient((Configuration)config).property("jersey.config.client.httpUrlConnection.setMethodWorkaround", (Object)true);
        DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxy);
        this.httpClient = HttpClients.custom().setRoutePlanner((HttpRoutePlanner)routePlanner).build();
        if (logs) {
            this.client.register((Object)new ClientResponseFilterLog());
        }
        this.addBaseHeaders();
    }

    public Databucket(String serviceUrl, String username, String password, Integer projectId, boolean logs) {
        this.serviceUrl = serviceUrl;
        this.client = ClientBuilder.newClient();
        this.httpClient = HttpClientBuilder.create().build();
        if (logs) {
            this.client.register((Object)new ClientResponseFilterLog());
        }
        this.addBaseHeaders();
        this.authenticate(SignInRequestDTO.builder().username(username).password(password).projectId(projectId).build());
    }

    public Databucket(String serviceUrl, String username, String password, Integer projectId, boolean logs, HttpHost proxy) {
        this.serviceUrl = serviceUrl;
        ClientConfig config = new ClientConfig();
        config.property("jersey.config.client.proxy.uri", (Object)(proxy.getSchemeName() + "://" + proxy.getHostName() + ":" + proxy.getPort()));
        this.client = (Client)ClientBuilder.newClient((Configuration)config).property("jersey.config.client.httpUrlConnection.setMethodWorkaround", (Object)true);
        DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxy);
        this.httpClient = HttpClients.custom().setRoutePlanner((HttpRoutePlanner)routePlanner).build();
        if (logs) {
            this.client.register((Object)new ClientResponseFilterLog());
        }
        this.addBaseHeaders();
        this.authenticate(SignInRequestDTO.builder().username(username).password(password).projectId(projectId).build());
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public Header[] getHeaders2() {
        ArrayList<BasicHeader> headerList = new ArrayList<BasicHeader>();
        for (Map.Entry entry : this.headers.entrySet()) {
            String value = ((List)entry.getValue()).toString();
            headerList.add(new BasicHeader((String)entry.getKey(), value.substring(1, value.length() - 1)));
        }
        return headerList.toArray(new Header[this.headers.size()]);
    }

    public void setClient(Client newClient) {
        this.client = newClient;
    }

    public Client getClient() {
        return this.client;
    }

    public String buildUrl(String resource) {
        return this.serviceUrl + resource;
    }

    private void addBaseHeaders() {
        this.headers.putSingle((Object)"User-Agent", (Object)"api-client");
        this.headers.putSingle((Object)"Content-Type", (Object)"application/json");
    }

    public void setHeaders(MultivaluedMap<String, String> newHeaders) {
        this.headers = newHeaders;
    }

    public MultivaluedMap<String, String> getHeaders() {
        return this.headers;
    }

    public void authenticate(SignInRequestDTO signInRequest) {
        WebTarget webTarget = this.client.target(this.buildUrl("/api/public/signin"));
        Invocation.Builder builder = webTarget.request(new String[]{"application/json"});
        for (Map.Entry entry : this.getHeaders().entrySet()) {
            String value = ((List)entry.getValue()).toString();
            builder = builder.header((String)entry.getKey(), (Object)value.substring(1, value.length() - 1));
        }
        Response response = builder.post(Entity.json((Object)signInRequest));
        if (response.getStatus() != 200) {
            throw new RuntimeException("Response status: " + response.getStatus() + "\n\n" + (String)response.readEntity(String.class));
        }
        SignInResponseDTO signInResponse = (SignInResponseDTO)response.readEntity(SignInResponseDTO.class);
        this.headers.putSingle((Object)"Authorization", (Object)("Bearer " + signInResponse.getToken()));
    }
}

