/*
 * Decompiled with CFR 0.152.
 */
package pl.databucket.client;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class Data {
    private Long id;
    private Boolean reserved;
    private String owner;
    private Integer tagId;
    private Map<String, Object> properties;
    private Date createdAt;
    private String createdBy;
    private Date modifiedAt;
    private String modifiedBy;

    public Data(Data data) {
        this.id = data.id;
        this.reserved = data.reserved;
        this.owner = data.owner;
        this.tagId = data.tagId;
        this.properties = data.properties;
        this.createdAt = data.createdAt;
        this.createdBy = data.createdBy;
        this.modifiedAt = data.modifiedAt;
        this.modifiedBy = data.modifiedBy;
    }

    public Data() {
    }

    public Data(Long id, Integer tagId, Boolean locked, String lockedBy, Map<String, Object> properties, Date createdAt, String createdBy, Date modifiedAt, String modifiedBy) {
        this.id = id;
        this.tagId = tagId;
        this.reserved = locked;
        this.owner = lockedBy;
        this.properties = properties;
        this.createdAt = createdAt;
        this.createdBy = createdBy;
        this.modifiedAt = modifiedAt;
        this.modifiedBy = modifiedBy;
    }

    public Long getId() {
        return this.id;
    }

    public Boolean getReserved() {
        return this.reserved;
    }

    public void setReserved(Boolean reserved) {
        this.reserved = reserved;
    }

    public String getOwner() {
        return this.owner;
    }

    public Integer getTagId() {
        return this.tagId;
    }

    public void setTagId(Integer tagId) {
        this.tagId = tagId;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public void deleteProperty(String propertyPath) {
        if (this.properties != null) {
            this.removeValueByPath(this.properties, propertyPath.replace("$.", ""));
        }
    }

    public void setProperty(String propertyPath, Object value) {
        if (this.properties == null) {
            this.properties = new HashMap<String, Object>();
        }
        this.setValueByPath(this.properties, propertyPath.replace("$.", ""), value);
    }

    public Object getProperty(String propertyPath) {
        if (this.properties == null) {
            return null;
        }
        return this.getValueByPath(this.properties, propertyPath.replace("$.", ""));
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public Date getModifiedAt() {
        return this.modifiedAt;
    }

    public String getModifiedBy() {
        return this.modifiedBy;
    }

    public String toString() {
        String dataStr = "";
        dataStr = dataStr + "id: " + this.getId() + "\n";
        dataStr = dataStr + "tagId: " + this.getTagId() + "\n";
        dataStr = dataStr + "reserved: " + this.getReserved() + "\n";
        dataStr = dataStr + "owner: " + this.getOwner() + "\n";
        dataStr = dataStr + "createdAt: " + this.getCreatedAt() + "\n";
        dataStr = dataStr + "createdBy: " + this.getCreatedBy() + "\n";
        dataStr = dataStr + "modifiedAt: " + this.getModifiedAt() + "\n";
        dataStr = dataStr + "modifiedBy: " + this.getModifiedBy() + "\n";
        dataStr = dataStr + "properties: " + this.getProperties().toString();
        return dataStr;
    }

    private Object getValueByPath(Object source, String path) {
        if (path.contains(".")) {
            int pos = path.indexOf(".");
            String name = path.substring(0, pos);
            String restPath = path.substring(pos + 1);
            if (source instanceof Map && ((Map)source).containsKey(name)) {
                return this.getValueByPath(((Map)source).get(name), restPath);
            }
            return null;
        }
        if (source instanceof Map && ((Map)source).containsKey(path)) {
            return ((Map)source).get(path);
        }
        return null;
    }

    private void setValueByPath(Object source, String path, Object value) {
        if (path.contains(".")) {
            int pos = path.indexOf(".");
            String name = path.substring(0, pos);
            String restPath = path.substring(pos + 1);
            if (source instanceof Map && !((Map)source).containsKey(name)) {
                ((Map)source).put(name, new HashMap());
            }
            this.setValueByPath(((Map)source).get(name), restPath, value);
        } else {
            ((Map)source).put(path, value);
        }
    }

    private void removeValueByPath(Object source, String path) {
        if (path.contains(".")) {
            int pos = path.indexOf(".");
            String name = path.substring(0, pos);
            String restPath = path.substring(pos + 1);
            if (source instanceof Map && ((Map)source).containsKey(name)) {
                this.removeValueByPath(((Map)source).get(name), restPath);
            }
        } else if (source instanceof Map && ((Map)source).containsKey(path)) {
            ((Map)source).remove(path);
        }
    }
}

