/*
 * Decompiled with CFR 0.152.
 */
package pl.databucket.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import pl.databucket.HttpClient.HttpEntityDelete;
import pl.databucket.client.Data;
import pl.databucket.client.Databucket;
import pl.databucket.client.Operator;
import pl.databucket.client.RequestResponse;
import pl.databucket.client.Rule;
import pl.databucket.client.Rules;

public class Bucket {
    public final Databucket databucket;
    public final String bucketName;
    protected final Gson gson;

    public Bucket(Databucket databucket, String bucketName) {
        this.databucket = databucket;
        this.bucketName = bucketName;
        this.gson = new GsonBuilder().disableHtmlEscaping().create();
    }

    private void setHeaders(Invocation.Builder builder) {
        for (Map.Entry entry : this.databucket.getHeaders().entrySet()) {
            String value = ((List)entry.getValue()).toString();
            builder = builder.header((String)entry.getKey(), (Object)value.substring(1, value.length() - 1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestResponse insertData(Data data) {
        HashMap<String, Object> json = new HashMap<String, Object>();
        if (data.getReserved() != null) {
            json.put("reserved", data.getReserved());
        }
        if (data.getTagId() != null) {
            json.put("tagId", data.getTagId());
        }
        if (data.getProperties() != null) {
            json.put("properties", data.getProperties());
        }
        WebTarget webTarget = this.databucket.getClient().target(this.databucket.buildUrl(String.format("/api/bucket/%s", this.bucketName)));
        Invocation.Builder builder = webTarget.request(new String[]{"application/json"});
        this.setHeaders(builder);
        String payload = this.gson.toJson(json);
        RequestResponse requestResponse = new RequestResponse();
        requestResponse.setRequestMethod("POST");
        requestResponse.setRequestHeaders(this.databucket.getHeaders());
        requestResponse.setRequestBody(payload);
        requestResponse.setRequestUrl(webTarget.getUri().toString());
        long start = System.currentTimeMillis();
        try {
            Response response = builder.post(Entity.json(json));
            requestResponse.setResponseStatus(response.getStatus());
            requestResponse.setResponseCorrect(response.getStatus() == 201);
            requestResponse.setResponseHeaders((MultivaluedMap<String, Object>)response.getHeaders());
            requestResponse.setResponseBody((String)response.readEntity(String.class));
        }
        catch (Exception e) {
            requestResponse.setResponseCorrect(false);
            requestResponse.setException(e);
        }
        finally {
            requestResponse.setResponseDuration(System.currentTimeMillis() - start);
        }
        return requestResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestResponse insertMultiData(List<? extends Data> dataList) {
        WebTarget webTarget = this.databucket.getClient().target(this.databucket.buildUrl(String.format("/api/bucket/%s/multi", this.bucketName)));
        Invocation.Builder builder = webTarget.request(new String[]{"application/json"});
        this.setHeaders(builder);
        String payload = this.gson.toJson(dataList);
        RequestResponse requestResponse = new RequestResponse();
        requestResponse.setRequestMethod("POST");
        requestResponse.setRequestHeaders(this.databucket.getHeaders());
        requestResponse.setRequestBody(payload);
        requestResponse.setRequestUrl(webTarget.getUri().toString());
        long start = System.currentTimeMillis();
        try {
            Response response = builder.post(Entity.json(dataList));
            requestResponse.setResponseStatus(response.getStatus());
            requestResponse.setResponseCorrect(response.getStatus() == 201);
            requestResponse.setResponseHeaders((MultivaluedMap<String, Object>)response.getHeaders());
            requestResponse.setResponseBody((String)response.readEntity(String.class));
        }
        catch (Exception e) {
            requestResponse.setResponseCorrect(false);
            requestResponse.setException(e);
        }
        finally {
            requestResponse.setResponseDuration(System.currentTimeMillis() - start);
        }
        return requestResponse;
    }

    public RequestResponse getData(Long id, List<String> fields) {
        return this.getData(new Rules(new Rule("id", Operator.equal, id)), fields);
    }

    public RequestResponse getData(Rules rules, List<String> fields) {
        return this.getData(rules, true, fields);
    }

    public RequestResponse getData(Rules rules, boolean random, List<String> fields) {
        return this.getData(rules, random, fields, 1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestResponse getData(Rules rules, boolean random, List<String> fields, Long limit) {
        HashMap<String, List<Object>> json = new HashMap<String, List<Object>>();
        json.put("columns", this.fieldsToColumns(fields));
        json.put("rules", rules.toNativeObject());
        WebTarget webTarget = this.databucket.getClient().target(this.databucket.buildUrl(String.format("/api/bucket/%s/get", this.bucketName)));
        webTarget = webTarget.queryParam("limit", new Object[]{limit});
        if (random) {
            webTarget = webTarget.queryParam("sort", new Object[]{"random"});
        }
        Invocation.Builder builder = webTarget.request(new String[]{"application/json"});
        this.setHeaders(builder);
        String payload = this.gson.toJson(json);
        RequestResponse requestResponse = new RequestResponse();
        requestResponse.setRequestMethod("POST");
        requestResponse.setRequestHeaders(this.databucket.getHeaders());
        requestResponse.setRequestBody(payload);
        requestResponse.setRequestUrl(webTarget.getUri().toString());
        long start = System.currentTimeMillis();
        try {
            Response response = builder.post(Entity.json(json));
            requestResponse.setResponseStatus(response.getStatus());
            requestResponse.setResponseCorrect(response.getStatus() == 200);
            requestResponse.setResponseHeaders((MultivaluedMap<String, Object>)response.getHeaders());
            requestResponse.setResponseBody((String)response.readEntity(String.class));
        }
        catch (Exception e) {
            requestResponse.setResponseCorrect(false);
            requestResponse.setException(e);
        }
        finally {
            requestResponse.setResponseDuration(System.currentTimeMillis() - start);
        }
        return requestResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestResponse getData(Long id) {
        WebTarget webTarget = this.databucket.getClient().target(this.databucket.buildUrl(String.format("/api/bucket/%s/%d", this.bucketName, id)));
        Invocation.Builder builder = webTarget.request(new String[]{"application/json"});
        this.setHeaders(builder);
        RequestResponse requestResponse = new RequestResponse();
        requestResponse.setRequestMethod("GET");
        requestResponse.setRequestHeaders(this.databucket.getHeaders());
        requestResponse.setRequestUrl(webTarget.getUri().toString());
        long start = System.currentTimeMillis();
        try {
            Response response = builder.get();
            requestResponse.setResponseStatus(response.getStatus());
            requestResponse.setResponseCorrect(response.getStatus() == 200);
            requestResponse.setResponseHeaders((MultivaluedMap<String, Object>)response.getHeaders());
            requestResponse.setResponseBody((String)response.readEntity(String.class));
        }
        catch (Exception e) {
            requestResponse.setResponseCorrect(false);
            requestResponse.setException(e);
        }
        finally {
            requestResponse.setResponseDuration(System.currentTimeMillis() - start);
        }
        return requestResponse;
    }

    public RequestResponse getData(Rules rules) {
        return this.getData(rules, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestResponse getData(Rules rules, boolean random) {
        WebTarget webTarget = this.databucket.getClient().target(this.databucket.buildUrl(String.format("/api/bucket/%s/get", this.bucketName)));
        webTarget = webTarget.queryParam("limit", new Object[]{"1"});
        if (random) {
            webTarget = webTarget.queryParam("sort", new Object[]{"random"});
        }
        Invocation.Builder builder = webTarget.request(new String[]{"application/json"});
        this.setHeaders(builder);
        HashMap<String, List<Object>> json = new HashMap<String, List<Object>>();
        json.put("rules", rules.toNativeObject());
        String payload = this.gson.toJson(json);
        RequestResponse requestResponse = new RequestResponse();
        requestResponse.setRequestMethod("POST");
        requestResponse.setRequestHeaders(this.databucket.getHeaders());
        requestResponse.setRequestBody(payload);
        requestResponse.setRequestUrl(webTarget.getUri().toString());
        long start = System.currentTimeMillis();
        try {
            Response response = builder.post(Entity.json(json));
            requestResponse.setResponseStatus(response.getStatus());
            requestResponse.setResponseCorrect(response.getStatus() == 200);
            requestResponse.setResponseHeaders((MultivaluedMap<String, Object>)response.getHeaders());
            requestResponse.setResponseBody((String)response.readEntity(String.class));
        }
        catch (Exception e) {
            requestResponse.setResponseCorrect(false);
            requestResponse.setException(e);
        }
        finally {
            requestResponse.setResponseDuration(System.currentTimeMillis() - start);
        }
        return requestResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestResponse reserveData(Rules rules, boolean random) {
        WebTarget webTarget = this.databucket.getClient().target(this.databucket.buildUrl(String.format("/api/bucket/%s/reserve", this.bucketName)));
        webTarget = webTarget.queryParam("limit", new Object[]{"1"});
        if (random) {
            webTarget = webTarget.queryParam("sort", new Object[]{"random"});
        }
        Invocation.Builder builder = webTarget.request(new String[]{"application/json"});
        this.setHeaders(builder);
        HashMap<String, List<Object>> json = new HashMap<String, List<Object>>();
        json.put("rules", rules.toNativeObject());
        String payload = this.gson.toJson(json);
        RequestResponse requestResponse = new RequestResponse();
        requestResponse.setRequestMethod("POST");
        requestResponse.setRequestHeaders(this.databucket.getHeaders());
        requestResponse.setRequestBody(payload);
        requestResponse.setRequestUrl(webTarget.getUri().toString());
        long start = System.currentTimeMillis();
        try {
            Response response = builder.post(Entity.json(json));
            requestResponse.setResponseStatus(response.getStatus());
            requestResponse.setResponseCorrect(response.getStatus() == 200);
            requestResponse.setResponseHeaders((MultivaluedMap<String, Object>)response.getHeaders());
            requestResponse.setResponseBody((String)response.readEntity(String.class));
        }
        catch (Exception e) {
            requestResponse.setResponseCorrect(false);
            requestResponse.setException(e);
        }
        finally {
            requestResponse.setResponseDuration(System.currentTimeMillis() - start);
        }
        return requestResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestResponse updateData(Rules rules, Boolean reserved, Integer tagId, Map<String, Object> properties, Map<String, Object> propertiesToSet, List<String> propertiesToRemove) {
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put("rules", rules.toNativeObject());
        if (reserved != null) {
            json.put("reserved", reserved);
        }
        if (tagId != null) {
            json.put("tagId", tagId);
        }
        if (properties != null) {
            json.put("properties", properties);
        }
        if (propertiesToSet != null) {
            json.put("propertiesToSet", propertiesToSet);
        }
        if (propertiesToRemove != null) {
            json.put("propertiesToRemove", propertiesToRemove);
        }
        WebTarget webTarget = this.databucket.getClient().target(this.databucket.buildUrl(String.format("/api/bucket/%s", this.bucketName)));
        Invocation.Builder builder = webTarget.request(new String[]{"application/json"});
        this.setHeaders(builder);
        String payload = this.gson.toJson(json);
        RequestResponse requestResponse = new RequestResponse();
        requestResponse.setRequestMethod("PUT");
        requestResponse.setRequestHeaders(this.databucket.getHeaders());
        requestResponse.setRequestBody(payload);
        requestResponse.setRequestUrl(webTarget.getUri().toString());
        long start = System.currentTimeMillis();
        try {
            Response response = builder.put(Entity.json(json));
            requestResponse.setResponseStatus(response.getStatus());
            requestResponse.setResponseCorrect(response.getStatus() == 200);
            requestResponse.setResponseHeaders((MultivaluedMap<String, Object>)response.getHeaders());
            requestResponse.setResponseBody((String)response.readEntity(String.class));
        }
        catch (Exception e) {
            requestResponse.setResponseCorrect(false);
            requestResponse.setException(e);
        }
        finally {
            requestResponse.setResponseDuration(System.currentTimeMillis() - start);
        }
        return requestResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestResponse updateData(Data data) {
        HashMap<String, Object> json = new HashMap<String, Object>();
        if (data.getReserved() != null) {
            json.put("reserved", data.getReserved());
        }
        if (data.getTagId() != null) {
            json.put("tagId", data.getTagId());
        }
        if (data.getProperties() != null) {
            json.put("properties", data.getProperties());
        }
        WebTarget webTarget = this.databucket.getClient().target(this.databucket.buildUrl(String.format("/api/bucket/%s/%d", this.bucketName, data.getId())));
        Invocation.Builder builder = webTarget.request(new String[]{"application/json"});
        this.setHeaders(builder);
        String payload = this.gson.toJson(json);
        RequestResponse requestResponse = new RequestResponse();
        requestResponse.setRequestMethod("PUT");
        requestResponse.setRequestHeaders(this.databucket.getHeaders());
        requestResponse.setRequestBody(payload);
        requestResponse.setRequestUrl(webTarget.getUri().toString());
        long start = System.currentTimeMillis();
        try {
            Response response = builder.put(Entity.json((Object)data));
            requestResponse.setResponseStatus(response.getStatus());
            requestResponse.setResponseCorrect(response.getStatus() == 200);
            requestResponse.setResponseHeaders((MultivaluedMap<String, Object>)response.getHeaders());
            requestResponse.setResponseBody((String)response.readEntity(String.class));
        }
        catch (Exception e) {
            requestResponse.setResponseCorrect(false);
            requestResponse.setException(e);
        }
        finally {
            requestResponse.setResponseDuration(System.currentTimeMillis() - start);
        }
        return requestResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestResponse deleteData(Data data) {
        WebTarget webTarget = this.databucket.getClient().target(this.databucket.buildUrl(String.format("/api/bucket/%s/%d", this.bucketName, data.getId())));
        Invocation.Builder builder = webTarget.request(new String[]{"application/json"});
        this.setHeaders(builder);
        RequestResponse requestResponse = new RequestResponse();
        requestResponse.setRequestMethod("DELETE");
        requestResponse.setRequestHeaders(this.databucket.getHeaders());
        requestResponse.setRequestBody(null);
        requestResponse.setRequestUrl(webTarget.getUri().toString());
        long start = System.currentTimeMillis();
        try {
            Response response = builder.delete();
            requestResponse.setResponseStatus(response.getStatus());
            requestResponse.setResponseCorrect(response.getStatus() == 201);
            requestResponse.setResponseHeaders((MultivaluedMap<String, Object>)response.getHeaders());
            requestResponse.setResponseBody((String)response.readEntity(String.class));
        }
        catch (Exception e) {
            requestResponse.setResponseCorrect(false);
            requestResponse.setException(e);
        }
        finally {
            requestResponse.setResponseDuration(System.currentTimeMillis() - start);
        }
        return requestResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestResponse deleteData(String ids) {
        WebTarget webTarget = this.databucket.getClient().target(this.databucket.buildUrl(String.format("/api/bucket/%s/%s", this.bucketName, ids)));
        Invocation.Builder builder = webTarget.request(new String[]{"application/json"});
        this.setHeaders(builder);
        RequestResponse requestResponse = new RequestResponse();
        requestResponse.setRequestMethod("DELETE");
        requestResponse.setRequestHeaders(this.databucket.getHeaders());
        requestResponse.setRequestBody(null);
        requestResponse.setRequestUrl(webTarget.getUri().toString());
        long start = System.currentTimeMillis();
        try {
            Response response = builder.delete();
            requestResponse.setResponseStatus(response.getStatus());
            requestResponse.setResponseCorrect(response.getStatus() == 201);
            requestResponse.setResponseHeaders((MultivaluedMap<String, Object>)response.getHeaders());
            requestResponse.setResponseBody((String)response.readEntity(String.class));
        }
        catch (Exception e) {
            requestResponse.setResponseCorrect(false);
            requestResponse.setException(e);
        }
        finally {
            requestResponse.setResponseDuration(System.currentTimeMillis() - start);
        }
        return requestResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestResponse deleteData(Rules rules) {
        HashMap<String, List<Object>> json = new HashMap<String, List<Object>>();
        json.put("rules", rules.toNativeObject());
        String payload = this.gson.toJson(json);
        String url = this.databucket.buildUrl(String.format("/api/bucket/%s", this.bucketName));
        RequestResponse requestResponse = new RequestResponse();
        requestResponse.setRequestMethod("DELETE");
        requestResponse.setRequestHeaders(this.databucket.getHeaders());
        requestResponse.setRequestBody(payload);
        requestResponse.setRequestUrl(url);
        long start = System.currentTimeMillis();
        try {
            StringEntity entity = new StringEntity(payload, ContentType.APPLICATION_JSON);
            HttpEntityDelete httpEntityDelete = new HttpEntityDelete(url);
            httpEntityDelete.setHeaders(this.databucket.getHeaders2());
            httpEntityDelete.setEntity((HttpEntity)entity);
            HttpResponse response = this.databucket.getHttpClient().execute((HttpUriRequest)httpEntityDelete);
            String content = new BufferedReader(new InputStreamReader(response.getEntity().getContent(), StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
            requestResponse.setResponseStatus(response.getStatusLine().getStatusCode());
            requestResponse.setResponseCorrect(response.getStatusLine().getStatusCode() == 201);
            requestResponse.setResponseBody(content);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            requestResponse.setResponseDuration(System.currentTimeMillis() - start);
        }
        return requestResponse;
    }

    public Map<String, Object> strToJson(String text) {
        return (Map)this.gson.fromJson(text, Map.class);
    }

    public Data strToData(String dataStr) {
        return this.jsonToData((Map)this.gson.fromJson(dataStr, Map.class));
    }

    public Data jsonToData(Map<String, Object> jsonObj) {
        Object obj;
        Long id = null;
        Integer tagId = null;
        Boolean reserved = null;
        String owner = null;
        Map properties = null;
        String createdBy = null;
        Date createdAt = null;
        String modifiedBy = null;
        Date modifiedAt = null;
        if (jsonObj.containsKey("id")) {
            id = ((Double)jsonObj.get("id")).longValue();
        }
        if (jsonObj.containsKey("tagId") && jsonObj.get("tagId") != null) {
            tagId = ((Double)jsonObj.get("tagId")).intValue();
        }
        if (jsonObj.containsKey("reserved")) {
            Object objReserved = jsonObj.get("reserved");
            reserved = objReserved instanceof Boolean ? (Boolean)objReserved : Boolean.valueOf((Double)objReserved == 1.0);
        }
        if (jsonObj.containsKey("owner")) {
            owner = (String)jsonObj.get("owner");
        }
        if (jsonObj.containsKey("properties")) {
            properties = (Map)jsonObj.get("properties");
        }
        if (jsonObj.containsKey("createdBy")) {
            createdBy = (String)jsonObj.get("createdBy");
        }
        String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
        if (jsonObj.containsKey("createdAt")) {
            String dateTimeStr = (String)jsonObj.get("createdAt");
            SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT);
            try {
                createdAt = format.parse(dateTimeStr);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        if (jsonObj.containsKey("modifiedBy")) {
            modifiedBy = (String)jsonObj.get("modifiedBy");
        }
        if (jsonObj.containsKey("modifiedAt") && (obj = jsonObj.get("modifiedAt")) != null) {
            String dateTimeStr = (String)jsonObj.get("modifiedAt");
            SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT);
            try {
                modifiedAt = format.parse(dateTimeStr);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return new Data(id, tagId, reserved, owner, properties, createdAt, createdBy, modifiedAt, modifiedBy);
    }

    public Data customJsonToData(Map<String, Object> customJsonObj) {
        Object obj;
        Long id = null;
        Integer tagId = null;
        Boolean reserved = null;
        String owner = null;
        String createdBy = null;
        Date createdAt = null;
        String modifiedBy = null;
        Date modifiedAt = null;
        if (customJsonObj.containsKey("id")) {
            id = ((Double)customJsonObj.get("id")).longValue();
        }
        if (customJsonObj.containsKey("tagId") && customJsonObj.get("tagId") != null) {
            tagId = ((Double)customJsonObj.get("tagId")).intValue();
        }
        if (customJsonObj.containsKey("reserved")) {
            reserved = (Boolean)customJsonObj.get("reserved");
        }
        if (customJsonObj.containsKey("owner")) {
            owner = (String)customJsonObj.get("owner");
        }
        if (customJsonObj.containsKey("createdBy")) {
            createdBy = (String)customJsonObj.get("createdBy");
        }
        String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
        if (customJsonObj.containsKey("createdAt")) {
            String dateTimeStr = (String)customJsonObj.get("createdAt");
            SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT);
            try {
                createdAt = format.parse(dateTimeStr);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        if (customJsonObj.containsKey("modifiedBy")) {
            modifiedBy = (String)customJsonObj.get("modifiedBy");
        }
        if (customJsonObj.containsKey("modifiedAt") && (obj = customJsonObj.get("modifiedAt")) != null) {
            String dateTimeStr = (String)customJsonObj.get("modifiedAt");
            SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT);
            try {
                modifiedAt = format.parse(dateTimeStr);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        Data data = new Data(id, tagId, reserved, owner, properties, createdAt, createdBy, modifiedAt, modifiedBy);
        customJsonObj.forEach((key, value) -> {
            if (key.startsWith("$.")) {
                data.setProperty(key.substring(2), value);
            }
        });
        return data;
    }

    private List<Map<String, String>> fieldsToColumns(List<String> fields) {
        ArrayList<Map<String, String>> columns = new ArrayList<Map<String, String>>();
        fields.forEach(field -> {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("field", (String)field);
            map.put("title", (String)field);
            columns.add(map);
        });
        return columns;
    }

    public Databucket getDatabucket() {
        return this.databucket;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public Gson getGson() {
        return this.gson;
    }
}

