/*
 * Decompiled with CFR 0.152.
 */
package pl.databucket.client;

import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pl.databucket.client.BaseData;
import pl.databucket.client.CustomDataDef;
import pl.databucket.client.Databucket;
import pl.databucket.client.Mapper;
import pl.databucket.client.Operator;
import pl.databucket.client.RequestResponse;
import pl.databucket.client.Rule;
import pl.databucket.client.Rules;

public class BaseBucket {
    public final Databucket databucket;
    public final String bucketName;

    public BaseBucket(Databucket databucket, String bucketName) {
        this.databucket = databucket;
        this.bucketName = bucketName;
    }

    private void setHeaders(Invocation.Builder builder) {
        for (Map.Entry entry : this.databucket.getHeaders().entrySet()) {
            String value = ((List)entry.getValue()).toString();
            builder = builder.header((String)entry.getKey(), (Object)value.substring(1, value.length() - 1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestResponse insertData(BaseData data) {
        RequestResponse requestResponse = new RequestResponse();
        long start = System.currentTimeMillis();
        long end = 0L;
        try {
            WebTarget webTarget = this.databucket.getClient().target(this.databucket.buildUrl(String.format("/api/bucket/%s", this.bucketName)));
            Invocation.Builder builder = webTarget.request(new String[]{"application/json"});
            this.setHeaders(builder);
            String payload = Mapper.objectMapper.writeValueAsString((Object)data);
            requestResponse.setRequestMethod("POST");
            requestResponse.setRequestHeaders(this.databucket.getHeaders());
            requestResponse.setRequestBody(payload);
            requestResponse.setRequestUrl(webTarget.getUri().toString());
            start = System.currentTimeMillis();
            Response response = builder.post(Entity.json((Object)data));
            end = System.currentTimeMillis();
            requestResponse.setResponseStatus(response.getStatus());
            requestResponse.setResponseCorrect(response.getStatus() == 201);
            requestResponse.setResponseHeaders((MultivaluedMap<String, Object>)response.getHeaders());
            requestResponse.setResponseBody((String)response.readEntity(String.class));
        }
        catch (Exception e) {
            requestResponse.setResponseCorrect(false);
            requestResponse.setException(e);
        }
        finally {
            requestResponse.setResponseDuration(end - start);
        }
        return requestResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestResponse insertMultiData(List<? extends BaseData> dataList) {
        RequestResponse requestResponse = new RequestResponse();
        long start = System.currentTimeMillis();
        long end = 0L;
        try {
            WebTarget webTarget = this.databucket.getClient().target(this.databucket.buildUrl(String.format("/api/bucket/%s/multi", this.bucketName)));
            Invocation.Builder builder = webTarget.request(new String[]{"application/json"});
            this.setHeaders(builder);
            String payload = Mapper.objectMapper.writeValueAsString(dataList);
            requestResponse.setRequestMethod("POST");
            requestResponse.setRequestHeaders(this.databucket.getHeaders());
            requestResponse.setRequestBody(payload);
            requestResponse.setRequestUrl(webTarget.getUri().toString());
            start = System.currentTimeMillis();
            Response response = builder.post(Entity.json(dataList));
            end = System.currentTimeMillis();
            requestResponse.setResponseStatus(response.getStatus());
            requestResponse.setResponseCorrect(response.getStatus() == 201);
            requestResponse.setResponseHeaders((MultivaluedMap<String, Object>)response.getHeaders());
            requestResponse.setResponseBody((String)response.readEntity(String.class));
        }
        catch (Exception e) {
            requestResponse.setResponseCorrect(false);
            requestResponse.setException(e);
        }
        finally {
            if (end == 0L) {
                end = System.currentTimeMillis();
            }
            requestResponse.setResponseDuration(end - start);
        }
        return requestResponse;
    }

    public RequestResponse getData(Long id, List<CustomDataDef> customDataDefs) {
        return this.getData(new Rules(new Rule("id", Operator.equal, id)), customDataDefs);
    }

    public RequestResponse getData(Rules rules, List<CustomDataDef> customDataDefs) {
        return this.getData(rules, true, customDataDefs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestResponse getData(Rules rules, boolean random, List<CustomDataDef> customDataDefs) {
        RequestResponse requestResponse = new RequestResponse();
        long start = System.currentTimeMillis();
        long end = 0L;
        try {
            HashMap<String, List<Object>> payload = new HashMap<String, List<Object>>();
            payload.put("columns", customDataDefs);
            payload.put("rules", rules.toNativeObject());
            String payloadStr = Mapper.objectMapper.writeValueAsString(payload);
            WebTarget webTarget = this.databucket.getClient().target(this.databucket.buildUrl(String.format("/api/bucket/%s/get", this.bucketName)));
            webTarget = webTarget.queryParam("limit", new Object[]{"1"});
            if (random) {
                webTarget = webTarget.queryParam("sort", new Object[]{"random"});
            }
            Invocation.Builder builder = webTarget.request(new String[]{"application/json"});
            this.setHeaders(builder);
            requestResponse.setRequestMethod("POST");
            requestResponse.setRequestHeaders(this.databucket.getHeaders());
            requestResponse.setRequestBody(payloadStr);
            requestResponse.setRequestUrl(webTarget.getUri().toString());
            start = System.currentTimeMillis();
            Response response = builder.post(Entity.json(payload));
            end = System.currentTimeMillis();
            requestResponse.setResponseStatus(response.getStatus());
            requestResponse.setResponseCorrect(response.getStatus() == 200);
            requestResponse.setResponseHeaders((MultivaluedMap<String, Object>)response.getHeaders());
            requestResponse.setResponseBody((String)response.readEntity(String.class));
        }
        catch (Exception e) {
            requestResponse.setResponseCorrect(false);
            requestResponse.setException(e);
        }
        finally {
            if (end == 0L) {
                end = System.currentTimeMillis();
            }
            requestResponse.setResponseDuration(end - start);
        }
        return requestResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestResponse getData(Long id) {
        RequestResponse requestResponse = new RequestResponse();
        long start = System.currentTimeMillis();
        long end = 0L;
        try {
            WebTarget webTarget = this.databucket.getClient().target(this.databucket.buildUrl(String.format("/api/bucket/%s/%d", this.bucketName, id)));
            Invocation.Builder builder = webTarget.request(new String[]{"application/json"});
            this.setHeaders(builder);
            requestResponse.setRequestMethod("GET");
            requestResponse.setRequestHeaders(this.databucket.getHeaders());
            requestResponse.setRequestUrl(webTarget.getUri().toString());
            start = System.currentTimeMillis();
            Response response = builder.get();
            end = System.currentTimeMillis();
            requestResponse.setResponseStatus(response.getStatus());
            requestResponse.setResponseCorrect(response.getStatus() == 200);
            requestResponse.setResponseHeaders((MultivaluedMap<String, Object>)response.getHeaders());
            requestResponse.setResponseBody((String)response.readEntity(String.class));
        }
        catch (Exception e) {
            requestResponse.setResponseCorrect(false);
            requestResponse.setException(e);
        }
        finally {
            if (end == 0L) {
                end = System.currentTimeMillis();
            }
            requestResponse.setResponseDuration(end - start);
        }
        return requestResponse;
    }

    public RequestResponse getData(Rules rules) {
        return this.getData(rules, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestResponse getData(Rules rules, boolean random) {
        RequestResponse requestResponse = new RequestResponse();
        long start = System.currentTimeMillis();
        long end = 0L;
        try {
            WebTarget webTarget = this.databucket.getClient().target(this.databucket.buildUrl(String.format("/api/bucket/%s/get", this.bucketName)));
            webTarget = webTarget.queryParam("limit", new Object[]{"1"});
            if (random) {
                webTarget = webTarget.queryParam("sort", new Object[]{"random"});
            }
            Invocation.Builder builder = webTarget.request(new String[]{"application/json"});
            this.setHeaders(builder);
            HashMap<String, List<Object>> payloadMap = new HashMap<String, List<Object>>();
            payloadMap.put("rules", rules.toNativeObject());
            String payload = Mapper.objectMapper.writeValueAsString(payloadMap);
            requestResponse.setRequestMethod("POST");
            requestResponse.setRequestHeaders(this.databucket.getHeaders());
            requestResponse.setRequestBody(payload);
            requestResponse.setRequestUrl(webTarget.getUri().toString());
            start = System.currentTimeMillis();
            Response response = builder.post(Entity.json(payloadMap));
            end = System.currentTimeMillis();
            requestResponse.setResponseStatus(response.getStatus());
            requestResponse.setResponseCorrect(response.getStatus() == 200);
            requestResponse.setResponseHeaders((MultivaluedMap<String, Object>)response.getHeaders());
            requestResponse.setResponseBody((String)response.readEntity(String.class));
        }
        catch (Exception e) {
            requestResponse.setResponseCorrect(false);
            requestResponse.setException(e);
        }
        finally {
            if (end == 0L) {
                end = System.currentTimeMillis();
            }
            requestResponse.setResponseDuration(end - start);
        }
        return requestResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestResponse reserveData(Rules rules, boolean random) {
        RequestResponse requestResponse = new RequestResponse();
        long start = System.currentTimeMillis();
        long end = 0L;
        try {
            WebTarget webTarget = this.databucket.getClient().target(this.databucket.buildUrl(String.format("/api/bucket/%s/reserve", this.bucketName)));
            webTarget = webTarget.queryParam("limit", new Object[]{"1"});
            if (random) {
                webTarget = webTarget.queryParam("sort", new Object[]{"random"});
            }
            Invocation.Builder builder = webTarget.request(new String[]{"application/json"});
            this.setHeaders(builder);
            HashMap<String, List<Object>> payloadMap = new HashMap<String, List<Object>>();
            payloadMap.put("rules", rules.toNativeObject());
            String payload = Mapper.objectMapper.writeValueAsString(payloadMap);
            requestResponse.setRequestMethod("POST");
            requestResponse.setRequestHeaders(this.databucket.getHeaders());
            requestResponse.setRequestBody(payload);
            requestResponse.setRequestUrl(webTarget.getUri().toString());
            start = System.currentTimeMillis();
            Response response = builder.post(Entity.json(payloadMap));
            end = System.currentTimeMillis();
            requestResponse.setResponseStatus(response.getStatus());
            requestResponse.setResponseCorrect(response.getStatus() == 200);
            requestResponse.setResponseHeaders((MultivaluedMap<String, Object>)response.getHeaders());
            requestResponse.setResponseBody((String)response.readEntity(String.class));
        }
        catch (Exception e) {
            requestResponse.setResponseCorrect(false);
            requestResponse.setException(e);
        }
        finally {
            if (end == 0L) {
                end = System.currentTimeMillis();
            }
            requestResponse.setResponseDuration(end - start);
        }
        return requestResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestResponse updateData(BaseData data) {
        RequestResponse requestResponse = new RequestResponse();
        long start = System.currentTimeMillis();
        long end = 0L;
        try {
            WebTarget webTarget = this.databucket.getClient().target(this.databucket.buildUrl(String.format("/api/bucket/%s/%d", this.bucketName, data.getId())));
            Invocation.Builder builder = webTarget.request(new String[]{"application/json"});
            this.setHeaders(builder);
            String payload = Mapper.objectMapper.writeValueAsString((Object)data);
            requestResponse.setRequestMethod("PUT");
            requestResponse.setRequestHeaders(this.databucket.getHeaders());
            requestResponse.setRequestBody(payload);
            requestResponse.setRequestUrl(webTarget.getUri().toString());
            start = System.currentTimeMillis();
            Response response = builder.put(Entity.json((Object)data));
            end = System.currentTimeMillis();
            requestResponse.setResponseStatus(response.getStatus());
            requestResponse.setResponseCorrect(response.getStatus() == 200);
            requestResponse.setResponseHeaders((MultivaluedMap<String, Object>)response.getHeaders());
            requestResponse.setResponseBody((String)response.readEntity(String.class));
        }
        catch (Exception e) {
            requestResponse.setResponseCorrect(false);
            requestResponse.setException(e);
        }
        finally {
            if (end == 0L) {
                end = System.currentTimeMillis();
            }
            requestResponse.setResponseDuration(end - start);
        }
        return requestResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestResponse deleteData(BaseData data) {
        RequestResponse requestResponse = new RequestResponse();
        long start = System.currentTimeMillis();
        long end = 0L;
        try {
            WebTarget webTarget = this.databucket.getClient().target(this.databucket.buildUrl(String.format("/api/bucket/%s/%d", this.bucketName, data.getId())));
            Invocation.Builder builder = webTarget.request(new String[]{"application/json"});
            this.setHeaders(builder);
            requestResponse.setRequestMethod("DELETE");
            requestResponse.setRequestHeaders(this.databucket.getHeaders());
            requestResponse.setRequestBody(null);
            requestResponse.setRequestUrl(webTarget.getUri().toString());
            start = System.currentTimeMillis();
            Response response = builder.delete();
            end = System.currentTimeMillis();
            requestResponse.setResponseStatus(response.getStatus());
            requestResponse.setResponseCorrect(response.getStatus() == 201);
            requestResponse.setResponseHeaders((MultivaluedMap<String, Object>)response.getHeaders());
            requestResponse.setResponseBody((String)response.readEntity(String.class));
        }
        catch (Exception e) {
            requestResponse.setResponseCorrect(false);
            requestResponse.setException(e);
        }
        finally {
            if (end == 0L) {
                end = System.currentTimeMillis();
            }
            requestResponse.setResponseDuration(end - start);
        }
        return requestResponse;
    }

    public Databucket getDatabucket() {
        return this.databucket;
    }

    public String getBucketName() {
        return this.bucketName;
    }
}

