/*
 * Decompiled with CFR 0.152.
 */
package pl.databucket.examples.data.user;

import java.util.List;
import java.util.Map;
import pl.databucket.client.Bucket;
import pl.databucket.client.Data;
import pl.databucket.client.Databucket;
import pl.databucket.client.RequestResponse;
import pl.databucket.client.Rules;
import pl.databucket.examples.data.user.User;

public class BucketUsers
extends Bucket {
    public BucketUsers(Databucket databucket, String bucketName) {
        super(databucket, bucketName);
    }

    public User getUser(Rules rules) {
        RequestResponse rr = this.getData(rules);
        if (rr.isResponseCorrect()) {
            Map<String, Object> json = this.strToJson(rr.getResponseBody());
            if (json.containsKey("data")) {
                List dataList = (List)json.get("data");
                if (dataList.size() > 0) {
                    Data data = this.jsonToData((Map)dataList.get(0));
                    return new User(data);
                }
                return null;
            }
            return null;
        }
        throw new RuntimeException(rr.getErrorMessage());
    }

    public User getUser(Rules rules, List<String> fields) {
        RequestResponse rr = this.getData(rules, fields);
        if (rr.isResponseCorrect()) {
            Map<String, Object> json = this.strToJson(rr.getResponseBody());
            if (json.containsKey("customData")) {
                List dataList = (List)json.get("customData");
                if (dataList.size() > 0) {
                    Data data = this.customJsonToData((Map)dataList.get(0));
                    return new User(data);
                }
                return null;
            }
            return null;
        }
        throw new RuntimeException(rr.getErrorMessage());
    }

    public User reserveUser(Rules rules) {
        RequestResponse rr = this.reserveData(rules, true);
        if (rr.isResponseCorrect()) {
            Data data = this.strToData(rr.getResponseBody());
            return new User(data);
        }
        throw new RuntimeException(rr.getErrorMessage());
    }

    public User insertUser(User user) {
        RequestResponse rr = this.insertData(user);
        if (rr.isResponseCorrect()) {
            Data data = this.strToData(rr.getResponseBody());
            return new User(data);
        }
        throw new RuntimeException(rr.getErrorMessage());
    }

    public void insertMultiUser(List<User> userList) {
        this.insertMultiData(userList);
    }

    public User updateUser(User user) {
        RequestResponse rr = this.updateData(user);
        if (rr.isResponseCorrect()) {
            Data data = this.strToData(rr.getResponseBody());
            return new User(data);
        }
        throw new RuntimeException(rr.getErrorMessage());
    }
}

