/*
 * Decompiled with CFR 0.152.
 */
package pl.databucket.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import pl.databucket.client.Data;
import pl.databucket.client.Databucket;
import pl.databucket.client.Operator;
import pl.databucket.client.RequestResponse;
import pl.databucket.client.Rule;
import pl.databucket.client.Rules;

public class Bucket {
    private final Databucket databucket;
    private final String bucketName;
    protected final Gson gson;

    public Bucket(Databucket databucket, String bucketName) {
        this.databucket = databucket;
        this.bucketName = bucketName;
        this.gson = new GsonBuilder().disableHtmlEscaping().create();
    }

    private void setHeaders(WebResource.Builder builder) {
        for (Map.Entry<String, Object> entry : this.databucket.getHeaders().entrySet()) {
            builder = (WebResource.Builder)builder.header(entry.getKey(), entry.getValue());
        }
    }

    public RequestResponse insertData(Data data) {
        HashMap<String, Object> json = new HashMap<String, Object>();
        if (data.getReserved() != null) {
            json.put("reserved", data.getReserved());
        }
        if (data.getTagId() != null) {
            json.put("tagId", data.getTagId());
        }
        if (data.getProperties() != null) {
            json.put("properties", data.getProperties());
        }
        WebResource webResource = this.databucket.getClient().resource(this.databucket.buildUrl(String.format("/api/bucket/%s", this.bucketName)));
        WebResource.Builder builder = webResource.getRequestBuilder();
        this.setHeaders(builder);
        long start = System.currentTimeMillis();
        ClientResponse response = (ClientResponse)builder.post(ClientResponse.class, (Object)this.gson.toJson(json));
        long end = System.currentTimeMillis();
        RequestResponse requestResponse = new RequestResponse();
        requestResponse.setRequestMethod("POST");
        requestResponse.setRequestHeaders(this.databucket.getHeaders());
        requestResponse.setRequestBody(json);
        requestResponse.setRequestUrl(webResource.getURI().toString());
        requestResponse.setResponseDuration(end - start);
        requestResponse.setResponseStatus(response.getStatus());
        requestResponse.setResponseCorrect(response.getStatus() == 201);
        requestResponse.setResponseHeaders((MultivaluedMap<String, String>)response.getHeaders());
        requestResponse.setResponseBody((String)response.getEntity(String.class));
        return requestResponse;
    }

    public RequestResponse insertMultiData(List<? extends Data> dataList) {
        WebResource webResource = this.databucket.getClient().resource(this.databucket.buildUrl(String.format("/api/bucket/%s/multi", this.bucketName)));
        WebResource.Builder builder = webResource.getRequestBuilder();
        this.setHeaders(builder);
        long start = System.currentTimeMillis();
        ClientResponse response = (ClientResponse)builder.post(ClientResponse.class, (Object)this.gson.toJson(dataList));
        long end = System.currentTimeMillis();
        RequestResponse requestResponse = new RequestResponse();
        requestResponse.setRequestMethod("POST");
        requestResponse.setRequestHeaders(this.databucket.getHeaders());
        requestResponse.setRequestBody(dataList);
        requestResponse.setRequestUrl(webResource.getURI().toString());
        requestResponse.setResponseDuration(end - start);
        requestResponse.setResponseStatus(response.getStatus());
        requestResponse.setResponseCorrect(response.getStatus() == 201);
        requestResponse.setResponseHeaders((MultivaluedMap<String, String>)response.getHeaders());
        requestResponse.setResponseBody((String)response.getEntity(String.class));
        return requestResponse;
    }

    public RequestResponse getData(Long id, List<String> fields) {
        return this.getData(new Rules(new Rule("id", Operator.equal, id)), fields);
    }

    public RequestResponse getData(Rules rules, List<String> fields) {
        return this.getData(rules, true, fields);
    }

    public RequestResponse getData(Rules rules, boolean random, List<String> fields) {
        MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
        queryParams.add((Object)"limit", (Object)"1");
        if (random) {
            queryParams.add((Object)"sort", (Object)"random");
        }
        HashMap<String, List<Object>> payload = new HashMap<String, List<Object>>();
        payload.put("columns", this.fieldsToColumns(fields));
        payload.put("rules", rules.toNativeObject());
        WebResource webResource = this.databucket.getClient().resource(this.databucket.buildUrl(String.format("/api/bucket/%s/get", this.bucketName)));
        webResource = webResource.queryParams((MultivaluedMap)queryParams);
        WebResource.Builder builder = webResource.getRequestBuilder();
        this.setHeaders(builder);
        long start = System.currentTimeMillis();
        ClientResponse response = (ClientResponse)builder.post(ClientResponse.class, (Object)this.gson.toJson(payload));
        long end = System.currentTimeMillis();
        RequestResponse requestResponse = new RequestResponse();
        requestResponse.setRequestMethod("POST");
        requestResponse.setRequestHeaders(this.databucket.getHeaders());
        requestResponse.setRequestBody(rules);
        requestResponse.setRequestUrl(webResource.getURI().toString());
        requestResponse.setResponseDuration(end - start);
        requestResponse.setResponseStatus(response.getStatus());
        requestResponse.setResponseCorrect(response.getStatus() == 200);
        requestResponse.setResponseHeaders((MultivaluedMap<String, String>)response.getHeaders());
        requestResponse.setResponseBody((String)response.getEntity(String.class));
        return requestResponse;
    }

    public RequestResponse getData(Long id) {
        WebResource webResource = this.databucket.getClient().resource(this.databucket.buildUrl(String.format("/api/bucket/%s/%d", this.bucketName, id)));
        WebResource.Builder builder = webResource.getRequestBuilder();
        this.setHeaders(builder);
        long start = System.currentTimeMillis();
        ClientResponse response = (ClientResponse)builder.get(ClientResponse.class);
        long end = System.currentTimeMillis();
        RequestResponse requestResponse = new RequestResponse();
        requestResponse.setRequestMethod("GET");
        requestResponse.setRequestHeaders(this.databucket.getHeaders());
        requestResponse.setRequestUrl(webResource.getURI().toString());
        requestResponse.setResponseDuration(end - start);
        requestResponse.setResponseStatus(response.getStatus());
        requestResponse.setResponseCorrect(response.getStatus() == 200);
        requestResponse.setResponseHeaders((MultivaluedMap<String, String>)response.getHeaders());
        requestResponse.setResponseBody((String)response.getEntity(String.class));
        return requestResponse;
    }

    public RequestResponse getData(Rules rules) {
        return this.getData(rules, true);
    }

    public RequestResponse getData(Rules rules, boolean random) {
        MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
        queryParams.add((Object)"limit", (Object)"1");
        if (random) {
            queryParams.add((Object)"sort", (Object)"random");
        }
        WebResource webResource = this.databucket.getClient().resource(this.databucket.buildUrl(String.format("/api/bucket/%s/get", this.bucketName)));
        webResource = webResource.queryParams((MultivaluedMap)queryParams);
        WebResource.Builder builder = webResource.getRequestBuilder();
        this.setHeaders(builder);
        HashMap<String, List<Object>> payload = new HashMap<String, List<Object>>();
        payload.put("rules", rules.toNativeObject());
        long start = System.currentTimeMillis();
        ClientResponse response = (ClientResponse)builder.post(ClientResponse.class, (Object)this.gson.toJson(payload));
        long end = System.currentTimeMillis();
        RequestResponse requestResponse = new RequestResponse();
        requestResponse.setRequestMethod("POST");
        requestResponse.setRequestHeaders(this.databucket.getHeaders());
        requestResponse.setRequestBody(rules);
        requestResponse.setRequestUrl(webResource.getURI().toString());
        requestResponse.setResponseDuration(end - start);
        requestResponse.setResponseStatus(response.getStatus());
        requestResponse.setResponseCorrect(response.getStatus() == 200);
        requestResponse.setResponseHeaders((MultivaluedMap<String, String>)response.getHeaders());
        requestResponse.setResponseBody((String)response.getEntity(String.class));
        return requestResponse;
    }

    public RequestResponse reserveData(Rules rules, boolean random) {
        MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
        queryParams.add((Object)"limit", (Object)"1");
        if (random) {
            queryParams.add((Object)"sort", (Object)"random");
        }
        WebResource webResource = this.databucket.getClient().resource(this.databucket.buildUrl(String.format("/api/bucket/%s/reserve", this.bucketName)));
        webResource = webResource.queryParams((MultivaluedMap)queryParams);
        WebResource.Builder builder = webResource.getRequestBuilder();
        this.setHeaders(builder);
        HashMap<String, List<Object>> payload = new HashMap<String, List<Object>>();
        payload.put("rules", rules.toNativeObject());
        long start = System.currentTimeMillis();
        ClientResponse response = (ClientResponse)builder.post(ClientResponse.class, (Object)this.gson.toJson(payload));
        long end = System.currentTimeMillis();
        RequestResponse requestResponse = new RequestResponse();
        requestResponse.setRequestMethod("POST");
        requestResponse.setRequestHeaders(this.databucket.getHeaders());
        requestResponse.setRequestBody(rules);
        requestResponse.setRequestUrl(webResource.getURI().toString());
        requestResponse.setResponseDuration(end - start);
        requestResponse.setResponseStatus(response.getStatus());
        requestResponse.setResponseCorrect(response.getStatus() == 200);
        requestResponse.setResponseHeaders((MultivaluedMap<String, String>)response.getHeaders());
        requestResponse.setResponseBody((String)response.getEntity(String.class));
        return requestResponse;
    }

    public RequestResponse updateData(Data data) {
        HashMap<String, Object> json = new HashMap<String, Object>();
        if (data.getReserved() != null) {
            json.put("reserved", data.getReserved());
        }
        if (data.getTagId() != null) {
            json.put("tagId", data.getTagId());
        }
        if (data.getProperties() != null) {
            json.put("properties", data.getProperties());
        }
        WebResource webResource = this.databucket.getClient().resource(this.databucket.buildUrl(String.format("/api/bucket/%s/%d", this.bucketName, data.getId())));
        WebResource.Builder builder = webResource.getRequestBuilder();
        this.setHeaders(builder);
        long start = System.currentTimeMillis();
        ClientResponse response = (ClientResponse)builder.put(ClientResponse.class, (Object)this.gson.toJson(json));
        long end = System.currentTimeMillis();
        RequestResponse requestResponse = new RequestResponse();
        requestResponse.setRequestMethod("PUT");
        requestResponse.setRequestHeaders(this.databucket.getHeaders());
        requestResponse.setRequestBody(data);
        requestResponse.setRequestUrl(webResource.getURI().toString());
        requestResponse.setResponseDuration(end - start);
        requestResponse.setResponseStatus(response.getStatus());
        requestResponse.setResponseCorrect(response.getStatus() == 200);
        requestResponse.setResponseHeaders((MultivaluedMap<String, String>)response.getHeaders());
        requestResponse.setResponseBody((String)response.getEntity(String.class));
        return requestResponse;
    }

    public RequestResponse deleteData(Data data) {
        WebResource webResource = this.databucket.getClient().resource(this.databucket.buildUrl(String.format("/api/bucket/%s/%d", this.bucketName, data.getId())));
        WebResource.Builder builder = webResource.getRequestBuilder();
        this.setHeaders(builder);
        long start = System.currentTimeMillis();
        ClientResponse response = (ClientResponse)builder.delete(ClientResponse.class);
        long end = System.currentTimeMillis();
        RequestResponse requestResponse = new RequestResponse();
        requestResponse.setRequestMethod("DELETE");
        requestResponse.setRequestHeaders(this.databucket.getHeaders());
        requestResponse.setRequestBody(data);
        requestResponse.setRequestUrl(webResource.getURI().toString());
        requestResponse.setResponseDuration(end - start);
        requestResponse.setResponseStatus(response.getStatus());
        requestResponse.setResponseCorrect(response.getStatus() == 201);
        requestResponse.setResponseHeaders((MultivaluedMap<String, String>)response.getHeaders());
        requestResponse.setResponseBody((String)response.getEntity(String.class));
        return requestResponse;
    }

    public Map<String, Object> strToJson(String text) {
        return (Map)this.gson.fromJson(text, Map.class);
    }

    public Data strToData(String dataStr) {
        return this.jsonToData((Map)this.gson.fromJson(dataStr, Map.class));
    }

    public Data jsonToData(Map<String, Object> jsonObj) {
        Object obj;
        Long id = null;
        Integer tagId = null;
        Boolean reserved = null;
        String owner = null;
        Map properties = null;
        String createdBy = null;
        Date createdAt = null;
        String modifiedBy = null;
        Date modifiedAt = null;
        if (jsonObj.containsKey("id")) {
            id = ((Double)jsonObj.get("id")).longValue();
        }
        if (jsonObj.containsKey("tagId") && jsonObj.get("tagId") != null) {
            tagId = ((Double)jsonObj.get("tagId")).intValue();
        }
        if (jsonObj.containsKey("reserved")) {
            reserved = (Boolean)jsonObj.get("reserved");
        }
        if (jsonObj.containsKey("owner")) {
            owner = (String)jsonObj.get("owner");
        }
        if (jsonObj.containsKey("properties")) {
            properties = (Map)jsonObj.get("properties");
        }
        if (jsonObj.containsKey("createdBy")) {
            createdBy = (String)jsonObj.get("createdBy");
        }
        String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
        if (jsonObj.containsKey("createdAt")) {
            String dateTimeStr = (String)jsonObj.get("createdAt");
            SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT);
            try {
                createdAt = format.parse(dateTimeStr);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        if (jsonObj.containsKey("modifiedBy")) {
            modifiedBy = (String)jsonObj.get("modifiedBy");
        }
        if (jsonObj.containsKey("modifiedAt") && (obj = jsonObj.get("modifiedAt")) != null) {
            String dateTimeStr = (String)jsonObj.get("modifiedAt");
            SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT);
            try {
                modifiedAt = format.parse(dateTimeStr);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return new Data(id, tagId, reserved, owner, properties, createdAt, createdBy, modifiedAt, modifiedBy);
    }

    public Data customJsonToData(Map<String, Object> customJsonObj) {
        Object obj;
        Long id = null;
        Integer tagId = null;
        Boolean reserved = null;
        String owner = null;
        String createdBy = null;
        Date createdAt = null;
        String modifiedBy = null;
        Date modifiedAt = null;
        if (customJsonObj.containsKey("id")) {
            id = ((Double)customJsonObj.get("id")).longValue();
        }
        if (customJsonObj.containsKey("tagId") && customJsonObj.get("tagId") != null) {
            tagId = ((Double)customJsonObj.get("tagId")).intValue();
        }
        if (customJsonObj.containsKey("reserved")) {
            reserved = (Boolean)customJsonObj.get("reserved");
        }
        if (customJsonObj.containsKey("owner")) {
            owner = (String)customJsonObj.get("owner");
        }
        if (customJsonObj.containsKey("createdBy")) {
            createdBy = (String)customJsonObj.get("createdBy");
        }
        String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
        if (customJsonObj.containsKey("createdAt")) {
            String dateTimeStr = (String)customJsonObj.get("createdAt");
            SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT);
            try {
                createdAt = format.parse(dateTimeStr);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        if (customJsonObj.containsKey("modifiedBy")) {
            modifiedBy = (String)customJsonObj.get("modifiedBy");
        }
        if (customJsonObj.containsKey("modifiedAt") && (obj = customJsonObj.get("modifiedAt")) != null) {
            String dateTimeStr = (String)customJsonObj.get("modifiedAt");
            SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT);
            try {
                modifiedAt = format.parse(dateTimeStr);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        Data data = new Data(id, tagId, reserved, owner, properties, createdAt, createdBy, modifiedAt, modifiedBy);
        customJsonObj.forEach((key, value) -> {
            if (key.startsWith("$.")) {
                data.setProperty(key.substring(2), value);
            }
        });
        return data;
    }

    private List<Map<String, String>> fieldsToColumns(List<String> fields) {
        ArrayList<Map<String, String>> columns = new ArrayList<Map<String, String>>();
        fields.forEach(field -> {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("field", (String)field);
            map.put("title", (String)field);
            columns.add(map);
        });
        return columns;
    }
}

