/*
 * Decompiled with CFR 0.152.
 */
package pl.databucket.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandler;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.LoggingFilter;
import com.sun.jersey.client.urlconnection.HttpURLConnectionFactory;
import com.sun.jersey.client.urlconnection.URLConnectionClientHandler;
import java.net.Proxy;
import java.util.HashMap;
import java.util.Map;
import pl.databucket.client.ConnectionFactory;

public class Databucket {
    private final String serviceUrl;
    private final Gson gson;
    private final Client client;
    private final Map<String, Object> httpHeaders = new HashMap<String, Object>();

    public Databucket(String serviceUrl, boolean logs) {
        this.serviceUrl = serviceUrl;
        this.client = Client.create();
        if (logs) {
            this.client.addFilter((ClientFilter)new LoggingFilter(System.out));
        }
        this.gson = new GsonBuilder().disableHtmlEscaping().create();
    }

    public Databucket(String serviceUrl, boolean logs, Proxy proxy) {
        this.serviceUrl = serviceUrl;
        ConnectionFactory connectionFactory = new ConnectionFactory();
        connectionFactory.initializeProxy(proxy);
        URLConnectionClientHandler clientHandler = new URLConnectionClientHandler((HttpURLConnectionFactory)connectionFactory);
        this.client = new Client((ClientHandler)clientHandler);
        if (logs) {
            this.client.addFilter((ClientFilter)new LoggingFilter(System.out));
        }
        this.gson = new GsonBuilder().disableHtmlEscaping().create();
    }

    public Databucket(String serviceUrl, String username, String password, Integer projectId, boolean logs) {
        this.serviceUrl = serviceUrl;
        this.client = Client.create();
        if (logs) {
            this.client.addFilter((ClientFilter)new LoggingFilter(System.out));
        }
        this.gson = new GsonBuilder().disableHtmlEscaping().create();
        this.authenticate(username, password, projectId);
    }

    public Databucket(String serviceUrl, String username, String password, Integer projectId, boolean logs, Proxy proxy) {
        this.serviceUrl = serviceUrl;
        ConnectionFactory connectionFactory = new ConnectionFactory();
        connectionFactory.initializeProxy(proxy);
        URLConnectionClientHandler clientHandler = new URLConnectionClientHandler((HttpURLConnectionFactory)connectionFactory);
        this.client = new Client((ClientHandler)clientHandler);
        if (logs) {
            this.client.addFilter((ClientFilter)new LoggingFilter(System.out));
        }
        this.gson = new GsonBuilder().disableHtmlEscaping().create();
        this.authenticate(username, password, projectId);
    }

    public Client getClient() {
        return this.client;
    }

    public String buildUrl(String resource) {
        return this.serviceUrl + resource;
    }

    public void addHeader(String name, Object value) {
        this.httpHeaders.put(name, value);
    }

    public void setHeaders(WebResource.Builder builder) {
        for (Map.Entry<String, Object> entry : this.httpHeaders.entrySet()) {
            builder = (WebResource.Builder)builder.header(entry.getKey(), entry.getValue());
        }
    }

    public void authenticate(String username, String password, Integer projectId) {
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put("username", username);
        json.put("password", password);
        if (projectId != null) {
            json.put("projectId", projectId);
        }
        String payload = this.gson.toJson(json);
        WebResource webResource = this.client.resource(this.buildUrl("/api/public/signin"));
        WebResource.Builder builder = (WebResource.Builder)webResource.type("application/json").header("user-agent", (Object)"api-client");
        this.setHeaders(builder);
        ClientResponse response = (ClientResponse)builder.post(ClientResponse.class, (Object)payload);
        String responseBody = (String)response.getEntity(String.class);
        if (response.getStatus() != 200) {
            throw new RuntimeException("Response status: " + response.getStatus() + "\n\n" + responseBody);
        }
        Map result = (Map)this.gson.fromJson(responseBody, Map.class);
        this.addHeader("Authorization", "Bearer " + result.get("token"));
    }
}

