/*
 * Decompiled with CFR 0.152.
 */
package pl.databucket.client;

import java.util.ArrayList;
import java.util.List;
import pl.databucket.client.LogicalOperator;
import pl.databucket.client.Operator;
import pl.databucket.client.Rule;

public class Rules {
    LogicalOperator logicalOperator = LogicalOperator.and;
    List<Object> rules = new ArrayList<Object>();

    public Rules() {
    }

    public Rules(Rule rule) {
        this.rules.add(rule);
    }

    public Rules(Object leftObject, Operator operator, Object rightObject) {
        this.rules.add(new Rule(leftObject, operator, rightObject));
    }

    public Rules(LogicalOperator logicalOperator) {
        this.logicalOperator = logicalOperator;
    }

    public void addRule(Object leftObject, Operator operator, Object rightObject) {
        this.rules.add(new Rule(leftObject, operator, rightObject));
    }

    public void addRule(Rule rule) {
        this.rules.add(rule);
    }

    public void addSubRules(Rules rules) {
        this.rules.add(rules);
    }

    public List<Object> getMatchRules() {
        return this.rules;
    }

    public String toJsonString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{\"rules\":");
        if (this.rules.size() > 0) {
            stringBuilder.append("[");
            if (this.logicalOperator == LogicalOperator.and) {
                for (int i = 0; i < this.rules.size(); ++i) {
                    Object item = this.rules.get(i);
                    if (item instanceof Rules) {
                        stringBuilder.append(this.getMatchRulesStr((Rules)item));
                    } else if (item instanceof Rule) {
                        stringBuilder.append(this.getMatchRuleStr((Rule)item));
                    }
                    if (i >= this.rules.size() - 1) continue;
                    stringBuilder.append(",");
                }
            } else {
                stringBuilder.append(this.getMatchRulesStr(this));
            }
            stringBuilder.append("]");
        } else {
            stringBuilder.append("null");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String getMatchRulesStr(Rules matchRules) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{").append("\"").append(matchRules.logicalOperator.toString()).append("\": [");
        for (int i = 0; i < matchRules.getMatchRules().size(); ++i) {
            Object item = matchRules.getMatchRules().get(i);
            if (item instanceof Rules) {
                stringBuilder.append(this.getMatchRulesStr((Rules)item));
            } else if (item instanceof Rule) {
                stringBuilder.append(this.getMatchRuleStr((Rule)item));
            }
            if (i >= matchRules.getMatchRules().size() - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append("]}");
        return stringBuilder.toString();
    }

    private String getMatchRuleStr(Rule matchRule) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        if (matchRule.getLeftObject() instanceof String) {
            stringBuilder.append("\"").append(matchRule.getLeftObject()).append("\", ");
        } else {
            stringBuilder.append(matchRule.getLeftObject()).append(", ");
        }
        stringBuilder.append("\"").append(matchRule.getOperator().toString()).append("\", ");
        if (matchRule.getRightObject() instanceof String) {
            stringBuilder.append("\"").append(matchRule.getRightObject()).append("\"");
        } else {
            stringBuilder.append(matchRule.getRightObject());
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

