/*
 * Decompiled with CFR 0.152.
 */
package pl.databucket.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import pl.databucket.client.Data;
import pl.databucket.client.Databucket;
import pl.databucket.client.Rules;

public class Bucket {
    private final Databucket databucket;
    private final String bucketName;
    private final Gson gson;

    public Bucket(Databucket databucket, String bucketName) {
        this.databucket = databucket;
        this.bucketName = bucketName;
        this.gson = new GsonBuilder().disableHtmlEscaping().create();
    }

    public Databucket getDatabucket() {
        return this.databucket;
    }

    public Data insertData(Data data) {
        HashMap<String, Object> json = new HashMap<String, Object>();
        if (data.getReserved() != null) {
            json.put("reserved", data.getReserved());
        }
        if (data.getTagId() != null) {
            json.put("tagId", data.getTagId());
        }
        if (data.getProperties() != null) {
            json.put("properties", data.getProperties());
        }
        WebResource webResource = this.databucket.getClient().resource(this.databucket.buildUrl(String.format("/api/bucket/%s", this.bucketName)));
        WebResource.Builder builder = webResource.type("application/json");
        this.databucket.setHeaders(builder);
        ClientResponse response = (ClientResponse)builder.post(ClientResponse.class, (Object)this.gson.toJson(json));
        String responseBody = (String)response.getEntity(String.class);
        if (response.getStatus() == 201) {
            Map result = (Map)this.gson.fromJson(responseBody, Map.class);
            return this.castJsonToData(result);
        }
        throw new RuntimeException("Response status: " + response.getStatus() + "\n\n" + responseBody);
    }

    public Data getData(Long id) {
        WebResource webResource = this.databucket.getClient().resource(this.databucket.buildUrl(String.format("/api/bucket/%s/%d", this.bucketName, id)));
        WebResource.Builder builder = webResource.type("application/json");
        this.databucket.setHeaders(builder);
        ClientResponse response = (ClientResponse)builder.get(ClientResponse.class);
        String responseBody = (String)response.getEntity(String.class);
        if (response.getStatus() == 200) {
            Map result = (Map)this.gson.fromJson(responseBody, Map.class);
            return this.castJsonToData(result);
        }
        throw new RuntimeException("Response status: " + response.getStatus());
    }

    public Data getData(Rules rules) {
        return this.getData(rules, false);
    }

    public Data getData(Rules rules, boolean random) {
        MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
        queryParams.add((Object)"limit", (Object)"1");
        if (random) {
            queryParams.add((Object)"sort", (Object)"random");
        }
        WebResource webResource = this.databucket.getClient().resource(this.databucket.buildUrl(String.format("/api/bucket/%s/get", this.bucketName)));
        webResource = webResource.queryParams((MultivaluedMap)queryParams);
        WebResource.Builder builder = webResource.type("application/json");
        this.databucket.setHeaders(builder);
        ClientResponse response = (ClientResponse)builder.post(ClientResponse.class, (Object)rules.toJsonString());
        String responseBody = (String)response.getEntity(String.class);
        if (response.getStatus() == 200) {
            Map result = (Map)this.gson.fromJson(responseBody, Map.class);
            if (result.containsKey("data") && ((ArrayList)result.get("data")).size() > 0) {
                List dataList = (List)result.get("data");
                return this.castJsonToData((Map)dataList.get(0));
            }
            return null;
        }
        throw new RuntimeException("Response status: " + response.getStatus());
    }

    public Data reserveData(Rules matchRules, boolean random) {
        MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
        queryParams.add((Object)"limit", (Object)"1");
        if (random) {
            queryParams.add((Object)"sort", (Object)"random");
        }
        WebResource webResource = this.databucket.getClient().resource(this.databucket.buildUrl(String.format("/api/bucket/%s/reserve", this.bucketName)));
        webResource = webResource.queryParams((MultivaluedMap)queryParams);
        WebResource.Builder builder = webResource.type("application/json");
        this.databucket.setHeaders(builder);
        ClientResponse response = (ClientResponse)builder.post(ClientResponse.class, (Object)matchRules.toJsonString());
        String responseBody = (String)response.getEntity(String.class);
        if (response.getStatus() == 200) {
            Map result = (Map)this.gson.fromJson(responseBody, Map.class);
            if (result.containsKey("data") && ((ArrayList)result.get("data")).size() > 0) {
                List data = (List)result.get("data");
                return this.castJsonToData((Map)data.get(0));
            }
            return null;
        }
        throw new RuntimeException("Response status: " + response.getStatus());
    }

    public Data updateData(Data data) {
        HashMap<String, Object> json = new HashMap<String, Object>();
        if (data.getReserved() != null) {
            json.put("reserved", data.getReserved());
        }
        if (data.getTagId() != null) {
            json.put("tagId", data.getTagId());
        }
        if (data.getProperties() != null) {
            json.put("properties", data.getProperties());
        }
        WebResource webResource = this.databucket.getClient().resource(this.databucket.buildUrl(String.format("/api/bucket/%s/%d", this.bucketName, data.getId())));
        WebResource.Builder builder = webResource.type("application/json");
        this.databucket.setHeaders(builder);
        ClientResponse response = (ClientResponse)builder.put(ClientResponse.class, (Object)this.gson.toJson(json));
        String responseBody = (String)response.getEntity(String.class);
        if (response.getStatus() == 200) {
            return this.getData(data.getId());
        }
        throw new RuntimeException("Response status: " + response.getStatus() + "\n\n" + responseBody);
    }

    public void deleteData(Data data) {
        WebResource webResource = this.databucket.getClient().resource(this.databucket.buildUrl(String.format("/api/bucket/%s/%d", this.bucketName, data.getId())));
        WebResource.Builder builder = webResource.type("application/json");
        this.databucket.setHeaders(builder);
        ClientResponse response = (ClientResponse)builder.delete(ClientResponse.class);
        String responseBody = (String)response.getEntity(String.class);
        if (response.getStatus() != 200) {
            throw new RuntimeException("Response status: " + response.getStatus() + "\n\n" + responseBody);
        }
    }

    private Data castJsonToData(Map<String, Object> jsonObj) {
        Object obj;
        Long id = null;
        Integer tagId = null;
        Boolean reserved = null;
        String owner = null;
        Map properties = null;
        String createdBy = null;
        Date createdAt = null;
        String modifiedBy = null;
        Date modifiedAt = null;
        if (jsonObj.containsKey("id")) {
            id = ((Double)jsonObj.get("id")).longValue();
        }
        if (jsonObj.containsKey("tagId") && jsonObj.get("tagId") != null) {
            tagId = ((Double)jsonObj.get("tagId")).intValue();
        }
        if (jsonObj.containsKey("reserved")) {
            reserved = (Boolean)jsonObj.get("reserved");
        }
        if (jsonObj.containsKey("owner")) {
            owner = (String)jsonObj.get("owner");
        }
        if (jsonObj.containsKey("properties")) {
            properties = (Map)jsonObj.get("properties");
        }
        if (jsonObj.containsKey("createdBy")) {
            createdBy = (String)jsonObj.get("createdBy");
        }
        String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
        if (jsonObj.containsKey("createdAt")) {
            String dateTimeStr = (String)jsonObj.get("createdAt");
            SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT);
            try {
                createdAt = format.parse(dateTimeStr);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        if (jsonObj.containsKey("modifiedBy")) {
            modifiedBy = (String)jsonObj.get("modifiedBy");
        }
        if (jsonObj.containsKey("modifiedAt") && (obj = jsonObj.get("modifiedAt")) != null) {
            String dateTimeStr = (String)jsonObj.get("modifiedAt");
            SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT);
            try {
                modifiedAt = format.parse(dateTimeStr);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return new Data(id, tagId, reserved, owner, properties, createdAt, createdBy, modifiedAt, modifiedBy);
    }
}

