/*
 * Decompiled with CFR 0.152.
 */
package pl.codewise.commons.aws.cqrs.utils;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class BatchQuery<Req, Res, Type> {
    private final Req request;
    private final BiConsumer<String, Req> nextTokenSetter;
    private final Function<Req, Res> requestPerformer;
    private final Function<Res, List<Type>> partialResultExtractor;
    private final Function<Res, String> nextTokenGetter;

    private BatchQuery(Req request, BiConsumer<String, Req> nextTokenSetter, Function<Req, Res> requestPerformer, Function<Res, List<Type>> partialResultExtractor, Function<Res, String> nextTokenGetter) {
        this.request = request;
        this.nextTokenSetter = nextTokenSetter;
        this.requestPerformer = requestPerformer;
        this.partialResultExtractor = partialResultExtractor;
        this.nextTokenGetter = nextTokenGetter;
    }

    public List<Type> execute() {
        String nextToken;
        ArrayList accumulator = Lists.newArrayList();
        do {
            Res result = this.requestPerformer.apply(this.request);
            nextToken = this.nextTokenGetter.apply(result);
            this.nextTokenSetter.accept(nextToken, this.request);
            accumulator.addAll((Collection)this.partialResultExtractor.apply(result));
        } while (nextToken != null);
        return accumulator;
    }

    public static class Builder<Req, Res, Type> {
        private Req request;
        private BiConsumer<String, Req> nextTokenSetter;
        private Function<Req, Res> requestPerformer;
        private Function<Res, List<Type>> partialResultExtractor;
        private Function<Res, String> nextTokenGetter;

        public Builder<Req, Res, Type> requesting(Req request) {
            this.request = request;
            return this;
        }

        public Builder<Req, Res, Type> settingNewToken(BiConsumer<String, Req> nextTokenSetter) {
            this.nextTokenSetter = nextTokenSetter;
            return this;
        }

        public Builder<Req, Res, Type> executingRequest(Function<Req, Res> requestPerformer) {
            this.requestPerformer = requestPerformer;
            return this;
        }

        public Builder<Req, Res, Type> havingResultIn(Function<Res, List<Type>> partialResultExtractor) {
            this.partialResultExtractor = partialResultExtractor;
            return this;
        }

        public Builder<Req, Res, Type> havingNextTokenIn(Function<Res, String> nextTokenGetter) {
            this.nextTokenGetter = nextTokenGetter;
            return this;
        }

        public BatchQuery<Req, Res, Type> build() {
            return new BatchQuery(this.request, this.nextTokenSetter, this.requestPerformer, this.partialResultExtractor, this.nextTokenGetter);
        }
    }
}

