/*
 * Decompiled with CFR 0.152.
 */
package pl.codewise.commons.aws.cqrs.utils;

import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.awaitility.Awaitility;
import org.awaitility.core.ConditionTimeoutException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Awaitilities {
    private static final Logger log = LoggerFactory.getLogger(Awaitilities.class);

    public void awaitTillActionSucceed(long atMostInMilliseconds, long pollIntervalMilliseconds, long pollDelayMilliseconds, String message, Callable<Boolean> action) {
        log.info("Wait for {}: [atMost: {}ms, pollInterval: {}ms, pollDelay: {}ms]", new Object[]{message, atMostInMilliseconds, pollIntervalMilliseconds, pollDelayMilliseconds});
        AtomicInteger counter = new AtomicInteger(1);
        try {
            Awaitility.await().atMost(atMostInMilliseconds, TimeUnit.MILLISECONDS).pollInterval(pollIntervalMilliseconds, TimeUnit.MILLISECONDS).pollDelay(pollDelayMilliseconds, TimeUnit.MILLISECONDS).until(() -> {
                try {
                    log.info("Wait for {}: {}ms out of {}ms has passed", new Object[]{message, (long)counter.getAndIncrement() * pollIntervalMilliseconds, atMostInMilliseconds});
                    return (Boolean)action.call();
                }
                catch (Exception e) {
                    if (log.isDebugEnabled()) {
                        log.debug(e.getMessage(), (Throwable)e);
                    } else {
                        log.warn(e.getMessage());
                    }
                    return false;
                }
            });
        }
        catch (ConditionTimeoutException e) {
            throw message != null ? new ConditionTimeoutException(String.format("Wait for %s timed out after %dms", message, atMostInMilliseconds)) : e;
        }
        log.info("Wait for {}. DONE.", (Object)message);
    }

    public <T> T awaitForValue(int atMostInMilliseconds, int pollIntervalInMilliseconds, Callable<T> action, String defaultExceptionMessage) {
        AtomicReference<RuntimeException> lastException = new AtomicReference<RuntimeException>(new RuntimeException(defaultExceptionMessage));
        try {
            return (T)Awaitility.await().atMost((long)atMostInMilliseconds, TimeUnit.MILLISECONDS).pollInterval((long)pollIntervalInMilliseconds, TimeUnit.MILLISECONDS).until(() -> {
                try {
                    return action.call();
                }
                catch (RuntimeException e) {
                    lastException.set(e);
                    return null;
                }
            }, Matchers.notNullValue());
        }
        catch (Exception e) {
            throw lastException.get();
        }
    }

    public void awaitTillActionSucceed(long atMostInMilliseconds, long pollIntervalMilliseconds, String message, Callable<Boolean> action) {
        this.awaitTillActionSucceed(atMostInMilliseconds, pollIntervalMilliseconds, 100L, message, action);
    }

    public <T> T awaitForValueOrReturnLastValue(int atMostInMilliseconds, int pollIntervalInMilliseconds, Callable<T> action, Matcher<T> matcher, String defaultExceptionMessage) {
        AtomicReference<RuntimeException> lastException = new AtomicReference<RuntimeException>(new RuntimeException(defaultExceptionMessage));
        AtomicReference lastValue = new AtomicReference();
        try {
            return (T)Awaitility.await().atMost((long)atMostInMilliseconds, TimeUnit.MILLISECONDS).pollInterval((long)pollIntervalInMilliseconds, TimeUnit.MILLISECONDS).pollDelay((long)pollIntervalInMilliseconds, TimeUnit.MILLISECONDS).until(() -> {
                try {
                    Object result = action.call();
                    lastValue.set(result);
                    return result;
                }
                catch (RuntimeException e) {
                    lastException.set(e);
                    return null;
                }
            }, matcher);
        }
        catch (ConditionTimeoutException e) {
            Object lastResult = lastValue.get();
            if (lastResult != null) {
                return (T)lastResult;
            }
            throw lastException.get();
        }
        catch (Exception e) {
            throw lastException.get();
        }
    }
}

