/*
 * Decompiled with CFR 0.152.
 */
package pl.codewise.commons.aws.cqrs.operations.ec2;

import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.AuthorizeSecurityGroupIngressRequest;
import com.amazonaws.services.ec2.model.CreateSecurityGroupRequest;
import com.amazonaws.services.ec2.model.CreateSecurityGroupResult;
import com.amazonaws.services.ec2.model.DeleteSecurityGroupRequest;
import com.amazonaws.services.ec2.model.IpPermission;
import com.amazonaws.services.ec2.model.UserIdGroupPair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.codewise.commons.aws.cqrs.model.ec2.sg.AwsSecurityGroup;
import pl.codewise.commons.aws.cqrs.model.ec2.sg.GroupInboundRule;
import pl.codewise.commons.aws.cqrs.model.ec2.sg.InboundRule;
import pl.codewise.commons.aws.cqrs.model.ec2.sg.InboundRuleVisitor;
import pl.codewise.commons.aws.cqrs.model.ec2.sg.IpInboundRule;

public class SecurityGroupOperations {
    private static final Logger log = LoggerFactory.getLogger(SecurityGroupOperations.class);
    private final AmazonEC2 amazonEC2;

    public SecurityGroupOperations(AmazonEC2 amazonEC2) {
        this.amazonEC2 = amazonEC2;
    }

    public AwsSecurityGroup createSecurityGroup(String name, String vpc) {
        CreateSecurityGroupRequest request = this.prepareCreateSecurityGroupRequest(name, vpc);
        CreateSecurityGroupResult result = this.amazonEC2.createSecurityGroup(request);
        log.info("Security group <{}> created!", (Object)result.getGroupId());
        return new AwsSecurityGroup(result.getGroupId());
    }

    public void deleteSecurityGroup(String groupId) {
        DeleteSecurityGroupRequest request = new DeleteSecurityGroupRequest().withGroupId(groupId);
        this.amazonEC2.deleteSecurityGroup(request);
        log.info("Security group <{}> deleted!", (Object)request.getGroupId());
    }

    public void addInboundRule(InboundRule inboundRule) {
        AuthorizeSecurityGroupIngressRequest request = this.prepareAddInboundRuleRequest(inboundRule);
        this.amazonEC2.authorizeSecurityGroupIngress(request);
        log.info("Inbound rule added! Group: <{}> | Rule: <{}>", (Object)request.getGroupId(), (Object)request.getIpPermissions());
    }

    private CreateSecurityGroupRequest prepareCreateSecurityGroupRequest(String name, String vpc) {
        return new CreateSecurityGroupRequest().withGroupName(name).withDescription(name).withVpcId(vpc);
    }

    private AuthorizeSecurityGroupIngressRequest prepareAddInboundRuleRequest(InboundRule inboundRule) {
        IpPermission ipPermission = this.prepareIpPermissionSketch(inboundRule);
        inboundRule.accept(new PerTypeOfInboundRuleIpPermissionModifier(ipPermission));
        return this.prepareAuthorizeSecurityGroupIngressRequest(inboundRule.getGroupId(), ipPermission);
    }

    private AuthorizeSecurityGroupIngressRequest prepareAuthorizeSecurityGroupIngressRequest(String groupId, IpPermission ipPermission) {
        return new AuthorizeSecurityGroupIngressRequest().withGroupId(groupId).withIpPermissions(new IpPermission[]{ipPermission});
    }

    private IpPermission prepareIpPermissionSketch(InboundRule inboundRule) {
        return new IpPermission().withIpProtocol(inboundRule.getProtocol()).withFromPort(Integer.valueOf(inboundRule.getFromPort())).withToPort(Integer.valueOf(inboundRule.getToPort()));
    }

    private class PerTypeOfInboundRuleIpPermissionModifier
    implements InboundRuleVisitor {
        private final IpPermission ipPermission;

        PerTypeOfInboundRuleIpPermissionModifier(IpPermission ipPermission) {
            this.ipPermission = ipPermission;
        }

        @Override
        public void visit(IpInboundRule ipInboundRule) {
            this.ipPermission.withIpRanges(new String[]{ipInboundRule.getSource()});
        }

        @Override
        public void visit(GroupInboundRule groupInboundRule) {
            this.ipPermission.withUserIdGroupPairs(new UserIdGroupPair[]{new UserIdGroupPair().withGroupId(groupInboundRule.getSource())});
        }
    }
}

