/*
 * Decompiled with CFR 0.152.
 */
package pl.codewise.commons.aws.cqrs.operations.ec2;

import com.amazonaws.services.autoscaling.AmazonAutoScaling;
import com.amazonaws.services.autoscaling.model.BlockDeviceMapping;
import com.amazonaws.services.autoscaling.model.CreateLaunchConfigurationRequest;
import com.amazonaws.services.autoscaling.model.DeleteLaunchConfigurationRequest;
import com.amazonaws.services.autoscaling.model.Ebs;
import com.amazonaws.services.autoscaling.model.InstanceMonitoring;
import java.util.Base64;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.codewise.commons.aws.cqrs.discovery.LaunchConfigurationDiscovery;
import pl.codewise.commons.aws.cqrs.model.AwsNameBasedResource;
import pl.codewise.commons.aws.cqrs.model.ec2.AwsBlockDeviceMapping;
import pl.codewise.commons.aws.cqrs.model.ec2.AwsEbs;
import pl.codewise.commons.aws.cqrs.model.ec2.AwsLaunchConfiguration;
import pl.codewise.commons.aws.cqrs.utils.Functions;

public class LaunchConfigurationOperations {
    private static final Logger log = LoggerFactory.getLogger(LaunchConfigurationOperations.class);
    private final AmazonAutoScaling amazonAutoScaling;
    private final LaunchConfigurationDiscovery configurationDiscovery;

    public LaunchConfigurationOperations(AmazonAutoScaling amazonAutoScaling, LaunchConfigurationDiscovery configurationDiscovery) {
        this.amazonAutoScaling = amazonAutoScaling;
        this.configurationDiscovery = configurationDiscovery;
    }

    public AwsLaunchConfiguration copy(String sourceLaunchConfigurationName, AwsLaunchConfiguration newLaunchConfigurationTemplate) {
        AwsLaunchConfiguration sourceLaunchConfiguration = this.configurationDiscovery.getLaunchConfiguration(sourceLaunchConfigurationName);
        return this.createLaunchConfiguration(sourceLaunchConfiguration, newLaunchConfigurationTemplate);
    }

    public AwsLaunchConfiguration createLaunchConfiguration(AwsLaunchConfiguration launchConfiguration) {
        return this.createLaunchConfiguration(launchConfiguration, AwsLaunchConfiguration.builder().build());
    }

    private AwsLaunchConfiguration createLaunchConfiguration(AwsLaunchConfiguration sourceLaunchConfiguration, AwsLaunchConfiguration templateLaunchConfiguration) {
        CreateLaunchConfigurationRequest request = this.prepareCreateLaunchConfigurationRequest(sourceLaunchConfiguration, templateLaunchConfiguration);
        return this.createLaunchConfiguration(request);
    }

    private AwsLaunchConfiguration createLaunchConfiguration(CreateLaunchConfigurationRequest request) {
        this.amazonAutoScaling.createLaunchConfiguration(request);
        log.info("Launch configuration <{}> created!", (Object)request.getLaunchConfigurationName());
        return this.configurationDiscovery.getLaunchConfiguration(request.getLaunchConfigurationName());
    }

    public void deleteLaunchConfiguration(String launchConfigurationName) {
        DeleteLaunchConfigurationRequest request = new DeleteLaunchConfigurationRequest().withLaunchConfigurationName(launchConfigurationName);
        this.amazonAutoScaling.deleteLaunchConfiguration(request);
        log.info("Launch configuration <{}> deleted!", (Object)request.getLaunchConfigurationName());
    }

    private CreateLaunchConfigurationRequest prepareCreateLaunchConfigurationRequest(AwsLaunchConfiguration sourceLaunchConfiguration, AwsLaunchConfiguration newLaunchConfigurationTemplate) {
        return new CreateLaunchConfigurationRequest().withLaunchConfigurationName(Functions.overrideIfNotNull(newLaunchConfigurationTemplate, sourceLaunchConfiguration, AwsNameBasedResource::getId)).withImageId(Functions.overrideIfNotNull(newLaunchConfigurationTemplate, sourceLaunchConfiguration, AwsLaunchConfiguration::getImageId)).withIamInstanceProfile(Functions.overrideIfNotNull(newLaunchConfigurationTemplate, sourceLaunchConfiguration, AwsLaunchConfiguration::getIamInstanceProfile)).withKeyName(Functions.overrideIfNotNull(newLaunchConfigurationTemplate, sourceLaunchConfiguration, AwsLaunchConfiguration::getKeyName)).withInstanceType(Functions.overrideIfNotNull(newLaunchConfigurationTemplate, sourceLaunchConfiguration, AwsLaunchConfiguration::getInstanceType)).withSpotPrice(Functions.overrideIfNotNull(newLaunchConfigurationTemplate, sourceLaunchConfiguration, AwsLaunchConfiguration::getSpotPrice)).withSecurityGroups(Functions.overrideIfNotEmpty(newLaunchConfigurationTemplate, sourceLaunchConfiguration, AwsLaunchConfiguration::getSecurityGroupIds)).withUserData(this.encodeUserData(Functions.overrideIfNotNull(newLaunchConfigurationTemplate, sourceLaunchConfiguration, AwsLaunchConfiguration::getUserData))).withAssociatePublicIpAddress(Functions.overrideIfNotNull(newLaunchConfigurationTemplate, sourceLaunchConfiguration, AwsLaunchConfiguration::getAssociatePublicIpAddress)).withInstanceMonitoring(new InstanceMonitoring().withEnabled(Functions.overrideIfNotNull(newLaunchConfigurationTemplate, sourceLaunchConfiguration, AwsLaunchConfiguration::getInstanceMonitoring))).withBlockDeviceMappings(this.toBlockDeviceMappings(sourceLaunchConfiguration.getBlockDeviceMappings()));
    }

    private String encodeUserData(String userData) {
        return new String(Base64.getEncoder().encode(userData.getBytes()));
    }

    private List<BlockDeviceMapping> toBlockDeviceMappings(List<AwsBlockDeviceMapping> blockDeviceMappings) {
        return blockDeviceMappings.stream().map(this::toBlockDeviceMapping).collect(Collectors.toList());
    }

    private BlockDeviceMapping toBlockDeviceMapping(AwsBlockDeviceMapping blockDeviceMapping) {
        return new BlockDeviceMapping().withVirtualName(blockDeviceMapping.getVirtualName()).withDeviceName(blockDeviceMapping.getDeviceName()).withNoDevice(blockDeviceMapping.getNoDevice()).withEbs(this.toEbs(blockDeviceMapping.getEbs()));
    }

    private Ebs toEbs(AwsEbs ebs) {
        return ebs != null ? new Ebs().withVolumeSize(ebs.getVolumeSize()).withVolumeType(ebs.getVolumeType()).withDeleteOnTermination(ebs.getDeleteOnTermination()).withIops(ebs.getIops()).withEncrypted(ebs.getEncrypted()) : null;
    }
}

