/*
 * Decompiled with CFR 0.152.
 */
package pl.codewise.commons.aws.cqrs.operations.ec2;

import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.AssignPrivateIpAddressesRequest;
import com.amazonaws.services.ec2.model.AttachNetworkInterfaceRequest;
import com.amazonaws.services.ec2.model.CreateKeyPairRequest;
import com.amazonaws.services.ec2.model.CreateKeyPairResult;
import com.amazonaws.services.ec2.model.CreateNetworkInterfaceRequest;
import com.amazonaws.services.ec2.model.CreateNetworkInterfaceResult;
import com.amazonaws.services.ec2.model.CreateTagsRequest;
import com.amazonaws.services.ec2.model.NetworkInterface;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.TerminateInstancesRequest;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.codewise.commons.aws.cqrs.discovery.Ec2Discovery;
import pl.codewise.commons.aws.cqrs.model.AwsInstance;
import pl.codewise.commons.aws.cqrs.model.AwsNetworkInterface;
import pl.codewise.commons.aws.cqrs.model.AwsNetworkInterfaceAttachment;
import pl.codewise.commons.aws.cqrs.model.ec2.AwsResourceTag;
import pl.codewise.commons.aws.cqrs.model.ec2.Ec2KeyPair;

public class InstanceOperations {
    private static final Logger log = LoggerFactory.getLogger(InstanceOperations.class);
    private final AmazonEC2 amazonEC2;
    private final Ec2Discovery ec2Discovery;

    public InstanceOperations(AmazonEC2 amazonEC2, Ec2Discovery ec2Discovery) {
        this.amazonEC2 = amazonEC2;
        this.ec2Discovery = ec2Discovery;
    }

    public void terminateInstances(String ... instanceIds) {
        log.info("Termination of instances {}", (Object)Arrays.toString(instanceIds));
        this.amazonEC2.terminateInstances(new TerminateInstancesRequest().withInstanceIds(instanceIds));
    }

    public void tagInstanceName(String instanceId, String name) {
        this.tag(instanceId, Collections.singletonList(AwsResourceTag.create("Name", name)));
    }

    public void tag(String resourceId, List<AwsResourceTag> tags) {
        CreateTagsRequest request = new CreateTagsRequest().withResources(new String[]{resourceId}).withTags(this.toTags(tags));
        this.amazonEC2.createTags(request);
    }

    public Ec2KeyPair createKeyPair(String keyName) {
        CreateKeyPairRequest request = new CreateKeyPairRequest().withKeyName(keyName);
        CreateKeyPairResult result = this.amazonEC2.createKeyPair(request);
        return new Ec2KeyPair(result.getKeyPair().getKeyMaterial());
    }

    public void createPrivateIpAndAssignToNetworkInterface(String networkInterfaceId) {
        this.createPrivateIpsAndAssignToNetworkInterface(networkInterfaceId, 1);
    }

    public void createPrivateIpsAndAssignToNetworkInterface(String networkInterfaceId, int ipsCount) {
        AssignPrivateIpAddressesRequest request = new AssignPrivateIpAddressesRequest().withNetworkInterfaceId(networkInterfaceId).withSecondaryPrivateIpAddressCount(Integer.valueOf(ipsCount));
        this.amazonEC2.assignPrivateIpAddresses(request);
    }

    public void createNetworkInterfaceAndAssignToInstance(String instanceId, Collection<String> securityGroupIds) {
        AwsInstance instance = this.getInstance(instanceId);
        NetworkInterface newNetworkInterface = this.createNewNetworkInterface(instance.getSubnetId(), securityGroupIds);
        AttachNetworkInterfaceRequest attachRequest = new AttachNetworkInterfaceRequest().withInstanceId(instanceId).withNetworkInterfaceId(newNetworkInterface.getNetworkInterfaceId()).withDeviceIndex(Integer.valueOf(this.findFirstFreeDeviceIndex(instance.getNetworkInterfaces())));
        this.amazonEC2.attachNetworkInterface(attachRequest);
    }

    int findFirstFreeDeviceIndex(List<AwsNetworkInterface> networkInterfaces) {
        List usedIndexes = networkInterfaces.stream().map(AwsNetworkInterface::getAttachment).map(AwsNetworkInterfaceAttachment::getDeviceIndex).filter(Objects::nonNull).distinct().sorted().collect(Collectors.toList());
        for (int i = 0; i < usedIndexes.size(); ++i) {
            if (i >= (Integer)usedIndexes.get(i)) continue;
            return i;
        }
        return usedIndexes.size();
    }

    private AwsInstance getInstance(String instanceId) {
        AwsInstance instance = this.ec2Discovery.getInstance(instanceId);
        if (instance == null) {
            throw new IllegalStateException("Failed to find instance with id " + instanceId);
        }
        return instance;
    }

    private NetworkInterface createNewNetworkInterface(String subnetId, Collection<String> securityGroupIds) {
        CreateNetworkInterfaceRequest request = new CreateNetworkInterfaceRequest().withGroups(securityGroupIds).withSubnetId(subnetId);
        CreateNetworkInterfaceResult result = this.amazonEC2.createNetworkInterface(request);
        return result.getNetworkInterface();
    }

    private List<Tag> toTags(List<AwsResourceTag> tags) {
        return tags.stream().map(this::toTag).collect(Collectors.toList());
    }

    private Tag toTag(AwsResourceTag tag) {
        return new Tag().withKey(tag.key()).withValue(tag.value());
    }
}

