/*
 * Decompiled with CFR 0.152.
 */
package pl.codewise.commons.aws.cqrs.operations;

import com.amazonaws.services.route53domains.AmazonRoute53Domains;
import com.amazonaws.services.route53domains.model.ContactDetail;
import com.amazonaws.services.route53domains.model.DisableDomainAutoRenewRequest;
import com.amazonaws.services.route53domains.model.RegisterDomainRequest;
import com.amazonaws.services.route53domains.model.RegisterDomainResult;
import pl.codewise.commons.aws.cqrs.model.route53.AwsContactDetails;
import pl.codewise.commons.aws.cqrs.model.route53.AwsRegisterDomainRequest;
import pl.codewise.commons.aws.cqrs.model.route53.AwsRegisterDomainResult;

public class Route53DomainsOperations {
    private final AmazonRoute53Domains amazonRoute53Domains;

    public Route53DomainsOperations(AmazonRoute53Domains amazonRoute53Domains) {
        this.amazonRoute53Domains = amazonRoute53Domains;
    }

    public void disableDomainAutoRenewal(String domainName) {
        this.amazonRoute53Domains.disableDomainAutoRenew(new DisableDomainAutoRenewRequest().withDomainName(domainName));
    }

    public AwsRegisterDomainResult registerDomain(AwsRegisterDomainRequest request) {
        RegisterDomainRequest registerDomainRequest = this.toRegisterDomainRequest(request);
        RegisterDomainResult registerDomainResult = this.amazonRoute53Domains.registerDomain(registerDomainRequest);
        return this.toAwsRegisterDomainResult(registerDomainResult);
    }

    private AwsRegisterDomainResult toAwsRegisterDomainResult(RegisterDomainResult result) {
        return new AwsRegisterDomainResult(result.getOperationId());
    }

    private RegisterDomainRequest toRegisterDomainRequest(AwsRegisterDomainRequest request) {
        return new RegisterDomainRequest().withDomainName(request.getDomainName()).withAutoRenew(Boolean.valueOf(request.isAutoRenew())).withDurationInYears(Integer.valueOf(request.getDurationYears())).withPrivacyProtectAdminContact(Boolean.valueOf(request.isProtectAdminContact())).withPrivacyProtectRegistrantContact(Boolean.valueOf(request.isProtectRegistrantContact())).withPrivacyProtectTechContact(Boolean.valueOf(request.isProtectTechContact())).withAdminContact(this.toContactDetail(request.getAdminContact())).withRegistrantContact(this.toContactDetail(request.getRegistrantContact())).withTechContact(this.toContactDetail(request.getTechContact()));
    }

    private ContactDetail toContactDetail(AwsContactDetails details) {
        return new ContactDetail().withFirstName(details.getFirstName()).withLastName(details.getLastName()).withOrganizationName(details.getOrganizationName()).withPhoneNumber(details.getPhoneNumber()).withContactType(details.getContactType().name()).withEmail(details.getEmail()).withCountryCode(details.getCountryCode()).withCity(details.getCity()).withAddressLine1(details.getAddressLine1()).withAddressLine2(details.getAddressLine2()).withZipCode(details.getZipCode());
    }
}

