/*
 * Decompiled with CFR 0.152.
 */
package pl.codewise.commons.aws.cqrs.operations;

import com.amazonaws.services.identitymanagement.AmazonIdentityManagement;
import com.amazonaws.services.identitymanagement.model.AddRoleToInstanceProfileRequest;
import com.amazonaws.services.identitymanagement.model.AttachRolePolicyRequest;
import com.amazonaws.services.identitymanagement.model.CreateInstanceProfileRequest;
import com.amazonaws.services.identitymanagement.model.CreateInstanceProfileResult;
import com.amazonaws.services.identitymanagement.model.CreateRoleRequest;
import com.amazonaws.services.identitymanagement.model.CreateRoleResult;
import com.amazonaws.services.identitymanagement.model.DeleteInstanceProfileRequest;
import com.amazonaws.services.identitymanagement.model.DeleteRoleRequest;
import com.amazonaws.services.identitymanagement.model.DetachRolePolicyRequest;
import com.amazonaws.services.identitymanagement.model.InstanceProfile;
import com.amazonaws.services.identitymanagement.model.RemoveRoleFromInstanceProfileRequest;
import com.amazonaws.services.identitymanagement.model.Role;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.codewise.commons.aws.cqrs.discovery.IamDiscovery;
import pl.codewise.commons.aws.cqrs.model.iam.AwsIamRole;
import pl.codewise.commons.aws.cqrs.model.iam.AwsInstanceProfile;

public class IamOperations {
    private static final Logger log = LoggerFactory.getLogger(IamOperations.class);
    private final IamDiscovery iamDiscovery;
    private final AmazonIdentityManagement amazonIdentityManagement;

    public IamOperations(IamDiscovery iamDiscovery, AmazonIdentityManagement amazonIdentityManagement) {
        this.iamDiscovery = iamDiscovery;
        this.amazonIdentityManagement = amazonIdentityManagement;
    }

    public AwsInstanceProfile createInstanceProfile(String name) {
        CreateInstanceProfileRequest request = this.prepareRequestToCreateInstanceProfileWithName(name);
        CreateInstanceProfileResult result = this.amazonIdentityManagement.createInstanceProfile(request);
        log.info("Instance profile <{}> created!", (Object)request.getInstanceProfileName());
        InstanceProfile instanceProfile = result.getInstanceProfile();
        return new AwsInstanceProfile(instanceProfile.getInstanceProfileName(), instanceProfile.getArn());
    }

    public void deleteInstanceProfile(String name) {
        DeleteInstanceProfileRequest request = this.prepareDeleteInstanceProfileRequest(name);
        this.amazonIdentityManagement.deleteInstanceProfile(request);
        log.info("Instance profile <{}> deleted!", (Object)request.getInstanceProfileName());
    }

    public AwsIamRole createRole(String name) {
        CreateRoleRequest request = this.prepareRequestToCreateRoleWithName(name);
        CreateRoleResult createRoleResult = this.amazonIdentityManagement.createRole(request);
        log.info("IAM Role <{}> created!", (Object)request.getRoleName());
        return this.mapToIamRole(createRoleResult);
    }

    public void deleteRole(String roleName) {
        DeleteRoleRequest request = new DeleteRoleRequest().withRoleName(roleName);
        this.amazonIdentityManagement.deleteRole(request);
        log.info("IAM Role <{}> deleted!", (Object)request.getRoleName());
    }

    public void addRoleToInstanceProfile(String role, String profile) {
        AddRoleToInstanceProfileRequest request = this.prepareAddRoleToInstanceProfileRequest(role, profile);
        this.amazonIdentityManagement.addRoleToInstanceProfile(request);
        log.info("Role added to instance profile! Role <{}> | Instance profile <{}>", (Object)request.getRoleName(), (Object)request.getInstanceProfileName());
    }

    public void removeRolesFromInstanceProfile(String profile) {
        List<String> roles = this.iamDiscovery.getInstanceProfileRoles(profile);
        roles.forEach(role -> this.removeRoleFromInstanceProfile((String)role, profile));
    }

    public boolean attachPolicyToRole(String policyName, String role) {
        Optional<String> policy = this.iamDiscovery.getPolicyArn(policyName);
        return policy.map(arn -> {
            AttachRolePolicyRequest request = this.prepareRequestToAttachPolicyToRole((String)arn, role);
            this.amazonIdentityManagement.attachRolePolicy(request);
            log.info("Policy attached! Role <{}> | Policy <{}>", (Object)request.getRoleName(), (Object)request.getPolicyArn());
            return true;
        }).orElse(false);
    }

    public void detachAllPoliciesFromRole(String roleName) {
        List<String> attachedPolicies = this.iamDiscovery.getAttachedPoliciesArnsForRole(roleName);
        attachedPolicies.forEach(policy -> this.detachPolicyFromRole((String)policy, roleName));
    }

    private void detachPolicyFromRole(String policyArn, String roleName) {
        DetachRolePolicyRequest request = this.prepareRequestToDetachPolicy(policyArn, roleName);
        this.amazonIdentityManagement.detachRolePolicy(request);
    }

    private void removeRoleFromInstanceProfile(String role, String profile) {
        RemoveRoleFromInstanceProfileRequest request = this.prepareRemoveRoleFromInstanceProfileRequest(role, profile);
        this.amazonIdentityManagement.removeRoleFromInstanceProfile(request);
        log.info("Role removed from instance profile! Role <{}> | Instance profile <{}>", (Object)request.getRoleName(), (Object)request.getInstanceProfileName());
    }

    private CreateInstanceProfileRequest prepareRequestToCreateInstanceProfileWithName(String name) {
        return new CreateInstanceProfileRequest().withInstanceProfileName(name);
    }

    private DeleteInstanceProfileRequest prepareDeleteInstanceProfileRequest(String name) {
        return new DeleteInstanceProfileRequest().withInstanceProfileName(name);
    }

    private CreateRoleRequest prepareRequestToCreateRoleWithName(String name) {
        return new CreateRoleRequest().withRoleName(name).withAssumeRolePolicyDocument(this.getAssumeRolePolicyDocumentRawContent());
    }

    private String getAssumeRolePolicyDocumentRawContent() {
        return "{\"Version\":\"2012-10-17\",\"Statement\":[{\"Effect\":\"Allow\",\"Principal\":{\"Service\":[\"ec2.amazonaws.com\"]},\"Action\":[\"sts:AssumeRole\"]}]}";
    }

    private AwsIamRole mapToIamRole(CreateRoleResult createRoleResult) {
        Role role = createRoleResult.getRole();
        return new AwsIamRole(role.getRoleName());
    }

    private AddRoleToInstanceProfileRequest prepareAddRoleToInstanceProfileRequest(String role, String profile) {
        return new AddRoleToInstanceProfileRequest().withRoleName(role).withInstanceProfileName(profile);
    }

    private RemoveRoleFromInstanceProfileRequest prepareRemoveRoleFromInstanceProfileRequest(String role, String profile) {
        return new RemoveRoleFromInstanceProfileRequest().withRoleName(role).withInstanceProfileName(profile);
    }

    private AttachRolePolicyRequest prepareRequestToAttachPolicyToRole(String policyArn, String role) {
        return new AttachRolePolicyRequest().withRoleName(role).withPolicyArn(policyArn);
    }

    private DetachRolePolicyRequest prepareRequestToDetachPolicy(String policyArn, String roleName) {
        return new DetachRolePolicyRequest().withRoleName(roleName).withPolicyArn(policyArn);
    }
}

