/*
 * Decompiled with CFR 0.152.
 */
package pl.codewise.commons.aws.cqrs.operations;

import com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancing;
import com.amazonaws.services.elasticloadbalancing.model.AddTagsRequest;
import com.amazonaws.services.elasticloadbalancing.model.ConfigureHealthCheckRequest;
import com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerRequest;
import com.amazonaws.services.elasticloadbalancing.model.DeleteLoadBalancerRequest;
import com.amazonaws.services.elasticloadbalancing.model.DeregisterInstancesFromLoadBalancerRequest;
import com.amazonaws.services.elasticloadbalancing.model.HealthCheck;
import com.amazonaws.services.elasticloadbalancing.model.Instance;
import com.amazonaws.services.elasticloadbalancing.model.Listener;
import com.amazonaws.services.elasticloadbalancing.model.RegisterInstancesWithLoadBalancerRequest;
import com.amazonaws.services.elasticloadbalancing.model.Tag;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.codewise.commons.aws.cqrs.model.AwsInstance;
import pl.codewise.commons.aws.cqrs.model.ec2.AwsElasticLoadBalancer;
import pl.codewise.commons.aws.cqrs.model.ec2.AwsLoadBalancerHealthCheckParameters;
import pl.codewise.commons.aws.cqrs.model.ec2.AwsLoadBalancerListener;
import pl.codewise.commons.aws.cqrs.model.ec2.AwsResourceTag;
import pl.codewise.commons.aws.cqrs.model.ec2.LoadBalancerParameters;

public class ClassicLoadBalancingOperations {
    private static final Logger log = LoggerFactory.getLogger(ClassicLoadBalancingOperations.class);
    private final AmazonElasticLoadBalancing amazonElasticLoadBalancing;

    public ClassicLoadBalancingOperations(AmazonElasticLoadBalancing amazonElasticLoadBalancing) {
        this.amazonElasticLoadBalancing = amazonElasticLoadBalancing;
    }

    public void tag(String loadBalancerName, List<AwsResourceTag> tags) {
        AddTagsRequest request = new AddTagsRequest().withLoadBalancerNames(new String[]{loadBalancerName}).withTags(this.toTags(tags));
        this.amazonElasticLoadBalancing.addTags(request);
    }

    public AwsElasticLoadBalancer createLoadBalancer(LoadBalancerParameters parameters) {
        CreateLoadBalancerRequest request = this.prepareCreateLoadBalancerRequest(parameters);
        this.amazonElasticLoadBalancing.createLoadBalancer(request);
        log.info("Load balancer <{}> created!", (Object)parameters.getName());
        return new AwsElasticLoadBalancer(parameters.getName());
    }

    public void deleteLoadBalancer(String loadBalancerName) {
        DeleteLoadBalancerRequest request = new DeleteLoadBalancerRequest(loadBalancerName);
        this.amazonElasticLoadBalancing.deleteLoadBalancer(request);
        log.info("Elastic load balancer <{}> deleted!", (Object)request.getLoadBalancerName());
    }

    public void configureHealthCheckForLoadBalancer(String name, AwsLoadBalancerHealthCheckParameters parameters) {
        ConfigureHealthCheckRequest request = this.prepareConfigureHealthCheckRequest(name, parameters);
        this.amazonElasticLoadBalancing.configureHealthCheck(request);
        log.info("Health check configured! Load balancer <{}> | Parameters <{}>", (Object)name, (Object)parameters);
    }

    public void deregisterInstances(String loadBalancerName, AwsInstance ... instances) {
        this.amazonElasticLoadBalancing.deregisterInstancesFromLoadBalancer(new DeregisterInstancesFromLoadBalancerRequest(loadBalancerName, this.toInstances(instances)));
    }

    public void registerInstances(String loadBalancerName, AwsInstance ... instances) {
        this.amazonElasticLoadBalancing.registerInstancesWithLoadBalancer(new RegisterInstancesWithLoadBalancerRequest(loadBalancerName, this.toInstances(instances)));
    }

    private ConfigureHealthCheckRequest prepareConfigureHealthCheckRequest(String loadBalancer, AwsLoadBalancerHealthCheckParameters parameters) {
        return new ConfigureHealthCheckRequest().withLoadBalancerName(loadBalancer).withHealthCheck(this.prepareHealthCheck(parameters));
    }

    private HealthCheck prepareHealthCheck(AwsLoadBalancerHealthCheckParameters parameters) {
        return new HealthCheck().withTarget(parameters.getTarget()).withTimeout(Integer.valueOf(parameters.getTimeout())).withInterval(Integer.valueOf(parameters.getInterval())).withUnhealthyThreshold(Integer.valueOf(parameters.getUnhealthyThreshold())).withHealthyThreshold(Integer.valueOf(parameters.getHealthyThreshold()));
    }

    private CreateLoadBalancerRequest prepareCreateLoadBalancerRequest(LoadBalancerParameters parameters) {
        CreateLoadBalancerRequest request = new CreateLoadBalancerRequest().withLoadBalancerName(parameters.getName()).withListeners(this.toRawListeners(parameters.getListeners())).withSubnets(parameters.getSubnets()).withSecurityGroups(parameters.getSecurityGroups()).withTags(this.toTags(parameters));
        if (parameters.isInternal()) {
            request.withScheme("internal");
        }
        return request;
    }

    private Collection<Listener> toRawListeners(Collection<AwsLoadBalancerListener> awsLoadBalancerListeners) {
        return awsLoadBalancerListeners.stream().map(listener -> new Listener(listener.protocol, Integer.valueOf(listener.loadBalancerPort), Integer.valueOf(listener.instancePort)).withSSLCertificateId(listener.sslCertificateArn)).collect(Collectors.toList());
    }

    private List<Instance> toInstances(AwsInstance ... instances) {
        return Arrays.stream(instances).map(this::toInstance).collect(Collectors.toList());
    }

    private Instance toInstance(AwsInstance awsInstance) {
        return new Instance(awsInstance.getInstanceId());
    }

    private Collection<Tag> toTags(LoadBalancerParameters parameters) {
        return Stream.concat(parameters.getTags().stream().map(this::toTag), Stream.of(this.nameTag(parameters.getName()))).collect(Collectors.toList());
    }

    private List<Tag> toTags(List<AwsResourceTag> tags) {
        return tags.stream().map(this::toTag).collect(Collectors.toList());
    }

    private Tag toTag(AwsResourceTag tag) {
        return new Tag().withKey(tag.key()).withValue(tag.value());
    }

    private Tag nameTag(String name) {
        return new Tag().withKey("Name").withValue(name);
    }
}

