/*
 * Decompiled with CFR 0.152.
 */
package pl.codewise.commons.aws.cqrs.operations;

import com.amazonaws.services.autoscaling.AmazonAutoScaling;
import com.amazonaws.services.autoscaling.model.Alarm;
import com.amazonaws.services.autoscaling.model.CreateAutoScalingGroupRequest;
import com.amazonaws.services.autoscaling.model.CreateOrUpdateTagsRequest;
import com.amazonaws.services.autoscaling.model.DeleteAutoScalingGroupRequest;
import com.amazonaws.services.autoscaling.model.DeleteTagsRequest;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingGroupsRequest;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingGroupsResult;
import com.amazonaws.services.autoscaling.model.DetachInstancesRequest;
import com.amazonaws.services.autoscaling.model.DetachLoadBalancersRequest;
import com.amazonaws.services.autoscaling.model.PutScalingPolicyRequest;
import com.amazonaws.services.autoscaling.model.PutScalingPolicyResult;
import com.amazonaws.services.autoscaling.model.ResumeProcessesRequest;
import com.amazonaws.services.autoscaling.model.ScalingPolicy;
import com.amazonaws.services.autoscaling.model.SetInstanceProtectionRequest;
import com.amazonaws.services.autoscaling.model.SuspendProcessesRequest;
import com.amazonaws.services.autoscaling.model.Tag;
import com.amazonaws.services.autoscaling.model.UpdateAutoScalingGroupRequest;
import com.amazonaws.services.cloudwatch.AmazonCloudWatch;
import com.amazonaws.services.cloudwatch.model.DescribeAlarmsRequest;
import com.amazonaws.services.cloudwatch.model.DescribeAlarmsResult;
import com.amazonaws.services.cloudwatch.model.Dimension;
import com.amazonaws.services.cloudwatch.model.MetricAlarm;
import com.amazonaws.services.cloudwatch.model.PutMetricAlarmRequest;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.codewise.commons.aws.cqrs.discovery.AutoScalingDiscovery;
import pl.codewise.commons.aws.cqrs.discovery.ClassicLoadBalancingDiscovery;
import pl.codewise.commons.aws.cqrs.model.AwsAutoScalingGroup;
import pl.codewise.commons.aws.cqrs.model.AwsInstance;
import pl.codewise.commons.aws.cqrs.model.ec2.AwsAutoScalingTag;
import pl.codewise.commons.aws.cqrs.utils.Awaitilities;
import pl.codewise.commons.aws.cqrs.utils.Functions;

public class AutoScalingOperations {
    private static final Logger log = LoggerFactory.getLogger(AutoScalingOperations.class);
    private static final String ALARM_NOTIFICATION = "AlarmNotification";
    private final String region;
    private final AmazonAutoScaling autoScaling;
    private final AmazonCloudWatch cloudWatch;
    private final AutoScalingDiscovery autoScalingDiscovery;
    private final ClassicLoadBalancingDiscovery classicLoadBalancingDiscovery;
    private final Awaitilities awaitilities;
    private final long waitForNoInService;
    private final long waitForAutoScalingShutdown;
    private final long waitForInstanceStartup;
    private final Duration pollInterval;

    public AutoScalingOperations(String region, AmazonAutoScaling autoScaling, AmazonCloudWatch cloudWatch, AutoScalingDiscovery autoScalingDiscovery, ClassicLoadBalancingDiscovery classicLoadBalancingDiscovery, Awaitilities awaitilities, long waitForNoInService, long waitForAutoScalingShutdown, long waitForInstanceStartup, long pollInterval) {
        this.region = region;
        this.autoScaling = autoScaling;
        this.autoScalingDiscovery = autoScalingDiscovery;
        this.awaitilities = awaitilities;
        this.classicLoadBalancingDiscovery = classicLoadBalancingDiscovery;
        this.waitForNoInService = waitForNoInService;
        this.waitForAutoScalingShutdown = waitForAutoScalingShutdown;
        this.waitForInstanceStartup = waitForInstanceStartup;
        this.pollInterval = Duration.ofMillis(pollInterval);
        this.cloudWatch = cloudWatch;
    }

    public AwsAutoScalingGroup create(AwsAutoScalingGroup awsAutoScalingGroupTemplate) {
        this.autoScaling.createAutoScalingGroup(this.newCreateAutoScalingGroupRequest(awsAutoScalingGroupTemplate));
        log.info("Auto scaling group <{}> created!", (Object)awsAutoScalingGroupTemplate.getLaunchConfigurationName());
        return this.autoScalingDiscovery.getAutoScalingGroupByName(awsAutoScalingGroupTemplate.getAutoScalingGroupName());
    }

    public AwsAutoScalingGroup copy(String sourceAutoScalingGroupName, AwsAutoScalingGroup newAutoScalingGroupTemplate) {
        AwsAutoScalingGroup sourceAutoScalingGroup = this.autoScalingDiscovery.getAutoScalingGroupByName(sourceAutoScalingGroupName);
        this.autoScaling.createAutoScalingGroup(this.newCreateAutoScalingGroupRequest(newAutoScalingGroupTemplate, sourceAutoScalingGroup));
        return this.autoScalingDiscovery.getAutoScalingGroupByName(newAutoScalingGroupTemplate.getAutoScalingGroupName());
    }

    public void copyScalingPolicies(String sourceAutoScalingGroupName, String targetAutoScalingGroupName, String newAlarmSuffix) {
        List<ScalingPolicy> sourceScalingPolicies = this.autoScalingDiscovery.getScalingPolicies(sourceAutoScalingGroupName).getPolicies();
        sourceScalingPolicies.forEach(policy -> this.copyScalingPolicyWithAlarms((ScalingPolicy)policy, targetAutoScalingGroupName, newAlarmSuffix));
    }

    public void deleteForcefully(String autoScalingGroupName) {
        DeleteAutoScalingGroupRequest request = new DeleteAutoScalingGroupRequest().withAutoScalingGroupName(autoScalingGroupName).withForceDelete(Boolean.valueOf(true));
        this.autoScaling.deleteAutoScalingGroup(request);
        log.info("Auto scaling group <{}> deleted!", (Object)request.getAutoScalingGroupName());
    }

    public void setSizes(String sourceAutoScalingGroupName, int minCapacity, int desiredCapacity, int maxCapacity) {
        UpdateAutoScalingGroupRequest request = new UpdateAutoScalingGroupRequest().withAutoScalingGroupName(sourceAutoScalingGroupName).withMinSize(Integer.valueOf(minCapacity)).withDesiredCapacity(Integer.valueOf(desiredCapacity)).withMaxSize(Integer.valueOf(maxCapacity));
        this.updateAutoScalingGroup(request);
    }

    public void setLaunchConfiguration(String autoScalingGroupName, String newLaunchConfigurationName) {
        UpdateAutoScalingGroupRequest request = new UpdateAutoScalingGroupRequest().withAutoScalingGroupName(autoScalingGroupName).withLaunchConfigurationName(newLaunchConfigurationName);
        this.updateAutoScalingGroup(request);
    }

    public void setTerminationPolicies(String autoScalingGroupName, Collection<String> terminationPolicies) {
        UpdateAutoScalingGroupRequest request = new UpdateAutoScalingGroupRequest().withAutoScalingGroupName(autoScalingGroupName).withTerminationPolicies(terminationPolicies);
        this.updateAutoScalingGroup(request);
    }

    public void detachInstances(String autoScalingGroupName, String ... instanceIds) {
        this.detachInstances(autoScalingGroupName, false, instanceIds);
    }

    public void detachInstancesAndDecrementDesired(String autoScalingGroupName, String ... instanceIds) {
        this.detachInstances(autoScalingGroupName, true, instanceIds);
    }

    public void removeAutoScalingGroup(String sourceAutoScalingGroupName) {
        this.setSizes(sourceAutoScalingGroupName, 0, 0, 0);
        this.awaitilities.awaitTillActionSucceed(this.waitForNoInService, this.pollInterval.toMillis(), String.format("%s to have no instances", sourceAutoScalingGroupName), () -> this.autoScalingDiscovery.getAutoScalingGroupRaw(sourceAutoScalingGroupName).getInstances().isEmpty());
        this.awaitilities.awaitTillActionSucceed(this.waitForNoInService, this.pollInterval.toMillis(), String.format("%s to have no scaling activities in progress", sourceAutoScalingGroupName), () -> this.autoScalingDiscovery.getAutoScalingActivitiesInProgress(sourceAutoScalingGroupName).isEmpty());
        this.autoScaling.deleteAutoScalingGroup(new DeleteAutoScalingGroupRequest().withAutoScalingGroupName(sourceAutoScalingGroupName));
        this.awaitilities.awaitTillActionSucceed(this.waitForAutoScalingShutdown, this.pollInterval.toMillis(), String.format("%s to be completely deleted", sourceAutoScalingGroupName), () -> {
            DescribeAutoScalingGroupsResult describeAutoScalingGroupsResult = this.autoScaling.describeAutoScalingGroups(new DescribeAutoScalingGroupsRequest().withAutoScalingGroupNames(new String[]{sourceAutoScalingGroupName}));
            List autoScalingGroups = describeAutoScalingGroupsResult.getAutoScalingGroups();
            return autoScalingGroups.stream().filter(autoScalingGroup -> !"Delete in progress".equals(autoScalingGroup.getStatus())).count() == 0L;
        });
    }

    public void detachLoadBalancers(String targetAutoScalingGroupName) {
        AwsAutoScalingGroup autoScalingGroup = this.autoScalingDiscovery.getAutoScalingGroupByName(targetAutoScalingGroupName);
        List<String> loadBalancerNames = autoScalingGroup.getLoadBalancerNames();
        if (loadBalancerNames.isEmpty()) {
            log.info("No load balancer associated with the Auto Scaling group {} in region {}.", (Object)targetAutoScalingGroupName, (Object)this.region);
            return;
        }
        this.autoScaling.detachLoadBalancers(new DetachLoadBalancersRequest().withAutoScalingGroupName(targetAutoScalingGroupName).withLoadBalancerNames(loadBalancerNames));
    }

    public void waitForAsgToChangeSize(String newAutoScalingGroupName, int newAsgSize) {
        this.awaitilities.awaitTillActionSucceed((long)newAsgSize * this.waitForInstanceStartup, this.pollInterval.toMillis(), String.format("%s to have %d instances in service", newAutoScalingGroupName, newAsgSize), () -> {
            AwsAutoScalingGroup asg = this.autoScalingDiscovery.getAutoScalingGroupByName(newAutoScalingGroupName);
            List<AwsInstance> instances = asg.getAwsInstances();
            long runningInstancesCount = instances.stream().filter(AwsInstance::isRunning).count();
            return runningInstancesCount == (long)newAsgSize && this.allInstancesRegisteredInLoadBalancers(asg);
        });
    }

    public void createOrUpdateTag(AwsAutoScalingTag tag) {
        this.createOrUpdateTags(Collections.singletonList(tag));
    }

    public void createOrUpdateTags(List<AwsAutoScalingTag> tags) {
        CreateOrUpdateTagsRequest createOrUpdateTagsRequest = new CreateOrUpdateTagsRequest().withTags(this.mapAwsTags(tags));
        this.autoScaling.createOrUpdateTags(createOrUpdateTagsRequest);
    }

    public void deleteTag(AwsAutoScalingTag tag) {
        DeleteTagsRequest request = new DeleteTagsRequest().withTags(this.mapAwsTags(Collections.singletonList(tag)));
        this.autoScaling.deleteTags(request);
    }

    public void setScaleInProtection(String autoScalingGroupName, String instanceId, boolean isProtected) {
        this.autoScaling.setInstanceProtection(new SetInstanceProtectionRequest().withInstanceIds(new String[]{instanceId}).withAutoScalingGroupName(autoScalingGroupName).withProtectedFromScaleIn(Boolean.valueOf(isProtected)));
    }

    public void freeze(String autoScalingGroupName) {
        this.autoScaling.suspendProcesses(new SuspendProcessesRequest().withAutoScalingGroupName(autoScalingGroupName).withScalingProcesses(new String[]{ALARM_NOTIFICATION}));
    }

    public void unfreeze(String autoScalingGroupName) {
        this.autoScaling.resumeProcesses(new ResumeProcessesRequest().withAutoScalingGroupName(autoScalingGroupName).withScalingProcesses(new String[]{ALARM_NOTIFICATION}));
    }

    private void updateAutoScalingGroup(UpdateAutoScalingGroupRequest request) {
        this.autoScaling.updateAutoScalingGroup(request);
    }

    private void detachInstances(String autoScalingGroupName, boolean shouldDecrementDesired, String ... instanceIds) {
        this.autoScaling.detachInstances(new DetachInstancesRequest().withAutoScalingGroupName(autoScalingGroupName).withInstanceIds(instanceIds).withShouldDecrementDesiredCapacity(Boolean.valueOf(shouldDecrementDesired)));
    }

    private void copyScalingPolicyWithAlarms(ScalingPolicy sourceScalingPolicy, String targetAutoScalingGroupName, String newAlarmSuffix) {
        PutScalingPolicyResult putScalingPolicyResult = this.autoScaling.putScalingPolicy(this.newPutScalingPolicyRequest(targetAutoScalingGroupName, sourceScalingPolicy));
        String newPolicyArn = putScalingPolicyResult.getPolicyARN();
        DescribeAlarmsResult describeAlarmsResult = this.cloudWatch.describeAlarms(this.newDescribeAlarmsRequest(sourceScalingPolicy.getAlarms()));
        describeAlarmsResult.getMetricAlarms().stream().map(metricAlarm -> this.newPutMetricAlarmRequest((MetricAlarm)metricAlarm, targetAutoScalingGroupName, newPolicyArn, newAlarmSuffix)).forEach(arg_0 -> ((AmazonCloudWatch)this.cloudWatch).putMetricAlarm(arg_0));
    }

    private CreateAutoScalingGroupRequest newCreateAutoScalingGroupRequest(AwsAutoScalingGroup newAutoScalingGroup, AwsAutoScalingGroup sourceAutoScalingGroup) {
        return new CreateAutoScalingGroupRequest().withAutoScalingGroupName(newAutoScalingGroup.getAutoScalingGroupName()).withMinSize(Functions.overrideIfNotNull(newAutoScalingGroup, sourceAutoScalingGroup, AwsAutoScalingGroup::getMinSize)).withMaxSize(Functions.overrideIfNotNull(newAutoScalingGroup, sourceAutoScalingGroup, AwsAutoScalingGroup::getMaxSize)).withDesiredCapacity(Functions.overrideIfNotNull(newAutoScalingGroup, sourceAutoScalingGroup, AwsAutoScalingGroup::getDesiredCapacity)).withLaunchConfigurationName(Functions.overrideIfNotNull(newAutoScalingGroup, sourceAutoScalingGroup, AwsAutoScalingGroup::getLaunchConfigurationName)).withDefaultCooldown(Functions.overrideIfNotNull(newAutoScalingGroup, sourceAutoScalingGroup, AwsAutoScalingGroup::getDefaultCooldown)).withAvailabilityZones(Functions.overrideIfNotEmpty(newAutoScalingGroup, sourceAutoScalingGroup, AwsAutoScalingGroup::getAvailabilityZones)).withLoadBalancerNames(Functions.overrideIfNotEmpty(newAutoScalingGroup, sourceAutoScalingGroup, AwsAutoScalingGroup::getLoadBalancerNames)).withHealthCheckType(Functions.overrideIfNotNull(newAutoScalingGroup, sourceAutoScalingGroup, AwsAutoScalingGroup::getHealthCheckType)).withHealthCheckGracePeriod(Functions.overrideIfNotNull(newAutoScalingGroup, sourceAutoScalingGroup, AwsAutoScalingGroup::getHealthCheckGracePeriod)).withPlacementGroup(Functions.overrideIfNotNull(newAutoScalingGroup, sourceAutoScalingGroup, AwsAutoScalingGroup::getPlacementGroup)).withVPCZoneIdentifier(Functions.overrideIfNotNull(newAutoScalingGroup, sourceAutoScalingGroup, AwsAutoScalingGroup::getVPCZoneIdentifier)).withNewInstancesProtectedFromScaleIn(Functions.overrideIfNotNull(newAutoScalingGroup, sourceAutoScalingGroup, AwsAutoScalingGroup::isNewInstancesProtectedFromScaleIn)).withTags(this.mapAwsTags(Functions.overrideIfNotEmpty(newAutoScalingGroup, sourceAutoScalingGroup, AwsAutoScalingGroup::getTags), newAutoScalingGroup.getAutoScalingGroupName())).withTerminationPolicies(Functions.overrideIfNotEmpty(newAutoScalingGroup, sourceAutoScalingGroup, AwsAutoScalingGroup::getTerminationPolicies));
    }

    private CreateAutoScalingGroupRequest newCreateAutoScalingGroupRequest(AwsAutoScalingGroup sourceAutoScalingGroup) {
        return new CreateAutoScalingGroupRequest().withAutoScalingGroupName(sourceAutoScalingGroup.getAutoScalingGroupName()).withMinSize(sourceAutoScalingGroup.getMinSize()).withMaxSize(sourceAutoScalingGroup.getMaxSize()).withDesiredCapacity(sourceAutoScalingGroup.getDesiredCapacity()).withLaunchConfigurationName(sourceAutoScalingGroup.getLaunchConfigurationName()).withDefaultCooldown(sourceAutoScalingGroup.getDefaultCooldown()).withAvailabilityZones(sourceAutoScalingGroup.getAvailabilityZones()).withLoadBalancerNames(sourceAutoScalingGroup.getLoadBalancerNames()).withHealthCheckType(sourceAutoScalingGroup.getHealthCheckType()).withHealthCheckGracePeriod(sourceAutoScalingGroup.getHealthCheckGracePeriod()).withPlacementGroup(sourceAutoScalingGroup.getPlacementGroup()).withVPCZoneIdentifier(sourceAutoScalingGroup.getVPCZoneIdentifier()).withNewInstancesProtectedFromScaleIn(sourceAutoScalingGroup.isNewInstancesProtectedFromScaleIn()).withTags(this.mapAwsTags(sourceAutoScalingGroup.getTags())).withTerminationPolicies(sourceAutoScalingGroup.getTerminationPolicies());
    }

    private PutScalingPolicyRequest newPutScalingPolicyRequest(String newAutoScalingGroupName, ScalingPolicy policy) {
        return new PutScalingPolicyRequest().withAutoScalingGroupName(newAutoScalingGroupName).withPolicyName(policy.getPolicyName()).withPolicyType(policy.getPolicyType()).withCooldown(policy.getCooldown()).withEstimatedInstanceWarmup(policy.getEstimatedInstanceWarmup()).withMetricAggregationType(policy.getMetricAggregationType()).withAdjustmentType(policy.getAdjustmentType()).withMinAdjustmentMagnitude(policy.getMinAdjustmentMagnitude()).withMinAdjustmentStep(policy.getMinAdjustmentStep()).withScalingAdjustment(policy.getScalingAdjustment()).withStepAdjustments((Collection)policy.getStepAdjustments());
    }

    private PutMetricAlarmRequest newPutMetricAlarmRequest(MetricAlarm sourceMetricAlarm, String targetAutoScalingGroupName, String newPolicyArn, String newAlarmSuffix) {
        return new PutMetricAlarmRequest().withAlarmName(sourceMetricAlarm.getAlarmName() + newAlarmSuffix).withAlarmDescription(sourceMetricAlarm.getAlarmDescription()).withActionsEnabled(sourceMetricAlarm.getActionsEnabled()).withAlarmActions(new String[]{newPolicyArn}).withMetricName(sourceMetricAlarm.getMetricName()).withNamespace(sourceMetricAlarm.getNamespace()).withStatistic(sourceMetricAlarm.getStatistic()).withExtendedStatistic(sourceMetricAlarm.getExtendedStatistic()).withDimensions(this.mapSourceDimensions(sourceMetricAlarm.getDimensions(), targetAutoScalingGroupName)).withPeriod(sourceMetricAlarm.getPeriod()).withUnit(sourceMetricAlarm.getUnit()).withEvaluationPeriods(sourceMetricAlarm.getEvaluationPeriods()).withThreshold(sourceMetricAlarm.getThreshold()).withComparisonOperator(sourceMetricAlarm.getComparisonOperator());
    }

    private DescribeAlarmsRequest newDescribeAlarmsRequest(List<Alarm> alarms) {
        return new DescribeAlarmsRequest().withAlarmNames((Collection)alarms.stream().map(Alarm::getAlarmName).collect(Collectors.toList()));
    }

    private boolean allInstancesRegisteredInLoadBalancers(AwsAutoScalingGroup asg) {
        List<AwsInstance> awsInstances = asg.getAwsInstances();
        return asg.getLoadBalancerNames().stream().allMatch(elbName -> this.classicLoadBalancingDiscovery.areInstancesInService((String)elbName, awsInstances));
    }

    private List<Tag> mapAwsTags(List<AwsAutoScalingTag> tags) {
        return tags.stream().map(tag -> new Tag().withResourceId(tag.getResourceId()).withKey(tag.getKey()).withValue(tag.getValue()).withPropagateAtLaunch(tag.getPropagateAtLaunch()).withResourceType(tag.resourceType())).collect(Collectors.toList());
    }

    private List<Tag> mapAwsTags(List<AwsAutoScalingTag> tags, String resourceId) {
        return tags.stream().map(tag -> new Tag().withResourceId(resourceId).withKey(tag.getKey()).withValue(tag.getValue()).withPropagateAtLaunch(tag.getPropagateAtLaunch()).withResourceType(tag.resourceType())).collect(Collectors.toList());
    }

    private List<Dimension> mapSourceDimensions(List<Dimension> sourceDimensions, String targetAutoScalingGroupName) {
        return Optional.ofNullable(sourceDimensions).orElse(Collections.emptyList()).stream().map(dimension -> {
            if (dimension.getName().equals("AutoScalingGroupName")) {
                return new Dimension().withName("AutoScalingGroupName").withValue(targetAutoScalingGroupName);
            }
            return dimension;
        }).collect(Collectors.toList());
    }
}

