/*
 * Decompiled with CFR 0.152.
 */
package pl.codewise.commons.aws.cqrs.model.s3;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import pl.codewise.commons.aws.cqrs.model.AwsResource;
import pl.codewise.commons.aws.cqrs.model.AwsResourceVisitor;

public class AwsS3Object
implements AwsResource {
    private final String bucket;
    private final String key;

    public AwsS3Object(String bucket, String key) {
        this.bucket = bucket;
        this.key = key;
    }

    public static AwsS3Object in(String bucket, String key) {
        return new AwsS3Object(bucket, key);
    }

    public String getKey() {
        return this.key;
    }

    public String getBucket() {
        return this.bucket;
    }

    @Override
    public String getId() {
        return String.join((CharSequence)"/", this.bucket, this.key);
    }

    @Override
    public void accept(AwsResourceVisitor visitor) {
        visitor.visit(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AwsS3Object that = (AwsS3Object)o;
        return Objects.equals(this.bucket, that.bucket) && Objects.equals(this.key, that.key);
    }

    public int hashCode() {
        return Objects.hash(this.bucket, this.key);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("bucket", (Object)this.bucket).add("key", (Object)this.key).toString();
    }
}

