/*
 * Decompiled with CFR 0.152.
 */
package pl.codewise.commons.aws.cqrs.model.route53;

import com.google.common.base.Objects;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import pl.codewise.commons.aws.cqrs.model.route53.AwsContactDetails;

public class AwsRegisterDomainRequest {
    private final String domainName;
    private final boolean autoRenew;
    private final int durationYears;
    private final boolean protectAdminContact;
    private final boolean protectRegistrantContact;
    private final boolean protectTechContact;
    private final AwsContactDetails adminContact;
    private final AwsContactDetails registrantContact;
    private final AwsContactDetails techContact;

    private AwsRegisterDomainRequest(String domainName, boolean autoRenew, int durationYears, boolean protectAdminContact, boolean protectRegistrantContact, boolean protectTechContact, AwsContactDetails adminContact, AwsContactDetails registrantContact, AwsContactDetails techContact) {
        this.domainName = domainName;
        this.autoRenew = autoRenew;
        this.durationYears = durationYears;
        this.protectAdminContact = protectAdminContact;
        this.protectRegistrantContact = protectRegistrantContact;
        this.protectTechContact = protectTechContact;
        this.adminContact = adminContact;
        this.registrantContact = registrantContact;
        this.techContact = techContact;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AwsRegisterDomainRequest that = (AwsRegisterDomainRequest)o;
        return this.autoRenew == that.autoRenew && this.durationYears == that.durationYears && this.protectAdminContact == that.protectAdminContact && this.protectRegistrantContact == that.protectRegistrantContact && this.protectTechContact == that.protectTechContact && Objects.equal((Object)this.domainName, (Object)that.domainName) && Objects.equal((Object)this.adminContact, (Object)that.adminContact) && Objects.equal((Object)this.registrantContact, (Object)that.registrantContact) && Objects.equal((Object)this.techContact, (Object)that.techContact);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.domainName, this.autoRenew, this.durationYears, this.protectAdminContact, this.protectRegistrantContact, this.protectTechContact, this.adminContact, this.registrantContact, this.techContact});
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this).toString();
    }

    public String getDomainName() {
        return this.domainName;
    }

    public boolean isAutoRenew() {
        return this.autoRenew;
    }

    public int getDurationYears() {
        return this.durationYears;
    }

    public boolean isProtectAdminContact() {
        return this.protectAdminContact;
    }

    public boolean isProtectRegistrantContact() {
        return this.protectRegistrantContact;
    }

    public boolean isProtectTechContact() {
        return this.protectTechContact;
    }

    public AwsContactDetails getAdminContact() {
        return this.adminContact;
    }

    public AwsContactDetails getRegistrantContact() {
        return this.registrantContact;
    }

    public AwsContactDetails getTechContact() {
        return this.techContact;
    }

    public static class Builder {
        private String domainName;
        private boolean autoRenew;
        private int durationYears;
        private boolean protectAdminContact;
        private boolean protectRegistrantContact;
        private boolean protectTechContact;
        private AwsContactDetails adminContact;
        private AwsContactDetails registrantContact;
        private AwsContactDetails techContact;

        public Builder withDomainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public Builder withAutoRenew(boolean autoRenew) {
            this.autoRenew = autoRenew;
            return this;
        }

        public Builder withDurationYears(int durationYears) {
            this.durationYears = durationYears;
            return this;
        }

        public Builder withProtectAdminContact(boolean protectAdminContact) {
            this.protectAdminContact = protectAdminContact;
            return this;
        }

        public Builder withProtectRegistrantContact(boolean protectRegistrantContact) {
            this.protectRegistrantContact = protectRegistrantContact;
            return this;
        }

        public Builder withProtectTechContact(boolean protectTechContact) {
            this.protectTechContact = protectTechContact;
            return this;
        }

        public Builder withAdminContact(AwsContactDetails adminContact) {
            this.adminContact = adminContact;
            return this;
        }

        public Builder withRegistrantContact(AwsContactDetails registrantContact) {
            this.registrantContact = registrantContact;
            return this;
        }

        public Builder withTechContact(AwsContactDetails techContact) {
            this.techContact = techContact;
            return this;
        }

        public AwsRegisterDomainRequest build() {
            return new AwsRegisterDomainRequest(this.domainName, this.autoRenew, this.durationYears, this.protectAdminContact, this.protectRegistrantContact, this.protectTechContact, this.adminContact, this.registrantContact, this.techContact);
        }
    }
}

