/*
 * Decompiled with CFR 0.152.
 */
package pl.codewise.commons.aws.cqrs.model.route53;

import com.google.common.base.Objects;
import java.util.List;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import pl.codewise.commons.aws.cqrs.model.route53.AwsAliasTarget;
import pl.codewise.commons.aws.cqrs.model.route53.AwsResourceRecord;

public class AwsRecordSet {
    private final String name;
    private final String type;
    private final String region;
    private final Long ttl;
    private final String setIdentifier;
    private final AwsAliasTarget aliasTarget;
    private final Boolean multiValueAnswer;
    private final String healthCheckId;
    private final List<AwsResourceRecord> resourceRecords;

    public AwsRecordSet(String name, String type, String region, Long ttl, String setIdentifier, AwsAliasTarget aliasTarget, Boolean multiValueAnswer, String healthCheckId, List<AwsResourceRecord> resourceRecords) {
        this.name = name;
        this.type = type;
        this.region = region;
        this.ttl = ttl;
        this.setIdentifier = setIdentifier;
        this.aliasTarget = aliasTarget;
        this.multiValueAnswer = multiValueAnswer;
        this.healthCheckId = healthCheckId;
        this.resourceRecords = resourceRecords;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AwsRecordSet that = (AwsRecordSet)o;
        return Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.type, (Object)that.type) && Objects.equal((Object)this.region, (Object)that.region) && Objects.equal((Object)this.ttl, (Object)that.ttl) && Objects.equal((Object)this.setIdentifier, (Object)that.setIdentifier) && Objects.equal((Object)this.aliasTarget, (Object)that.aliasTarget) && Objects.equal((Object)this.multiValueAnswer, (Object)that.multiValueAnswer) && Objects.equal(this.resourceRecords, that.resourceRecords);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.type, this.region, this.ttl, this.setIdentifier, this.aliasTarget, this.multiValueAnswer, this.resourceRecords});
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this).toString();
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getRegion() {
        return this.region;
    }

    public Long getTtl() {
        return this.ttl;
    }

    public String getSetIdentifier() {
        return this.setIdentifier;
    }

    public AwsAliasTarget getAliasTarget() {
        return this.aliasTarget;
    }

    public Boolean getMultiValueAnswer() {
        return this.multiValueAnswer;
    }

    public String getHealthCheckId() {
        return this.healthCheckId;
    }

    public List<AwsResourceRecord> getResourceRecords() {
        return this.resourceRecords;
    }

    public static class Builder {
        private String name;
        private String type;
        private String region;
        private Long ttl;
        private String setIdentifier;
        private AwsAliasTarget aliasTarget;
        private Boolean multiValueAnswer;
        private String healthCheckId;
        private List<AwsResourceRecord> resourceRecords;

        public Builder() {
        }

        public Builder(AwsRecordSet awsRecordSet) {
            this.name = awsRecordSet.name;
            this.type = awsRecordSet.type;
            this.region = awsRecordSet.region;
            this.ttl = awsRecordSet.ttl;
            this.setIdentifier = awsRecordSet.setIdentifier;
            this.aliasTarget = awsRecordSet.aliasTarget;
            this.multiValueAnswer = awsRecordSet.multiValueAnswer;
            this.healthCheckId = awsRecordSet.healthCheckId;
            this.resourceRecords = awsRecordSet.resourceRecords;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withType(String type) {
            this.type = type;
            return this;
        }

        public Builder withRegion(String region) {
            this.region = region;
            return this;
        }

        public Builder withTtl(Long ttl) {
            this.ttl = ttl;
            return this;
        }

        public Builder withSetIdentifier(String setIdentifier) {
            this.setIdentifier = setIdentifier;
            return this;
        }

        public Builder withAliasTarget(AwsAliasTarget aliasTarget) {
            this.aliasTarget = aliasTarget;
            return this;
        }

        public Builder withMultiValueAnswer(Boolean multiValueAnswer) {
            this.multiValueAnswer = multiValueAnswer;
            return this;
        }

        public Builder withHealthCheckId(String healthCheckId) {
            this.healthCheckId = healthCheckId;
            return this;
        }

        public Builder withResourceRecords(List<AwsResourceRecord> resourceRecords) {
            this.resourceRecords = resourceRecords;
            return this;
        }

        public AwsRecordSet build() {
            return new AwsRecordSet(this.name, this.type, this.region, this.ttl, this.setIdentifier, this.aliasTarget, this.multiValueAnswer, this.healthCheckId, this.resourceRecords);
        }
    }
}

