/*
 * Decompiled with CFR 0.152.
 */
package pl.codewise.commons.aws.cqrs.model.route53;

import com.google.common.base.Objects;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import pl.codewise.commons.aws.cqrs.model.route53.AwsContactType;

public class AwsContactDetails {
    private final String firstName;
    private final String lastName;
    private final String organizationName;
    private final String phoneNumber;
    private final AwsContactType contactType;
    private final String email;
    private final String countryCode;
    private final String city;
    private final String addressLine1;
    private final String addressLine2;
    private final String zipCode;

    private AwsContactDetails(String firstName, String lastName, String organizationName, String phoneNumber, AwsContactType contactType, String email, String countryCode, String city, String addressLine1, String addressLine2, String zipCode) {
        this.firstName = firstName;
        this.lastName = lastName;
        this.organizationName = organizationName;
        this.phoneNumber = phoneNumber;
        this.contactType = contactType;
        this.email = email;
        this.countryCode = countryCode;
        this.city = city;
        this.addressLine1 = addressLine1;
        this.addressLine2 = addressLine2;
        this.zipCode = zipCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AwsContactDetails that = (AwsContactDetails)o;
        return Objects.equal((Object)this.firstName, (Object)that.firstName) && Objects.equal((Object)this.lastName, (Object)that.lastName) && Objects.equal((Object)this.organizationName, (Object)that.organizationName) && Objects.equal((Object)this.phoneNumber, (Object)that.phoneNumber) && this.contactType == that.contactType && Objects.equal((Object)this.email, (Object)that.email) && Objects.equal((Object)this.countryCode, (Object)that.countryCode) && Objects.equal((Object)this.city, (Object)that.city) && Objects.equal((Object)this.addressLine1, (Object)that.addressLine1) && Objects.equal((Object)this.addressLine2, (Object)that.addressLine2) && Objects.equal((Object)this.zipCode, (Object)that.zipCode);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.firstName, this.lastName, this.organizationName, this.phoneNumber, this.contactType, this.email, this.countryCode, this.city, this.addressLine1, this.addressLine2, this.zipCode});
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this).toString();
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getOrganizationName() {
        return this.organizationName;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public AwsContactType getContactType() {
        return this.contactType;
    }

    public String getEmail() {
        return this.email;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public String getCity() {
        return this.city;
    }

    public String getAddressLine1() {
        return this.addressLine1;
    }

    public String getAddressLine2() {
        return this.addressLine2;
    }

    public String getZipCode() {
        return this.zipCode;
    }

    public static class Builder {
        private String firstName;
        private String lastName;
        private String organizationName;
        private String phoneNumber;
        private AwsContactType contactType;
        private String email;
        private String countryCode;
        private String city;
        private String addressLine1;
        private String addressLine2;
        private String zipCode;

        public Builder withFirstName(String firstName) {
            this.firstName = firstName;
            return this;
        }

        public Builder withLastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        public Builder withOrganizationName(String organizationName) {
            this.organizationName = organizationName;
            return this;
        }

        public Builder withPhoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public Builder withContactType(AwsContactType contactType) {
            this.contactType = contactType;
            return this;
        }

        public Builder withEmail(String email) {
            this.email = email;
            return this;
        }

        public Builder withCountryCode(String countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        public Builder withCity(String city) {
            this.city = city;
            return this;
        }

        public Builder withAddressLine1(String addressLine1) {
            this.addressLine1 = addressLine1;
            return this;
        }

        public Builder withAddressLine2(String addressLine2) {
            this.addressLine2 = addressLine2;
            return this;
        }

        public Builder withZipCode(String zipCode) {
            this.zipCode = zipCode;
            return this;
        }

        public AwsContactDetails build() {
            return new AwsContactDetails(this.firstName, this.lastName, this.organizationName, this.phoneNumber, this.contactType, this.email, this.countryCode, this.city, this.addressLine1, this.addressLine2, this.zipCode);
        }
    }
}

