/*
 * Decompiled with CFR 0.152.
 */
package pl.codewise.commons.aws.cqrs.model.ec2.spot;

import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

public class AwsSpotRequestDetails {
    private final String requestId;
    private final String status;
    private final Date statusUpdateTime;
    private final String productDescription;

    public AwsSpotRequestDetails(String requestId, String status, Date statusUpdateTime, String productDescription) {
        this.requestId = requestId;
        this.status = status;
        this.statusUpdateTime = statusUpdateTime;
        this.productDescription = productDescription;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getStatus() {
        return this.status;
    }

    public Date getStatusUpdateTime() {
        return this.statusUpdateTime;
    }

    public String getProductDescription() {
        return this.productDescription;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AwsSpotRequestDetails that = (AwsSpotRequestDetails)o;
        return Objects.equals(this.requestId, that.requestId);
    }

    public int hashCode() {
        return Objects.hash(this.requestId);
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this).toString();
    }

    public static class Builder {
        private String requestId;
        private String status;
        private Date statusUpdateTime;
        private String productDescription;

        public Builder withRequestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public Builder withStatus(String status) {
            this.status = status;
            return this;
        }

        public Builder withStatusUpdateTime(Date updateTime) {
            this.statusUpdateTime = updateTime;
            return this;
        }

        public Builder withProductDescription(String description) {
            this.productDescription = description;
            return this;
        }

        public AwsSpotRequestDetails build() {
            return new AwsSpotRequestDetails(this.requestId, this.status, this.statusUpdateTime, this.productDescription);
        }
    }
}

