/*
 * Decompiled with CFR 0.152.
 */
package pl.codewise.commons.aws.cqrs.model.ec2.sg;

import java.util.Objects;
import pl.codewise.commons.aws.cqrs.model.ec2.sg.InboundRuleVisitor;

public abstract class InboundRule {
    private final String protocol;
    private final String groupId;
    private final int fromPort;
    private final int toPort;
    private final String source;

    public InboundRule(String protocol, String groupId, int fromPort, int toPort, String source) {
        this.protocol = protocol;
        this.fromPort = fromPort;
        this.groupId = groupId;
        this.toPort = toPort;
        this.source = source;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public int getFromPort() {
        return this.fromPort;
    }

    public int getToPort() {
        return this.toPort;
    }

    public String getSource() {
        return this.source;
    }

    public abstract void accept(InboundRuleVisitor var1);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InboundRule that = (InboundRule)o;
        return this.fromPort == that.fromPort && this.toPort == that.toPort && Objects.equals(this.protocol, that.protocol) && Objects.equals(this.groupId, that.groupId) && Objects.equals(this.source, that.source);
    }

    public int hashCode() {
        return Objects.hash(this.protocol, this.groupId, this.fromPort, this.toPort, this.source);
    }
}

