/*
 * Decompiled with CFR 0.152.
 */
package pl.codewise.commons.aws.cqrs.model.ec2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import pl.codewise.commons.aws.cqrs.model.ec2.AwsLoadBalancerListener;
import pl.codewise.commons.aws.cqrs.model.ec2.AwsResourceTag;

public class LoadBalancerParameters {
    private final String name;
    private final Collection<AwsLoadBalancerListener> listeners;
    private final Collection<String> subnets;
    private final Collection<String> securityGroups;
    private final boolean internal;
    private final Collection<AwsResourceTag> tags;

    private LoadBalancerParameters(String name, Collection<AwsLoadBalancerListener> listeners, Collection<String> subnets, Collection<String> securityGroups, boolean internal, Collection<AwsResourceTag> tags) {
        this.name = name;
        this.listeners = listeners;
        this.subnets = subnets;
        this.securityGroups = securityGroups;
        this.internal = internal;
        this.tags = tags;
    }

    public String getName() {
        return this.name;
    }

    public Collection<AwsLoadBalancerListener> getListeners() {
        return this.listeners;
    }

    public Collection<String> getSubnets() {
        return this.subnets;
    }

    public Collection<String> getSecurityGroups() {
        return this.securityGroups;
    }

    public boolean isInternal() {
        return this.internal;
    }

    public Collection<AwsResourceTag> getTags() {
        return this.tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LoadBalancerParameters that = (LoadBalancerParameters)o;
        return this.internal == that.internal && Objects.equals(this.name, that.name) && Objects.equals(this.listeners, that.listeners) && Objects.equals(this.subnets, that.subnets) && Objects.equals(this.securityGroups, that.securityGroups) && Objects.equals(this.tags, that.tags);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.listeners, this.subnets, this.securityGroups, this.internal, this.tags);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String name;
        private Collection<AwsLoadBalancerListener> listeners = new ArrayList<AwsLoadBalancerListener>();
        private Collection<String> subnets = new ArrayList<String>();
        private Collection<String> securityGroups = new ArrayList<String>();
        private boolean internal;
        private Collection<AwsResourceTag> tags = new ArrayList<AwsResourceTag>();

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withListeners(Collection<AwsLoadBalancerListener> listeners) {
            this.listeners = listeners;
            return this;
        }

        public Builder withSubnets(Collection<String> subnets) {
            this.subnets = subnets;
            return this;
        }

        public Builder withSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = securityGroups;
            return this;
        }

        public Builder withInternal(boolean internal) {
            this.internal = internal;
            return this;
        }

        public Builder withTags(Collection<AwsResourceTag> tags) {
            this.tags = tags;
            return this;
        }

        public LoadBalancerParameters build() {
            return new LoadBalancerParameters(this.name, this.listeners, this.subnets, this.securityGroups, this.internal, this.tags);
        }
    }
}

