/*
 * Decompiled with CFR 0.152.
 */
package pl.codewise.commons.aws.cqrs.model.ec2;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import pl.codewise.commons.aws.cqrs.model.AwsNameBasedResource;
import pl.codewise.commons.aws.cqrs.model.AwsResourceVisitor;
import pl.codewise.commons.aws.cqrs.model.ec2.AwsBlockDeviceMapping;

public class AwsLaunchConfiguration
extends AwsNameBasedResource {
    private final String imageId;
    private final String iamInstanceProfile;
    private final String keyName;
    private final String instanceType;
    private final String spotPrice;
    private final List<String> securityGroupIds;
    private final String userData;
    private final Boolean associatePublicIpAddress;
    private final Boolean instanceMonitoring;
    private final List<AwsBlockDeviceMapping> blockDeviceMappings;
    private final LocalDateTime creationTime;

    private AwsLaunchConfiguration(String name, String imageId, String iamInstanceProfile, String keyName, String instanceType, String spotPrice, List<String> securityGroupIds, String userData, Boolean associatePublicIpAddress, Boolean instanceMonitoring, List<AwsBlockDeviceMapping> blockDeviceMappings, LocalDateTime creationTime) {
        super(name);
        this.imageId = imageId;
        this.iamInstanceProfile = iamInstanceProfile;
        this.keyName = keyName;
        this.instanceType = instanceType;
        this.spotPrice = spotPrice;
        this.securityGroupIds = securityGroupIds;
        this.userData = userData;
        this.associatePublicIpAddress = associatePublicIpAddress;
        this.instanceMonitoring = instanceMonitoring;
        this.blockDeviceMappings = blockDeviceMappings;
        this.creationTime = creationTime;
    }

    public String getImageId() {
        return this.imageId;
    }

    public String getIamInstanceProfile() {
        return this.iamInstanceProfile;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public String getSpotPrice() {
        return this.spotPrice;
    }

    public List<String> getSecurityGroupIds() {
        return this.securityGroupIds;
    }

    public String getUserData() {
        return this.userData;
    }

    public Boolean getAssociatePublicIpAddress() {
        return this.associatePublicIpAddress;
    }

    public Boolean getInstanceMonitoring() {
        return this.instanceMonitoring;
    }

    public List<AwsBlockDeviceMapping> getBlockDeviceMappings() {
        return this.blockDeviceMappings;
    }

    public LocalDateTime getCreationTime() {
        return this.creationTime;
    }

    @Override
    public void accept(AwsResourceVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AwsLaunchConfiguration that = (AwsLaunchConfiguration)o;
        return Objects.equals(this.imageId, that.imageId) && Objects.equals(this.iamInstanceProfile, that.iamInstanceProfile) && Objects.equals(this.keyName, that.keyName) && Objects.equals(this.instanceType, that.instanceType) && Objects.equals(this.spotPrice, that.spotPrice) && Objects.equals(this.securityGroupIds, that.securityGroupIds) && Objects.equals(this.userData, that.userData) && Objects.equals(this.associatePublicIpAddress, that.associatePublicIpAddress) && Objects.equals(this.instanceMonitoring, that.instanceMonitoring) && Objects.equals(this.blockDeviceMappings, that.blockDeviceMappings) && Objects.equals(this.creationTime, that.creationTime);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.imageId, this.iamInstanceProfile, this.keyName, this.instanceType, this.spotPrice, this.securityGroupIds, this.userData, this.associatePublicIpAddress, this.instanceMonitoring, this.blockDeviceMappings, this.creationTime);
    }

    @Override
    public String toString() {
        return new ReflectionToStringBuilder((Object)this).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String name;
        private String imageId;
        private String iamInstanceProfile;
        private String keyName;
        private String instanceType;
        private String spotPrice;
        private List<String> securityGroupIds = new ArrayList<String>();
        private String userData;
        private Boolean associatePublicIpAddress = true;
        private Boolean instanceMonitoring;
        private List<AwsBlockDeviceMapping> blockDeviceMappings = new ArrayList<AwsBlockDeviceMapping>();
        private LocalDateTime creationTime;

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withImageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public Builder withIamInstanceProfile(String iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile;
            return this;
        }

        public Builder withKeyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public Builder withInstanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public Builder withSpotPrice(String spotPrice) {
            this.spotPrice = spotPrice;
            return this;
        }

        public Builder withSecurityGroupIds(List<String> securityGroupIds) {
            this.securityGroupIds = securityGroupIds;
            return this;
        }

        public Builder withUserData(String userData) {
            this.userData = userData;
            return this;
        }

        public Builder withAssociatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress != null ? associatePublicIpAddress : true;
            return this;
        }

        public Builder withInstanceMonitoring(Boolean instanceMonitoring) {
            this.instanceMonitoring = instanceMonitoring;
            return this;
        }

        public Builder withBlockDeviceMappings(List<AwsBlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = blockDeviceMappings;
            return this;
        }

        public Builder withCreationTime(LocalDateTime creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public AwsLaunchConfiguration build() {
            return new AwsLaunchConfiguration(this.name, this.imageId, this.iamInstanceProfile, this.keyName, this.instanceType, this.spotPrice, this.securityGroupIds, this.userData, this.associatePublicIpAddress, this.instanceMonitoring, this.blockDeviceMappings, this.creationTime);
        }
    }
}

