/*
 * Decompiled with CFR 0.152.
 */
package pl.codewise.commons.aws.cqrs.model.ec2;

import com.google.common.base.Objects;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

public class AwsAddress {
    private final String publicIp;
    private final String region;
    private final String instanceId;
    private final String allocationId;
    private final String privateIp;
    private final String associationId;

    public AwsAddress(String publicIp, String region, String instanceId, String allocationId, String privateIp, String associationId) {
        this.publicIp = publicIp;
        this.region = region;
        this.instanceId = instanceId;
        this.allocationId = allocationId;
        this.privateIp = privateIp;
        this.associationId = associationId;
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AwsAddress that = (AwsAddress)o;
        return Objects.equal((Object)this.publicIp, (Object)that.publicIp) && Objects.equal((Object)this.instanceId, (Object)that.instanceId);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.publicIp, this.instanceId});
    }

    public String getPublicIp() {
        return this.publicIp;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getRegion() {
        return this.region;
    }

    public String getAllocationId() {
        return this.allocationId;
    }

    public String getPrivateIp() {
        return this.privateIp;
    }

    public String getAssociationId() {
        return this.associationId;
    }

    public static class Builder {
        private String publicIp;
        private String region;
        private String instanceId;
        private String allocationId;
        private String privateIp;
        private String associationId;

        public Builder withPublicIp(String address) {
            this.publicIp = address;
            return this;
        }

        public Builder withRegion(String region) {
            this.region = region;
            return this;
        }

        public Builder withInstanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public Builder withAllocationId(String allocationId) {
            this.allocationId = allocationId;
            return this;
        }

        public Builder withPrivateIp(String privateIp) {
            this.privateIp = privateIp;
            return this;
        }

        public Builder withAssociationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public AwsAddress build() {
            return new AwsAddress(this.publicIp, this.region, this.instanceId, this.allocationId, this.privateIp, this.associationId);
        }
    }
}

