/*
 * Decompiled with CFR 0.152.
 */
package pl.codewise.commons.aws.cqrs.model;

import com.google.common.base.Objects;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import pl.codewise.commons.aws.cqrs.model.AwsPrivateIpAddressAssociation;

public class AwsPrivateIpAddress {
    private final String privateIpAddress;
    private final AwsPrivateIpAddressAssociation association;

    public AwsPrivateIpAddress(String privateIpAddress, AwsPrivateIpAddressAssociation association) {
        this.privateIpAddress = privateIpAddress;
        this.association = association;
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AwsPrivateIpAddress that = (AwsPrivateIpAddress)o;
        return Objects.equal((Object)this.privateIpAddress, (Object)that.privateIpAddress) && Objects.equal((Object)this.association, (Object)that.association);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.privateIpAddress, this.association});
    }

    public String getPrivateIpAddress() {
        return this.privateIpAddress;
    }

    public AwsPrivateIpAddressAssociation getAssociation() {
        return this.association;
    }

    public static class Builder {
        private String privateIpAddress;
        private AwsPrivateIpAddressAssociation association;

        public Builder withPrivateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        public Builder withAssociation(AwsPrivateIpAddressAssociation association) {
            this.association = association;
            return this;
        }

        public AwsPrivateIpAddress build() {
            return new AwsPrivateIpAddress(this.privateIpAddress, this.association);
        }
    }
}

