/*
 * Decompiled with CFR 0.152.
 */
package pl.codewise.commons.aws.cqrs.model;

import com.google.common.base.Objects;
import java.util.List;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import pl.codewise.commons.aws.cqrs.model.AwsNetworkInterfaceAttachment;
import pl.codewise.commons.aws.cqrs.model.AwsPrivateIpAddress;

public class AwsNetworkInterface {
    private final String networkInterfaceId;
    private final List<AwsPrivateIpAddress> privateIpAddresses;
    private final AwsNetworkInterfaceAttachment attachment;

    public AwsNetworkInterface(String networkInterfaceId, List<AwsPrivateIpAddress> privateIpAddresses, AwsNetworkInterfaceAttachment attachment) {
        this.networkInterfaceId = networkInterfaceId;
        this.privateIpAddresses = privateIpAddresses;
        this.attachment = attachment;
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AwsNetworkInterface that = (AwsNetworkInterface)o;
        return Objects.equal((Object)this.networkInterfaceId, (Object)that.networkInterfaceId) && Objects.equal(this.privateIpAddresses, that.privateIpAddresses);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.networkInterfaceId, this.privateIpAddresses});
    }

    public String getNetworkInterfaceId() {
        return this.networkInterfaceId;
    }

    public List<AwsPrivateIpAddress> getPrivateIpAddresses() {
        return this.privateIpAddresses;
    }

    public AwsNetworkInterfaceAttachment getAttachment() {
        return this.attachment;
    }

    public static class Builder {
        private String networkInterfaceId;
        private List<AwsPrivateIpAddress> privateIpAddresses;
        private AwsNetworkInterfaceAttachment attachment;

        public Builder withNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public Builder withPrivateIpAddresses(List<AwsPrivateIpAddress> privateIpAddresses) {
            this.privateIpAddresses = privateIpAddresses;
            return this;
        }

        public Builder withAttachment(AwsNetworkInterfaceAttachment attachment) {
            this.attachment = attachment;
            return this;
        }

        public AwsNetworkInterface build() {
            return new AwsNetworkInterface(this.networkInterfaceId, this.privateIpAddresses, this.attachment);
        }
    }
}

