/*
 * Decompiled with CFR 0.152.
 */
package pl.codewise.commons.aws.cqrs.model;

import com.amazonaws.services.ec2.model.InstanceStateName;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import pl.codewise.commons.aws.cqrs.model.AwsNetworkInterface;
import pl.codewise.commons.aws.cqrs.model.AwsResource;
import pl.codewise.commons.aws.cqrs.model.AwsResourceVisitor;
import pl.codewise.commons.aws.cqrs.model.ec2.AwsInstanceBlockDeviceMapping;
import pl.codewise.commons.aws.cqrs.model.ec2.AwsResourceTag;
import pl.codewise.commons.aws.cqrs.model.ec2.autoscaling.AwsAutoScalingDetails;
import pl.codewise.commons.aws.cqrs.model.ec2.sg.AwsSecurityGroup;
import pl.codewise.commons.aws.cqrs.model.ec2.spot.AwsSpotRequestDetails;

public class AwsInstance
implements AwsResource {
    private final String instanceId;
    private final String publicDnsName;
    private final String privateIpAddress;
    private final String publicIpAddress;
    private final String iamInstanceProfileArn;
    private final String imageId;
    private final String region;
    private final String state;
    private final String instanceType;
    private final String keyName;
    private final List<AwsNetworkInterface> networkInterfaces;
    private final String subnetId;
    private final String lifecycle;
    private final Date launchTime;
    private final AwsAutoScalingDetails autoScalingDetails;
    private final AwsSpotRequestDetails spotRequestDetails;
    private final List<AwsResourceTag> tags;
    private final List<AwsInstanceBlockDeviceMapping> blockDeviceMappings;
    private final List<AwsSecurityGroup> securityGroups;

    private AwsInstance(String instanceId, String publicDnsName, String privateIpAddress, String publicIpAddress, String iamInstanceProfileArn, String imageId, String region, String state, String instanceType, String keyName, List<AwsNetworkInterface> networkInterfaces, String subnetId, String lifecycle, Date launchTime, AwsAutoScalingDetails autoScalingDetails, AwsSpotRequestDetails spotRequestDetails, List<AwsResourceTag> tags, List<AwsInstanceBlockDeviceMapping> blockDeviceMappings, List<AwsSecurityGroup> securityGroups) {
        this.instanceId = instanceId;
        this.publicDnsName = publicDnsName;
        this.privateIpAddress = privateIpAddress;
        this.publicIpAddress = publicIpAddress;
        this.iamInstanceProfileArn = iamInstanceProfileArn;
        this.imageId = imageId;
        this.region = region;
        this.state = state;
        this.instanceType = instanceType;
        this.keyName = keyName;
        this.networkInterfaces = networkInterfaces;
        this.subnetId = subnetId;
        this.lifecycle = lifecycle;
        this.launchTime = launchTime;
        this.autoScalingDetails = autoScalingDetails;
        this.spotRequestDetails = spotRequestDetails;
        this.tags = tags;
        this.blockDeviceMappings = blockDeviceMappings;
        this.securityGroups = securityGroups;
    }

    @Override
    public String getId() {
        return this.getInstanceId();
    }

    @Override
    public void accept(AwsResourceVisitor visitor) {
        visitor.visit(this);
    }

    public String getHost() {
        if (StringUtils.isNotBlank((CharSequence)this.publicDnsName)) {
            return this.publicDnsName;
        }
        return this.privateIpAddress;
    }

    public boolean isRunning() {
        return InstanceStateName.Running.toString().equals(this.state);
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getPublicDnsName() {
        return this.publicDnsName;
    }

    public String getPrivateIpAddress() {
        return this.privateIpAddress;
    }

    public String getPublicIpAddress() {
        return this.publicIpAddress;
    }

    public String getIamInstanceProfileArn() {
        return this.iamInstanceProfileArn;
    }

    public String getImageId() {
        return this.imageId;
    }

    public String getRegion() {
        return this.region;
    }

    public String getState() {
        return this.state;
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public List<AwsNetworkInterface> getNetworkInterfaces() {
        return this.networkInterfaces;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public boolean isSpotInstance() {
        return Objects.equals(this.lifecycle, "spot");
    }

    public String getLifecycle() {
        return this.lifecycle;
    }

    public Date getLaunchTime() {
        return this.launchTime;
    }

    public AwsAutoScalingDetails getAutoScalingDetails() {
        return this.autoScalingDetails;
    }

    public AwsSpotRequestDetails getSpotRequestDetails() {
        return this.spotRequestDetails;
    }

    public List<AwsResourceTag> getTags() {
        return this.tags;
    }

    public List<AwsInstanceBlockDeviceMapping> getBlockDeviceMappings() {
        return this.blockDeviceMappings;
    }

    public List<AwsSecurityGroup> getSecurityGroups() {
        return this.securityGroups;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AwsInstance that = (AwsInstance)o;
        return Objects.equals(this.instanceId, that.instanceId);
    }

    public int hashCode() {
        return Objects.hash(this.instanceId);
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this).toString();
    }

    public Builder toBuilder() {
        return new Builder().withInstanceId(this.instanceId).withPublicDnsName(this.publicDnsName).withPublicIpAddress(this.publicIpAddress).withPrivateIpAddress(this.privateIpAddress).withIamInstanceProfileArn(this.iamInstanceProfileArn).withImageId(this.imageId).withRegion(this.region).withState(this.state).withInstanceType(this.instanceType).withKeyName(this.keyName).withNetworkInterfaces(this.networkInterfaces).withSubnetId(this.subnetId).withAutoScalingDetails(this.autoScalingDetails).withLifecycle(this.lifecycle).withLaunchTime(this.launchTime).withSpotRequestDetails(this.spotRequestDetails).withTags(this.tags).withBlockDeviceMapping(this.blockDeviceMappings).withSecurityGroups(this.securityGroups);
    }

    public static class Builder {
        private String instanceId;
        private String publicDnsName;
        private String privateIpAddress;
        private String publicIpAddress;
        private String iamInstanceProfileArn;
        private String imageId;
        private String region;
        private String state;
        private String instanceType;
        private String keyName;
        private List<AwsNetworkInterface> networkInterfaces;
        private String subnetId;
        private String lifecycle;
        private Date launchTime;
        private AwsAutoScalingDetails autoScalingDetails;
        private AwsSpotRequestDetails spotRequestDetails;
        private List<AwsResourceTag> tags;
        private List<AwsInstanceBlockDeviceMapping> blockDeviceMappings;
        private List<AwsSecurityGroup> securityGroups;

        public Builder withInstanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public Builder withPublicDnsName(String publicDnsName) {
            this.publicDnsName = publicDnsName;
            return this;
        }

        public Builder withPublicIpAddress(String publicIpAddress) {
            this.publicIpAddress = publicIpAddress;
            return this;
        }

        public Builder withPrivateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        public Builder withIamInstanceProfileArn(String iamInstanceProfileArn) {
            this.iamInstanceProfileArn = iamInstanceProfileArn;
            return this;
        }

        public Builder withImageId(String amiId) {
            this.imageId = amiId;
            return this;
        }

        public Builder withRegion(String region) {
            this.region = region;
            return this;
        }

        public Builder withState(String state) {
            this.state = state;
            return this;
        }

        public Builder withInstanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public Builder withKeyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public Builder withNetworkInterfaces(List<AwsNetworkInterface> networkInterfaces) {
            this.networkInterfaces = networkInterfaces;
            return this;
        }

        public Builder withSubnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public Builder withAutoScalingDetails(AwsAutoScalingDetails autoScalingDetails) {
            this.autoScalingDetails = autoScalingDetails;
            return this;
        }

        public Builder withLifecycle(String lifecycle) {
            this.lifecycle = lifecycle == null ? "normal" : lifecycle;
            return this;
        }

        public Builder withLaunchTime(Date launchTime) {
            this.launchTime = launchTime;
            return this;
        }

        public Builder withSpotRequestDetails(AwsSpotRequestDetails spotRequestDetails) {
            this.spotRequestDetails = spotRequestDetails;
            return this;
        }

        public Builder withTags(List<AwsResourceTag> tags) {
            this.tags = tags;
            return this;
        }

        public Builder withBlockDeviceMapping(List<AwsInstanceBlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = blockDeviceMappings;
            return this;
        }

        public Builder withSecurityGroups(List<AwsSecurityGroup> securityGroups) {
            this.securityGroups = securityGroups;
            return this;
        }

        public AwsInstance build() {
            return new AwsInstance(this.instanceId, this.publicDnsName, this.privateIpAddress, this.publicIpAddress, this.iamInstanceProfileArn, this.imageId, this.region, this.state, this.instanceType, this.keyName, this.networkInterfaces, this.subnetId, this.lifecycle, this.launchTime, this.autoScalingDetails, this.spotRequestDetails, this.tags, this.blockDeviceMappings, this.securityGroups);
        }
    }
}

