/*
 * Decompiled with CFR 0.152.
 */
package pl.codewise.commons.aws.cqrs.model;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import pl.codewise.commons.aws.cqrs.model.AwsInstance;
import pl.codewise.commons.aws.cqrs.model.AwsResource;
import pl.codewise.commons.aws.cqrs.model.AwsResourceVisitor;
import pl.codewise.commons.aws.cqrs.model.ec2.AwsAutoScalingTag;

public class AwsAutoScalingGroup
implements AwsResource {
    private final String autoScalingGroupName;
    private final List<AwsInstance> awsInstances;
    private final List<String> loadBalancerNames;
    private final List<String> targetGroupArns;
    private final Integer desiredCapacity;
    private final Integer minSize;
    private final Integer maxSize;
    private final Date created;
    private final String launchConfigurationName;
    private final Integer defaultCooldown;
    private final List<String> availabilityZones;
    private final String healthCheckType;
    private final Integer healthCheckGracePeriod;
    private final String placementGroup;
    private final String VPCZoneIdentifier;
    private final Boolean newInstancesProtectedFromScaleIn;
    private final List<AwsAutoScalingTag> tags;
    private final List<String> terminationPolicies;
    private final List<String> suspendedProcesses;

    private AwsAutoScalingGroup(String autoScalingGroupName, List<AwsInstance> awsInstances, List<String> loadBalancerNames, List<String> targetGroupArns, Integer desiredCapacity, Integer minSize, Integer maxSize, Date created, String launchConfigurationName, Integer defaultCooldown, List<String> availabilityZones, String healthCheckType, Integer healthCheckGracePeriod, String placementGroup, String vpcZoneIdentifier, Boolean newInstancesProtectedFromScaleIn, List<AwsAutoScalingTag> tags, List<String> terminationPolicies, List<String> suspendedProcesses) {
        this.autoScalingGroupName = autoScalingGroupName;
        this.awsInstances = awsInstances;
        this.loadBalancerNames = loadBalancerNames;
        this.targetGroupArns = targetGroupArns;
        this.desiredCapacity = desiredCapacity;
        this.minSize = minSize;
        this.maxSize = maxSize;
        this.created = created;
        this.launchConfigurationName = launchConfigurationName;
        this.defaultCooldown = defaultCooldown;
        this.availabilityZones = availabilityZones;
        this.healthCheckType = healthCheckType;
        this.healthCheckGracePeriod = healthCheckGracePeriod;
        this.placementGroup = placementGroup;
        this.VPCZoneIdentifier = vpcZoneIdentifier;
        this.newInstancesProtectedFromScaleIn = newInstancesProtectedFromScaleIn;
        this.tags = tags;
        this.terminationPolicies = terminationPolicies;
        this.suspendedProcesses = suspendedProcesses;
    }

    public String getAutoScalingGroupName() {
        return this.autoScalingGroupName;
    }

    public List<AwsInstance> getAwsInstances() {
        return this.awsInstances;
    }

    public List<String> getLoadBalancerNames() {
        return this.loadBalancerNames;
    }

    public List<String> getTargetGroupArns() {
        return this.targetGroupArns;
    }

    public Integer getDesiredCapacity() {
        return this.desiredCapacity;
    }

    public Integer getMinSize() {
        return this.minSize;
    }

    public Integer getMaxSize() {
        return this.maxSize;
    }

    public Date getCreated() {
        return this.created;
    }

    public String getLaunchConfigurationName() {
        return this.launchConfigurationName;
    }

    public Integer getDefaultCooldown() {
        return this.defaultCooldown;
    }

    public List<String> getAvailabilityZones() {
        return this.availabilityZones;
    }

    public String getHealthCheckType() {
        return this.healthCheckType;
    }

    public Integer getHealthCheckGracePeriod() {
        return this.healthCheckGracePeriod;
    }

    public String getPlacementGroup() {
        return this.placementGroup;
    }

    public String getVPCZoneIdentifier() {
        return this.VPCZoneIdentifier;
    }

    public Boolean isNewInstancesProtectedFromScaleIn() {
        return this.newInstancesProtectedFromScaleIn;
    }

    public List<AwsAutoScalingTag> getTags() {
        return this.tags;
    }

    public List<String> getTerminationPolicies() {
        return this.terminationPolicies;
    }

    public List<String> getSuspendedProcesses() {
        return this.suspendedProcesses;
    }

    @Override
    public String getId() {
        return this.autoScalingGroupName;
    }

    @Override
    public void accept(AwsResourceVisitor visitor) {
        visitor.visit(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AwsAutoScalingGroup that = (AwsAutoScalingGroup)o;
        return Objects.equals(this.autoScalingGroupName, that.autoScalingGroupName) && Objects.equals(this.awsInstances, that.awsInstances) && Objects.equals(this.loadBalancerNames, that.loadBalancerNames) && Objects.equals(this.desiredCapacity, that.desiredCapacity) && Objects.equals(this.minSize, that.minSize) && Objects.equals(this.maxSize, that.maxSize) && Objects.equals(this.created, that.created) && Objects.equals(this.launchConfigurationName, that.launchConfigurationName) && Objects.equals(this.defaultCooldown, that.defaultCooldown) && Objects.equals(this.availabilityZones, that.availabilityZones) && Objects.equals(this.healthCheckType, that.healthCheckType) && Objects.equals(this.healthCheckGracePeriod, that.healthCheckGracePeriod) && Objects.equals(this.placementGroup, that.placementGroup) && Objects.equals(this.VPCZoneIdentifier, that.VPCZoneIdentifier) && Objects.equals(this.newInstancesProtectedFromScaleIn, that.newInstancesProtectedFromScaleIn) && Objects.equals(this.tags, that.tags) && Objects.equals(this.terminationPolicies, that.terminationPolicies);
    }

    public int hashCode() {
        return Objects.hash(this.autoScalingGroupName, this.awsInstances, this.loadBalancerNames, this.desiredCapacity, this.minSize, this.maxSize, this.created, this.launchConfigurationName, this.defaultCooldown, this.availabilityZones, this.healthCheckType, this.healthCheckGracePeriod, this.placementGroup, this.VPCZoneIdentifier, this.newInstancesProtectedFromScaleIn, this.tags, this.terminationPolicies);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("autoScalingGroupName", (Object)this.autoScalingGroupName).add("awsInstances", this.awsInstances).add("loadBalancerNames", this.loadBalancerNames).add("desiredCapacity", (Object)this.desiredCapacity).add("minSize", (Object)this.minSize).add("maxSize", (Object)this.maxSize).add("created", (Object)this.created).add("launchConfigurationName", (Object)this.launchConfigurationName).add("defaultCooldown", (Object)this.defaultCooldown).add("availabilityZones", this.availabilityZones).add("healthCheckType", (Object)this.healthCheckType).add("healthCheckGracePeriod", (Object)this.healthCheckGracePeriod).add("placementGroup", (Object)this.placementGroup).add("VPCZoneIdentifier", (Object)this.VPCZoneIdentifier).add("newInstancesProtectedFromScaleIn", (Object)this.newInstancesProtectedFromScaleIn).add("tags", this.tags).add("terminationPolicies", this.terminationPolicies).toString();
    }

    public Builder toBuilder() {
        return new Builder().withAutoScalingGroupName(this.autoScalingGroupName).withAwsInstances(this.awsInstances).withLoadBalancerNames(this.loadBalancerNames).withDesiredCapacity(this.desiredCapacity).withMinSize(this.minSize).withMaxSize(this.maxSize).withCreated(this.created).withLaunchConfigurationName(this.launchConfigurationName).withDefaultCooldown(this.defaultCooldown).withAvailabilityZones(this.availabilityZones).withHealthCheckType(this.healthCheckType).withHealthCheckGracePeriod(this.healthCheckGracePeriod).withPlacementGroup(this.placementGroup).withVpcZoneIdentifier(this.VPCZoneIdentifier).withNewInstancesProtectedFromScaleIn(this.newInstancesProtectedFromScaleIn).withTags(this.tags).withTerminationPolicies(this.terminationPolicies);
    }

    public static class Builder {
        private String autoScalingGroupName;
        private List<AwsInstance> awsInstances = Collections.emptyList();
        private List<String> loadBalancerNames = Collections.emptyList();
        private List<String> targetGroupArns = Collections.emptyList();
        private Integer desiredCapacity;
        private Integer minSize;
        private Integer maxSize;
        private Date created;
        private String launchConfigurationName;
        private Integer defaultCooldown;
        private List<String> availabilityZones = Collections.emptyList();
        private String healthCheckType;
        private Integer healthCheckGracePeriod;
        private String placementGroup;
        private String vpcZoneIdentifier;
        private Boolean newInstancesProtectedFromScaleIn;
        private List<AwsAutoScalingTag> tags = Collections.emptyList();
        private List<String> terminationPolicies = Collections.emptyList();
        private List<String> suspendedProcesses = Collections.emptyList();

        public Builder withAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public Builder withAwsInstances(List<AwsInstance> awsInstances) {
            this.awsInstances = awsInstances != null ? awsInstances : Collections.emptyList();
            return this;
        }

        public Builder withLoadBalancerNames(List<String> loadBalancerNames) {
            this.loadBalancerNames = loadBalancerNames;
            return this;
        }

        public Builder withTargetGroupArns(List<String> targetGroupArns) {
            this.targetGroupArns = targetGroupArns;
            return this;
        }

        public Builder withDesiredCapacity(Integer desiredCapacity) {
            this.desiredCapacity = desiredCapacity;
            return this;
        }

        public Builder withMinSize(Integer minSize) {
            this.minSize = minSize;
            return this;
        }

        public Builder withMaxSize(Integer maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public Builder withCreated(Date created) {
            this.created = created;
            return this;
        }

        public Builder withLaunchConfigurationName(String launchConfigurationName) {
            this.launchConfigurationName = launchConfigurationName;
            return this;
        }

        public Builder withDefaultCooldown(Integer defaultCooldown) {
            this.defaultCooldown = defaultCooldown;
            return this;
        }

        public Builder withAvailabilityZones(List<String> availabilityZones) {
            this.availabilityZones = availabilityZones;
            return this;
        }

        public Builder withHealthCheckType(String healthCheckType) {
            this.healthCheckType = healthCheckType;
            return this;
        }

        public Builder withHealthCheckGracePeriod(Integer healthCheckGracePeriod) {
            this.healthCheckGracePeriod = healthCheckGracePeriod;
            return this;
        }

        public Builder withPlacementGroup(String placementGroup) {
            this.placementGroup = placementGroup;
            return this;
        }

        public Builder withVpcZoneIdentifier(String vpcZoneIdentifier) {
            this.vpcZoneIdentifier = vpcZoneIdentifier;
            return this;
        }

        public Builder withNewInstancesProtectedFromScaleIn(Boolean newInstancesProtectedFromScaleIn) {
            this.newInstancesProtectedFromScaleIn = newInstancesProtectedFromScaleIn;
            return this;
        }

        public Builder withTags(List<AwsAutoScalingTag> tags) {
            this.tags = tags;
            return this;
        }

        public Builder withTerminationPolicies(List<String> terminationPolicies) {
            this.terminationPolicies = terminationPolicies;
            return this;
        }

        public Builder withSuspendedProcesses(List<String> processes) {
            this.suspendedProcesses = processes;
            return this;
        }

        public AwsAutoScalingGroup build() {
            return new AwsAutoScalingGroup(this.autoScalingGroupName, this.awsInstances, this.loadBalancerNames, this.targetGroupArns, this.desiredCapacity, this.minSize, this.maxSize, this.created, this.launchConfigurationName, this.defaultCooldown, this.availabilityZones, this.healthCheckType, this.healthCheckGracePeriod, this.placementGroup, this.vpcZoneIdentifier, this.newInstancesProtectedFromScaleIn, this.tags, this.terminationPolicies, this.suspendedProcesses);
        }
    }
}

