/*
 * Decompiled with CFR 0.152.
 */
package pl.codewise.commons.aws.cqrs.factories.internal;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.auth.STSAssumeRoleSessionCredentialsProvider;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import java.util.function.Function;
import pl.codewise.commons.aws.cqrs.factories.AssumeRoleParameters;

public class Builder<T> {
    private final Function<AWSCredentialsProvider, T> function;
    private AWSCredentialsProvider credentialsProvider = new DefaultAWSCredentialsProviderChain();
    protected Region region;

    public Builder(Function<AWSCredentialsProvider, T> function) {
        this.function = function;
    }

    public Builder<T> withRegion(String region) {
        this.region = Region.getRegion((Regions)Regions.fromName((String)region));
        return this;
    }

    public Builder<T> withAssumeRoleParameters(AssumeRoleParameters parameters) {
        this.credentialsProvider = new STSAssumeRoleSessionCredentialsProvider.Builder(parameters.getRoleArn(), parameters.getRoleSessionName()).build();
        return this;
    }

    public T get() {
        T client = this.function.apply(this.credentialsProvider);
        this.configure(client);
        return client;
    }

    protected void configure(T client) {
    }
}

