/*
 * Decompiled with CFR 0.152.
 */
package pl.codewise.commons.aws.cqrs.factories.constructors;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.autoscaling.AmazonAutoScaling;
import com.amazonaws.services.autoscaling.AmazonAutoScalingClient;
import com.amazonaws.services.cloudwatch.AmazonCloudWatch;
import com.amazonaws.services.cloudwatch.AmazonCloudWatchClient;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.AmazonEC2Client;
import com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancing;
import com.amazonaws.services.elasticloadbalancingv2.AmazonElasticLoadBalancingClient;
import com.amazonaws.services.identitymanagement.AmazonIdentityManagement;
import com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient;
import com.amazonaws.services.lambda.AWSLambda;
import com.amazonaws.services.lambda.AWSLambdaClient;
import com.amazonaws.services.route53.AmazonRoute53;
import com.amazonaws.services.route53.AmazonRoute53Client;
import com.amazonaws.services.route53domains.AmazonRoute53Domains;
import com.amazonaws.services.route53domains.AmazonRoute53DomainsClient;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import java.util.function.Function;
import pl.codewise.commons.aws.cqrs.factories.ClientConstructors;
import pl.codewise.commons.aws.cqrs.factories.constructors.AmazonClientConfigurationProvider;

public class AmazonClientConstructors
implements ClientConstructors {
    private final AmazonClientConfigurationProvider configurationProvider;

    public AmazonClientConstructors(AmazonClientConfigurationProvider configurationProvider) {
        this.configurationProvider = configurationProvider;
    }

    @Override
    public Function<AWSCredentialsProvider, AmazonS3> s3() {
        return awsCredentialsProvider -> new AmazonS3Client(awsCredentialsProvider, this.configurationProvider.getS3Configuration());
    }

    @Override
    public Function<AWSCredentialsProvider, AmazonIdentityManagement> iam() {
        return awsCredentialsProvider -> new AmazonIdentityManagementClient(awsCredentialsProvider, this.configurationProvider.getIamConfiguration());
    }

    @Override
    public Function<AWSCredentialsProvider, AmazonEC2> ec2() {
        return awsCredentialsProvider -> new AmazonEC2Client(awsCredentialsProvider, this.configurationProvider.getEc2Configuration());
    }

    @Override
    public Function<AWSCredentialsProvider, AmazonAutoScaling> autoScaling() {
        return awsCredentialsProvider -> new AmazonAutoScalingClient(awsCredentialsProvider, this.configurationProvider.getAutoScalingConfiguration());
    }

    @Override
    public Function<AWSCredentialsProvider, AWSLambda> awsLambda() {
        return awsCredentialsProvider -> new AWSLambdaClient(awsCredentialsProvider, this.configurationProvider.getLambdaConfiguration());
    }

    @Override
    public Function<AWSCredentialsProvider, AmazonElasticLoadBalancing> amazonElasticLoadBalancing() {
        return awsCredentialsProvider -> new com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient(awsCredentialsProvider, this.configurationProvider.getElasticLoadBalancingConfiguration());
    }

    @Override
    public Function<AWSCredentialsProvider, com.amazonaws.services.elasticloadbalancingv2.AmazonElasticLoadBalancing> applicationLoadBalancing() {
        return awsCredentialsProvider -> new AmazonElasticLoadBalancingClient(awsCredentialsProvider, this.configurationProvider.getElasticLoadBalancingConfiguration());
    }

    @Override
    public Function<AWSCredentialsProvider, AmazonCloudWatch> amazonCloudWatch() {
        return awsCredentialsProvider -> new AmazonCloudWatchClient(awsCredentialsProvider, this.configurationProvider.getCloudWatchConfiguration());
    }

    @Override
    public Function<AWSCredentialsProvider, AmazonRoute53> amazonRoute53() {
        return awsCredentialsProvider -> new AmazonRoute53Client(awsCredentialsProvider, this.configurationProvider.getRoute53Configuration());
    }

    @Override
    public Function<AWSCredentialsProvider, AmazonRoute53Domains> amazonRoute53Domains() {
        return awsCredentialsProvider -> new AmazonRoute53DomainsClient(awsCredentialsProvider, this.configurationProvider.getRoute53DomainsConfiguration());
    }
}

