/*
 * Decompiled with CFR 0.152.
 */
package pl.codewise.commons.aws.cqrs.factories;

import com.amazonaws.services.autoscaling.AmazonAutoScaling;
import com.amazonaws.services.cloudwatch.AmazonCloudWatch;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancing;
import com.amazonaws.services.identitymanagement.AmazonIdentityManagement;
import com.amazonaws.services.lambda.AWSLambda;
import com.amazonaws.services.route53.AmazonRoute53;
import com.amazonaws.services.route53domains.AmazonRoute53Domains;
import com.amazonaws.services.s3.AmazonS3;
import pl.codewise.commons.aws.cqrs.factories.ClientConstructors;
import pl.codewise.commons.aws.cqrs.factories.internal.AmazonAutoScalingBuilder;
import pl.codewise.commons.aws.cqrs.factories.internal.AmazonCloudWatchBuilder;
import pl.codewise.commons.aws.cqrs.factories.internal.AmazonEC2Builder;
import pl.codewise.commons.aws.cqrs.factories.internal.ApplicationLoadBalancingBuilder;
import pl.codewise.commons.aws.cqrs.factories.internal.AwsLambdaBuilder;
import pl.codewise.commons.aws.cqrs.factories.internal.Builder;
import pl.codewise.commons.aws.cqrs.factories.internal.ClassicLoadBalancingBuilder;

public class AmazonClientBuilders {
    private final ClientConstructors clientConstructors;

    public AmazonClientBuilders(ClientConstructors clientConstructors) {
        this.clientConstructors = clientConstructors;
    }

    public Builder<AmazonS3> s3() {
        return new Builder<AmazonS3>(this.clientConstructors.s3());
    }

    public Builder<AmazonIdentityManagement> iam() {
        return new Builder<AmazonIdentityManagement>(this.clientConstructors.iam());
    }

    public Builder<AmazonEC2> ec2() {
        return new AmazonEC2Builder(this.clientConstructors.ec2());
    }

    public Builder<AmazonAutoScaling> autoScaling() {
        return new AmazonAutoScalingBuilder(this.clientConstructors.autoScaling());
    }

    public Builder<AWSLambda> awsLambda() {
        return new AwsLambdaBuilder(this.clientConstructors.awsLambda());
    }

    public Builder<AmazonElasticLoadBalancing> amazonElasticLoadBalancing() {
        return new ClassicLoadBalancingBuilder(this.clientConstructors.amazonElasticLoadBalancing());
    }

    public Builder<com.amazonaws.services.elasticloadbalancingv2.AmazonElasticLoadBalancing> applicationLoadBalancing() {
        return new ApplicationLoadBalancingBuilder(this.clientConstructors.applicationLoadBalancing());
    }

    public Builder<AmazonCloudWatch> amazonCloudWatch() {
        return new AmazonCloudWatchBuilder(this.clientConstructors.amazonCloudWatch());
    }

    public Builder<AmazonRoute53> route53() {
        return new Builder<AmazonRoute53>(this.clientConstructors.amazonRoute53());
    }

    public Builder<AmazonRoute53Domains> route53Domains() {
        return new Builder<AmazonRoute53Domains>(this.clientConstructors.amazonRoute53Domains());
    }
}

