/*
 * Decompiled with CFR 0.152.
 */
package pl.codewise.commons.aws.cqrs.discovery.ec2;

import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.Address;
import com.amazonaws.services.ec2.model.DescribeAddressesRequest;
import com.amazonaws.services.ec2.model.DescribeAddressesResult;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import pl.codewise.commons.aws.cqrs.model.ec2.AwsAddress;

public class AddressDiscovery {
    private final String region;
    private final AmazonEC2 amazonEC2;

    public AddressDiscovery(String region, AmazonEC2 amazonEC2) {
        this.region = region;
        this.amazonEC2 = amazonEC2;
    }

    @Nullable
    public AwsAddress getAddressByPublicIp(String publicIp) {
        DescribeAddressesRequest request = new DescribeAddressesRequest().withPublicIps(new String[]{publicIp});
        DescribeAddressesResult result = this.amazonEC2.describeAddresses(request);
        return result.getAddresses().stream().map(this::toAwsAddress).findFirst().orElse(null);
    }

    public List<AwsAddress> getAllAddresses() {
        return this.addressStream().map(this::toAwsAddress).collect(Collectors.toList());
    }

    private AwsAddress toAwsAddress(Address address) {
        return new AwsAddress.Builder().withPublicIp(address.getPublicIp()).withRegion(this.region).withInstanceId(address.getInstanceId()).withAllocationId(address.getAllocationId()).withPrivateIp(address.getPrivateIpAddress()).withAssociationId(address.getAssociationId()).build();
    }

    private Stream<Address> addressStream() {
        DescribeAddressesRequest describeAddressesRequest = new DescribeAddressesRequest();
        DescribeAddressesResult result = this.amazonEC2.describeAddresses(describeAddressesRequest);
        return result.getAddresses().stream();
    }
}

