/*
 * Decompiled with CFR 0.152.
 */
package pl.codewise.commons.aws.cqrs.discovery;

import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.AmazonEC2Exception;
import com.amazonaws.services.ec2.model.DescribeSecurityGroupsRequest;

public class SecurityGroupDiscovery {
    private final AmazonEC2 amazonEC2;

    public SecurityGroupDiscovery(AmazonEC2 amazonEC2) {
        this.amazonEC2 = amazonEC2;
    }

    public boolean hasSecurityGroupInVpc(String groupName, String vpcId) {
        try {
            DescribeSecurityGroupsRequest request = new DescribeSecurityGroupsRequest().withGroupNames(new String[]{groupName});
            return this.amazonEC2.describeSecurityGroups(request).getSecurityGroups().stream().anyMatch(securityGroup -> vpcId.equals(securityGroup.getVpcId()));
        }
        catch (AmazonEC2Exception e) {
            return false;
        }
    }
}

