/*
 * Decompiled with CFR 0.152.
 */
package pl.codewise.commons.aws.cqrs.discovery;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.stream.Collectors;

public class S3Discovery {
    private final AmazonS3 amazonS3;

    public S3Discovery(AmazonS3 amazonS3) {
        this.amazonS3 = amazonS3;
    }

    public boolean hasBucketNamed(String bucketName) {
        Preconditions.checkNotNull((Object)bucketName);
        return this.amazonS3.listBuckets().stream().anyMatch(bucket -> bucketName.equals(bucket.getName()));
    }

    public boolean exists(String bucketName, String key) {
        try {
            this.amazonS3.getObjectMetadata(bucketName, key);
        }
        catch (AmazonS3Exception e) {
            if (e.getStatusCode() == 404) {
                return false;
            }
            throw e;
        }
        return true;
    }

    public List<String> listObjects(String bucket, String prefix) {
        ObjectListing objectListing = this.amazonS3.listObjects(bucket, prefix);
        return objectListing.getObjectSummaries().stream().map(S3ObjectSummary::getKey).collect(Collectors.toList());
    }
}

