/*
 * Decompiled with CFR 0.152.
 */
package pl.codewise.commons.aws.cqrs.discovery;

import com.amazonaws.services.route53domains.AmazonRoute53Domains;
import com.amazonaws.services.route53domains.model.CheckDomainAvailabilityRequest;
import com.amazonaws.services.route53domains.model.DomainAvailability;
import com.amazonaws.services.route53domains.model.DomainSummary;
import com.amazonaws.services.route53domains.model.GetOperationDetailRequest;
import com.amazonaws.services.route53domains.model.GetOperationDetailResult;
import com.amazonaws.services.route53domains.model.ListDomainsRequest;
import com.amazonaws.services.route53domains.model.ListDomainsResult;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.RateLimiter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsEqual;
import org.hamcrest.core.IsNot;
import pl.codewise.commons.aws.cqrs.discovery.route53.domains.Route53DomainsSettings;
import pl.codewise.commons.aws.cqrs.model.route53.AwsBasicDomain;
import pl.codewise.commons.aws.cqrs.model.route53.AwsDomainRegistrationStatus;
import pl.codewise.commons.aws.cqrs.utils.Awaitilities;

public class Route53DomainsDiscovery {
    private static final int LIST_DOMAINS_RESULT_MAX_ITEMS = 100;
    private static final String DEFAULT_EXCEPTION_MESSAGE = "Unable to check domain availability";
    private static final String AVAILABILITY_STATUS_AVAILABLE = DomainAvailability.AVAILABLE.toString();
    @VisibleForTesting
    static final String AVAILABILITY_STATUS_PENDING = "PENDING";
    private final int timeoutMillis;
    private final int pollIntervalMillis;
    private final RateLimiter rateLimiter;
    private final AmazonRoute53Domains amazonRoute53Domains;
    private final Awaitilities awaitilities;

    public Route53DomainsDiscovery(AmazonRoute53Domains amazonRoute53Domains, Route53DomainsSettings route53DomainsSettings, Awaitilities awaitilities) {
        this.amazonRoute53Domains = amazonRoute53Domains;
        this.awaitilities = awaitilities;
        this.pollIntervalMillis = route53DomainsSettings.getPollIntervalMillis();
        this.timeoutMillis = route53DomainsSettings.getTimeoutMillis();
        this.rateLimiter = route53DomainsSettings.getRateLimiter();
    }

    public boolean isDomainAvailableForRegistration(String domainName) {
        String domainAvailabilityStatus = this.awaitilities.awaitForValueOrReturnLastValue(this.timeoutMillis, this.pollIntervalMillis, () -> this.checkDomainAvailability(domainName), Matchers.both((Matcher)IsNot.not((Matcher)Matchers.isEmptyOrNullString())).and(IsNot.not((Matcher)IsEqual.equalTo((Object)AVAILABILITY_STATUS_PENDING))), DEFAULT_EXCEPTION_MESSAGE);
        return AVAILABILITY_STATUS_AVAILABLE.equals(domainAvailabilityStatus);
    }

    public AwsDomainRegistrationStatus getDomainRegistrationStatus(String operationId) {
        GetOperationDetailRequest request = new GetOperationDetailRequest().withOperationId(operationId);
        GetOperationDetailResult operationDetail = this.amazonRoute53Domains.getOperationDetail(request);
        return this.toAwsDomainRegistrationStatus(operationDetail);
    }

    public List<AwsBasicDomain> getAllDomains(Predicate<AwsBasicDomain> filter) {
        ListDomainsRequest listDomainsRequest = new ListDomainsRequest().withMaxItems(Integer.valueOf(100));
        ListDomainsResult listDomainsResult = this.amazonRoute53Domains.listDomains(listDomainsRequest);
        ArrayList<AwsBasicDomain> filteredDomains = new ArrayList<AwsBasicDomain>();
        this.addDomainsMatching(listDomainsResult, filteredDomains, filter);
        while (listDomainsResult.getNextPageMarker() != null) {
            listDomainsRequest.setMarker(listDomainsResult.getNextPageMarker());
            listDomainsResult = this.amazonRoute53Domains.listDomains(listDomainsRequest);
            this.addDomainsMatching(listDomainsResult, filteredDomains, filter);
        }
        return filteredDomains;
    }

    public int getDomainsCount() {
        ListDomainsRequest listDomainsRequest = new ListDomainsRequest();
        listDomainsRequest.setMaxItems(Integer.valueOf(100));
        ListDomainsResult listDomainsResult = this.amazonRoute53Domains.listDomains(listDomainsRequest);
        int domainsCount = listDomainsResult.getDomains().size();
        while (listDomainsResult.getNextPageMarker() != null) {
            listDomainsRequest.setMarker(listDomainsResult.getNextPageMarker());
            listDomainsResult = this.amazonRoute53Domains.listDomains(listDomainsRequest);
            domainsCount += listDomainsResult.getDomains().size();
        }
        return domainsCount;
    }

    private void addDomainsMatching(ListDomainsResult listDomainsResult, List<AwsBasicDomain> basicDomains, Predicate<AwsBasicDomain> filter) {
        listDomainsResult.getDomains().stream().map(this::toBasicDomain).filter(filter).forEach(basicDomains::add);
    }

    private AwsBasicDomain toBasicDomain(DomainSummary domainSummary) {
        return new AwsBasicDomain(domainSummary.getDomainName(), domainSummary.isAutoRenew(), domainSummary.getExpiry().toInstant());
    }

    private AwsDomainRegistrationStatus toAwsDomainRegistrationStatus(GetOperationDetailResult result) {
        return new AwsDomainRegistrationStatus(result.getOperationId(), result.getStatus(), result.getMessage(), result.getDomainName(), result.getType(), result.getSubmittedDate());
    }

    private String checkDomainAvailability(String domainName) {
        CheckDomainAvailabilityRequest request = new CheckDomainAvailabilityRequest().withDomainName(domainName);
        Optional.ofNullable(this.rateLimiter).ifPresent(RateLimiter::acquire);
        return this.amazonRoute53Domains.checkDomainAvailability(request).getAvailability();
    }
}

