/*
 * Decompiled with CFR 0.152.
 */
package pl.codewise.commons.aws.cqrs.discovery;

import com.amazonaws.services.route53.AmazonRoute53;
import com.amazonaws.services.route53.model.AliasTarget;
import com.amazonaws.services.route53.model.ChangeInfo;
import com.amazonaws.services.route53.model.GetChangeRequest;
import com.amazonaws.services.route53.model.GetChangeResult;
import com.amazonaws.services.route53.model.HostedZone;
import com.amazonaws.services.route53.model.ListHostedZonesRequest;
import com.amazonaws.services.route53.model.ListHostedZonesResult;
import com.amazonaws.services.route53.model.ListResourceRecordSetsRequest;
import com.amazonaws.services.route53.model.ListResourceRecordSetsResult;
import com.amazonaws.services.route53.model.ResourceRecord;
import com.amazonaws.services.route53.model.ResourceRecordSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import pl.codewise.commons.aws.cqrs.model.route53.AwsAliasTarget;
import pl.codewise.commons.aws.cqrs.model.route53.AwsChangeInfo;
import pl.codewise.commons.aws.cqrs.model.route53.AwsHostedZone;
import pl.codewise.commons.aws.cqrs.model.route53.AwsRecordSet;
import pl.codewise.commons.aws.cqrs.model.route53.AwsResourceRecord;
import pl.codewise.commons.aws.cqrs.utils.Awaitilities;

public class Route53Discovery {
    private static final String OPERATION_STATUS_INSYNC = "INSYNC";
    private final AmazonRoute53 amazonRoute53;
    private final Awaitilities awaitilities;
    private final long pollInterval;

    public Route53Discovery(AmazonRoute53 amazonRoute53, Awaitilities awaitilities, long pollInterval) {
        this.amazonRoute53 = amazonRoute53;
        this.awaitilities = awaitilities;
        this.pollInterval = pollInterval;
    }

    public List<AwsHostedZone> listHostedZones() {
        return this.hostedZoneStream().map(this::toAwsHostedZone).collect(Collectors.toList());
    }

    public int getHostedZonesCount() {
        Long hostedZoneCount = this.amazonRoute53.getHostedZoneCount().getHostedZoneCount();
        return Math.toIntExact(hostedZoneCount);
    }

    public int getHealthChecksCount() {
        Long healthCheckCount = this.amazonRoute53.getHealthCheckCount().getHealthCheckCount();
        return Math.toIntExact(healthCheckCount);
    }

    public List<AwsRecordSet> listRecordSets(String hostedZoneId) {
        return this.recordSetsStream(hostedZoneId).map(this::toAwsRecordSet).collect(Collectors.toList());
    }

    public AwsChangeInfo waitForChange(AwsChangeInfo changeInfo, long maxWaitTimeMs) {
        if (OPERATION_STATUS_INSYNC.equals(changeInfo.getStatus())) {
            return changeInfo;
        }
        AtomicReference change = new AtomicReference();
        this.awaitilities.awaitTillActionSucceed(maxWaitTimeMs, this.pollInterval, String.format("change %s to be applied", changeInfo.getId()), () -> {
            change.set(this.amazonRoute53.getChange(new GetChangeRequest(changeInfo.getId())));
            return OPERATION_STATUS_INSYNC.equals(((GetChangeResult)change.get()).getChangeInfo().getStatus());
        });
        return this.toAwsChangeInfo(((GetChangeResult)change.get()).getChangeInfo());
    }

    private AwsChangeInfo toAwsChangeInfo(ChangeInfo changeInfo) {
        return new AwsChangeInfo.Builder().withId(changeInfo.getId()).withStatus(changeInfo.getStatus()).build();
    }

    private AwsRecordSet toAwsRecordSet(ResourceRecordSet resourceRecordSet) {
        List<AwsResourceRecord> resourceRecords = resourceRecordSet.getResourceRecords().stream().map(this::toResourceRecord).collect(Collectors.toList());
        return new AwsRecordSet.Builder().withName(resourceRecordSet.getName()).withType(resourceRecordSet.getType()).withRegion(resourceRecordSet.getRegion()).withTtl(resourceRecordSet.getTTL()).withSetIdentifier(resourceRecordSet.getSetIdentifier()).withAliasTarget(this.toAliasTarget(resourceRecordSet.getAliasTarget())).withMultiValueAnswer(resourceRecordSet.getMultiValueAnswer()).withHealthCheckId(resourceRecordSet.getHealthCheckId()).withResourceRecords(resourceRecords).build();
    }

    private AwsAliasTarget toAliasTarget(AliasTarget aliasTarget) {
        return Optional.ofNullable(aliasTarget).map(alias -> new AwsAliasTarget.Builder().withHostedZoneId(alias.getHostedZoneId()).withDnsName(alias.getDNSName()).withEvaluateTargetHealth(alias.getEvaluateTargetHealth()).build()).orElse(null);
    }

    private AwsResourceRecord toResourceRecord(ResourceRecord resourceRecord) {
        return new AwsResourceRecord.Builder().withValue(resourceRecord.getValue()).build();
    }

    private Stream<ResourceRecordSet> recordSetsStream(String hostedZoneId) {
        ListResourceRecordSetsRequest request = new ListResourceRecordSetsRequest(hostedZoneId);
        ListResourceRecordSetsResult recordSets = this.amazonRoute53.listResourceRecordSets(request);
        Stream<ResourceRecordSet> result = recordSets.getResourceRecordSets().stream();
        while (Boolean.TRUE.equals(recordSets.getIsTruncated())) {
            ListResourceRecordSetsRequest nextRequest = new ListResourceRecordSetsRequest().withHostedZoneId(hostedZoneId).withStartRecordName(recordSets.getNextRecordName()).withStartRecordType(recordSets.getNextRecordType()).withStartRecordIdentifier(recordSets.getNextRecordIdentifier());
            recordSets = this.amazonRoute53.listResourceRecordSets(nextRequest);
            result = Stream.concat(result, recordSets.getResourceRecordSets().stream());
        }
        return result;
    }

    private Stream<HostedZone> hostedZoneStream() {
        ListHostedZonesResult hostedZones = this.amazonRoute53.listHostedZones();
        Stream<HostedZone> result = hostedZones.getHostedZones().stream();
        while (Boolean.TRUE.equals(hostedZones.getIsTruncated())) {
            ListHostedZonesRequest nextRequest = new ListHostedZonesRequest().withMarker(hostedZones.getNextMarker());
            hostedZones = this.amazonRoute53.listHostedZones(nextRequest);
            result = Stream.concat(result, hostedZones.getHostedZones().stream());
        }
        return result;
    }

    private AwsHostedZone toAwsHostedZone(HostedZone hostedZone) {
        return new AwsHostedZone.Builder().withId(hostedZone.getId()).withName(hostedZone.getName()).withType(this.toType(hostedZone)).build();
    }

    private AwsHostedZone.Type toType(HostedZone hostedZone) {
        return hostedZone.getConfig().isPrivateZone() != false ? AwsHostedZone.Type.PRIVATE : AwsHostedZone.Type.PUBLIC;
    }
}

