/*
 * Decompiled with CFR 0.152.
 */
package pl.codewise.commons.aws.cqrs.discovery;

import com.amazonaws.services.autoscaling.AmazonAutoScaling;
import com.amazonaws.services.autoscaling.model.AutoScalingInstanceDetails;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingInstancesRequest;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingInstancesResult;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.DescribeInstancesRequest;
import com.amazonaws.services.ec2.model.DescribeSpotInstanceRequestsRequest;
import com.amazonaws.services.ec2.model.EbsInstanceBlockDevice;
import com.amazonaws.services.ec2.model.GroupIdentifier;
import com.amazonaws.services.ec2.model.IamInstanceProfile;
import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.InstanceBlockDeviceMapping;
import com.amazonaws.services.ec2.model.InstanceNetworkInterface;
import com.amazonaws.services.ec2.model.InstanceNetworkInterfaceAssociation;
import com.amazonaws.services.ec2.model.InstanceNetworkInterfaceAttachment;
import com.amazonaws.services.ec2.model.InstancePrivateIpAddress;
import com.amazonaws.services.ec2.model.InstanceStateName;
import com.amazonaws.services.ec2.model.SpotInstanceRequest;
import com.amazonaws.services.ec2.model.Tag;
import com.google.common.collect.Lists;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.codewise.commons.aws.cqrs.model.AwsInstance;
import pl.codewise.commons.aws.cqrs.model.AwsNetworkInterface;
import pl.codewise.commons.aws.cqrs.model.AwsNetworkInterfaceAttachment;
import pl.codewise.commons.aws.cqrs.model.AwsPrivateIpAddress;
import pl.codewise.commons.aws.cqrs.model.AwsPrivateIpAddressAssociation;
import pl.codewise.commons.aws.cqrs.model.ec2.AwsInstanceBlockDeviceMapping;
import pl.codewise.commons.aws.cqrs.model.ec2.AwsInstanceEbs;
import pl.codewise.commons.aws.cqrs.model.ec2.AwsResourceTag;
import pl.codewise.commons.aws.cqrs.model.ec2.autoscaling.AwsAutoScalingDetails;
import pl.codewise.commons.aws.cqrs.model.ec2.sg.AwsSecurityGroup;
import pl.codewise.commons.aws.cqrs.model.ec2.spot.AwsSpotRequestDetails;
import pl.codewise.commons.aws.cqrs.utils.Awaitilities;

public class Ec2Discovery {
    private static final Logger log = LoggerFactory.getLogger(Ec2Discovery.class);
    private static final int MAX_NUMBER_OF_INSTANCE_IDS_IN_DESCRIBE_REQUEST = 50;
    private final String region;
    private final AmazonEC2 amazonEC2;
    private final AmazonAutoScaling amazonAutoScaling;
    private final Awaitilities awaitilities;
    private final long defaultPollInterval;

    public Ec2Discovery(String region, AmazonEC2 amazonEC2, AmazonAutoScaling amazonAutoScaling, Awaitilities awaitilities, long defaultPollInterval) {
        this.region = region;
        this.amazonEC2 = amazonEC2;
        this.amazonAutoScaling = amazonAutoScaling;
        this.awaitilities = awaitilities;
        this.defaultPollInterval = defaultPollInterval;
    }

    public List<AwsInstance> getAllInstances() {
        return this.describeInstances(null);
    }

    @Nullable
    public AwsInstance getInstance(String instanceId) {
        return this.describeInstances(Collections.singletonList(instanceId)).stream().findFirst().orElse(null);
    }

    public List<AwsInstance> getInstances(List<String> instanceIds) {
        if (instanceIds.isEmpty()) {
            return Collections.emptyList();
        }
        return this.describeInstances(instanceIds);
    }

    public void waitForInstanceTerminated(String instanceId, long instanceToBeTerminatedWaitTime) {
        this.waitForInstanceInState(instanceId, instanceToBeTerminatedWaitTime, InstanceStateName.Terminated);
    }

    public String retrieveInstanceNameTag(String instanceId) {
        log.info("About to retrieve Name tag of instance {}", (Object)instanceId);
        return this.instancesStream(Collections.singletonList(instanceId)).flatMap(i -> i.getTags().stream()).filter(tag -> tag.getKey().equals("Name")).findFirst().map(Tag::getValue).orElse("");
    }

    private void waitForInstanceInState(String instanceId, long waitTime, InstanceStateName expectedState) {
        log.info("Waiting for instance {} to enter in {} state", (Object)instanceId, (Object)expectedState);
        this.awaitilities.awaitTillActionSucceed(waitTime, this.defaultPollInterval, String.format("instance %s to be in %s state", instanceId, expectedState.toString()), () -> this.instancesStream(Collections.singletonList(instanceId)).findFirst().map(i -> InstanceStateName.fromValue((String)i.getState().getName())).filter(stateName -> stateName == expectedState).isPresent());
        log.info("Instances {} is in state: {}", (Object)instanceId, (Object)expectedState);
    }

    public AwsInstance waitForInstanceInState(String instanceId, Predicate<AwsInstance> statePredicate, String description, Duration maxWait) {
        return this.awaitilities.awaitForValue((int)maxWait.toMillis(), (int)this.defaultPollInterval, () -> this.describeInstances(Collections.singletonList(instanceId)).stream().findFirst().filter(statePredicate).orElse(null), description);
    }

    private List<AwsInstance> describeInstances(List<String> instanceIds) {
        Map autoScalingDetailsById = this.findAutoScalingInstanceDetails(instanceIds).stream().collect(Collectors.toMap(AutoScalingInstanceDetails::getInstanceId, Function.identity()));
        if (instanceIds != null && autoScalingDetailsById.size() != instanceIds.size()) {
            log.debug("Did not match all instances to auto-scaling details. Expected: %s, actual: %s", instanceIds, autoScalingDetailsById.keySet());
        }
        List instances = this.instancesStream(instanceIds).collect(Collectors.toList());
        if (instanceIds != null && instances.size() != instanceIds.size()) {
            log.debug("Did not found all requested instances. Expected: %s, actual: %s", instanceIds, instances.stream().map(Instance::getInstanceId).collect(Collectors.toList()));
        }
        List<String> spotRequestIds = instances.stream().filter(instance -> "spot".equals(instance.getInstanceLifecycle())).map(Instance::getSpotInstanceRequestId).collect(Collectors.toList());
        Map spotRequestsDetailsById = this.findSpotInstanceRequestDetails(spotRequestIds).stream().collect(Collectors.toMap(SpotInstanceRequest::getInstanceId, Function.identity()));
        return instances.stream().map(i -> this.toAwsInstance((Instance)i, (AutoScalingInstanceDetails)autoScalingDetailsById.get(i.getInstanceId()), (SpotInstanceRequest)spotRequestsDetailsById.get(i.getInstanceId()))).collect(Collectors.toList());
    }

    private Stream<Instance> instancesStream(List<String> instanceIds) {
        return this.amazonEC2.describeInstances(new DescribeInstancesRequest().withInstanceIds(instanceIds)).getReservations().stream().flatMap(r -> r.getInstances().stream());
    }

    private AwsInstance toAwsInstance(Instance instance, AutoScalingInstanceDetails autoScalingInstanceDetails, SpotInstanceRequest spotInstanceRequest) {
        String state = instance.getState() != null ? instance.getState().getName() : null;
        IamInstanceProfile iamInstanceProfile = instance.getIamInstanceProfile();
        AwsInstance.Builder builder = new AwsInstance.Builder().withInstanceId(instance.getInstanceId()).withPublicDnsName(instance.getPublicDnsName()).withPrivateIpAddress(instance.getPrivateIpAddress()).withPublicIpAddress(instance.getPublicIpAddress()).withIamInstanceProfileArn(iamInstanceProfile != null ? iamInstanceProfile.getArn() : null).withImageId(instance.getImageId()).withRegion(this.region).withState(state).withInstanceType(instance.getInstanceType()).withKeyName(instance.getKeyName()).withNetworkInterfaces(this.toAwsNetworkInterfaces(instance.getNetworkInterfaces())).withSecurityGroups(this.toAwsSecurityGroups(instance.getSecurityGroups())).withSubnetId(instance.getSubnetId()).withLaunchTime(instance.getLaunchTime()).withLifecycle(instance.getInstanceLifecycle()).withTags(this.toAwsResourceTags(instance.getTags())).withBlockDeviceMapping(this.toBlockDeviceMappings(instance.getBlockDeviceMappings()));
        if (autoScalingInstanceDetails != null) {
            builder.withAutoScalingDetails(new AwsAutoScalingDetails.Builder().withLaunchConfigurationName(autoScalingInstanceDetails.getLaunchConfigurationName()).withAvailabilityZone(autoScalingInstanceDetails.getAvailabilityZone()).withLifecycleState(autoScalingInstanceDetails.getLifecycleState()).build());
        }
        if (spotInstanceRequest != null) {
            builder.withSpotRequestDetails(new AwsSpotRequestDetails.Builder().withRequestId(spotInstanceRequest.getSpotInstanceRequestId()).withStatus(spotInstanceRequest.getStatus().getCode()).withStatusUpdateTime(spotInstanceRequest.getStatus().getUpdateTime()).withProductDescription(spotInstanceRequest.getProductDescription()).build());
        }
        return builder.build();
    }

    private List<AwsSecurityGroup> toAwsSecurityGroups(List<GroupIdentifier> securityGroups) {
        return securityGroups == null ? Collections.emptyList() : securityGroups.stream().map(sg -> new AwsSecurityGroup(sg.getGroupId()).withGroupName(sg.getGroupName())).collect(Collectors.toList());
    }

    private List<AwsResourceTag> toAwsResourceTags(List<Tag> tags) {
        return tags.stream().map(tag -> AwsResourceTag.create(tag.getKey(), tag.getValue())).collect(Collectors.toList());
    }

    private List<AwsNetworkInterface> toAwsNetworkInterfaces(List<InstanceNetworkInterface> networkInterfaces) {
        return networkInterfaces.stream().map(this::toAwsNetworkInterface).collect(Collectors.toList());
    }

    private AwsNetworkInterface toAwsNetworkInterface(InstanceNetworkInterface networkInterface) {
        return new AwsNetworkInterface.Builder().withNetworkInterfaceId(networkInterface.getNetworkInterfaceId()).withPrivateIpAddresses(this.toPrivateIpAddresses(networkInterface.getPrivateIpAddresses())).withAttachment(this.toAttachment(networkInterface.getAttachment())).build();
    }

    private AwsNetworkInterfaceAttachment toAttachment(InstanceNetworkInterfaceAttachment attachment) {
        return attachment == null ? null : new AwsNetworkInterfaceAttachment.Builder().withDeviceIndex(attachment.getDeviceIndex()).build();
    }

    private List<AwsPrivateIpAddress> toPrivateIpAddresses(List<InstancePrivateIpAddress> privateIpAddresses) {
        return privateIpAddresses.stream().map(this::toPrivateIpAddress).collect(Collectors.toList());
    }

    private AwsPrivateIpAddress toPrivateIpAddress(InstancePrivateIpAddress privateIpAddress) {
        return new AwsPrivateIpAddress.Builder().withPrivateIpAddress(privateIpAddress.getPrivateIpAddress()).withAssociation(this.toAssociation(privateIpAddress.getAssociation())).build();
    }

    private AwsPrivateIpAddressAssociation toAssociation(InstanceNetworkInterfaceAssociation association) {
        return association == null ? null : new AwsPrivateIpAddressAssociation.Builder().withOwnerId(association.getIpOwnerId()).build();
    }

    private List<AutoScalingInstanceDetails> findAutoScalingInstanceDetails(List<String> instanceIds) {
        if (instanceIds == null) {
            return this.findAutoScalingInstanceDetailsForChunk(null);
        }
        return this.findInChunks(Lists.partition(instanceIds, (int)50), this::findAutoScalingInstanceDetailsForChunk);
    }

    private List<SpotInstanceRequest> findSpotInstanceRequestDetails(List<String> spotRequestIds) {
        if (spotRequestIds == null) {
            return Collections.emptyList();
        }
        return this.findInChunks(Lists.partition(spotRequestIds, (int)50), this::findSpotInstanceRequestsForChunk);
    }

    private <T> List<T> findInChunks(List<List<String>> chunks, Function<List<String>, List<T>> findAction) {
        return chunks.stream().map(findAction).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<AutoScalingInstanceDetails> findAutoScalingInstanceDetailsForChunk(List<String> instanceIds) {
        ArrayList instances = Lists.newArrayList();
        String nextToken = null;
        do {
            DescribeAutoScalingInstancesRequest request = new DescribeAutoScalingInstancesRequest().withNextToken(nextToken).withInstanceIds(instanceIds);
            DescribeAutoScalingInstancesResult result = this.amazonAutoScaling.describeAutoScalingInstances(request);
            nextToken = result.getNextToken();
            instances.addAll(result.getAutoScalingInstances());
        } while (nextToken != null);
        return instances;
    }

    private List<SpotInstanceRequest> findSpotInstanceRequestsForChunk(List<String> requestIds) {
        return this.amazonEC2.describeSpotInstanceRequests(new DescribeSpotInstanceRequestsRequest().withSpotInstanceRequestIds(requestIds)).getSpotInstanceRequests();
    }

    private List<AwsInstanceBlockDeviceMapping> toBlockDeviceMappings(List<InstanceBlockDeviceMapping> mappings) {
        return mappings.stream().map(this::toBlockDeviceMapping).collect(Collectors.toList());
    }

    private AwsInstanceBlockDeviceMapping toBlockDeviceMapping(InstanceBlockDeviceMapping mapping) {
        return AwsInstanceBlockDeviceMapping.create(mapping.getDeviceName(), this.toEbs(mapping.getEbs()));
    }

    private AwsInstanceEbs toEbs(EbsInstanceBlockDevice ebs) {
        return AwsInstanceEbs.create(ebs.getAttachTime(), ebs.getDeleteOnTermination(), ebs.getStatus(), ebs.getVolumeId());
    }
}

