/*
 * Decompiled with CFR 0.152.
 */
package pl.codewise.commons.aws.cqrs.discovery;

import com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancing;
import com.amazonaws.services.elasticloadbalancing.model.DescribeInstanceHealthRequest;
import com.amazonaws.services.elasticloadbalancing.model.DescribeInstanceHealthResult;
import com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancersRequest;
import com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancersResult;
import com.amazonaws.services.elasticloadbalancing.model.Instance;
import com.amazonaws.services.elasticloadbalancing.model.LoadBalancerDescription;
import java.util.List;
import java.util.stream.Collectors;
import pl.codewise.commons.aws.cqrs.model.AwsInstance;

public class ClassicLoadBalancingDiscovery {
    public static final String IN_SERVICE_INSTANCE_STATE = "InService";
    public static final String OUT_OF_SERVICE_INSTANCE_STATE = "OutOfService";
    public static final String UNKNOWN_INSTANCE_STATE = "Unknown";
    private final AmazonElasticLoadBalancing amazonElasticLoadBalancing;

    public ClassicLoadBalancingDiscovery(AmazonElasticLoadBalancing amazonElasticLoadBalancing) {
        this.amazonElasticLoadBalancing = amazonElasticLoadBalancing;
    }

    public boolean hasLoadBalancer(String loadBalancerName) {
        DescribeLoadBalancersRequest request = new DescribeLoadBalancersRequest().withLoadBalancerNames(new String[]{loadBalancerName});
        DescribeLoadBalancersResult result = this.amazonElasticLoadBalancing.describeLoadBalancers(request);
        return !result.getLoadBalancerDescriptions().isEmpty();
    }

    public boolean areInstancesInService(String loadBalancerName, List<AwsInstance> awsInstances) {
        return this.areInstancesInState(loadBalancerName, IN_SERVICE_INSTANCE_STATE, this.awsInstancesToInstances(awsInstances));
    }

    public boolean areInstanceIdsInService(String loadBalancerName, List<String> instanceIds) {
        return this.areInstancesInState(loadBalancerName, IN_SERVICE_INSTANCE_STATE, this.instanceIdsToInstances(instanceIds));
    }

    public boolean areInstancesOutOfService(String loadBalancerName, List<AwsInstance> awsInstances) {
        return this.areInstancesInState(loadBalancerName, OUT_OF_SERVICE_INSTANCE_STATE, this.awsInstancesToInstances(awsInstances));
    }

    private boolean areInstancesInState(String loadBalancerName, String state, List<Instance> instances) {
        DescribeInstanceHealthRequest request = new DescribeInstanceHealthRequest(loadBalancerName).withInstances(instances);
        DescribeInstanceHealthResult result = this.amazonElasticLoadBalancing.describeInstanceHealth(request);
        List instanceStates = result.getInstanceStates();
        return instanceStates.size() == instances.size() && instanceStates.stream().allMatch(is -> is.getState().equals(state));
    }

    public LoadBalancerDescription getLoadBalancer(String loadBalancerName) {
        DescribeLoadBalancersRequest request = new DescribeLoadBalancersRequest().withLoadBalancerNames(new String[]{loadBalancerName});
        DescribeLoadBalancersResult result = this.amazonElasticLoadBalancing.describeLoadBalancers(request);
        if (result.getLoadBalancerDescriptions().isEmpty()) {
            return null;
        }
        return (LoadBalancerDescription)result.getLoadBalancerDescriptions().get(0);
    }

    private List<Instance> awsInstancesToInstances(List<AwsInstance> awsInstances) {
        return awsInstances.stream().map(AwsInstance::getInstanceId).map(Instance::new).collect(Collectors.toList());
    }

    private List<Instance> instanceIdsToInstances(List<String> instanceIds) {
        return instanceIds.stream().map(Instance::new).collect(Collectors.toList());
    }
}

