/*
 * Decompiled with CFR 0.152.
 */
package pl.codewise.commons.aws.cqrs.discovery;

import com.amazonaws.services.autoscaling.AmazonAutoScaling;
import com.amazonaws.services.autoscaling.model.Activity;
import com.amazonaws.services.autoscaling.model.AutoScalingGroup;
import com.amazonaws.services.autoscaling.model.AutoScalingInstanceDetails;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingGroupsRequest;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingGroupsResult;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingInstancesRequest;
import com.amazonaws.services.autoscaling.model.DescribePoliciesRequest;
import com.amazonaws.services.autoscaling.model.DescribeScalingActivitiesRequest;
import com.amazonaws.services.autoscaling.model.DescribeTagsRequest;
import com.amazonaws.services.autoscaling.model.DescribeTagsResult;
import com.amazonaws.services.autoscaling.model.Filter;
import com.amazonaws.services.autoscaling.model.Instance;
import com.amazonaws.services.autoscaling.model.LifecycleState;
import com.amazonaws.services.autoscaling.model.SuspendedProcess;
import com.amazonaws.services.autoscaling.model.TagDescription;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.codewise.commons.aws.cqrs.discovery.Ec2Discovery;
import pl.codewise.commons.aws.cqrs.model.AwsAutoScalingGroup;
import pl.codewise.commons.aws.cqrs.model.AwsInstance;
import pl.codewise.commons.aws.cqrs.model.AwsScalingPolicies;
import pl.codewise.commons.aws.cqrs.model.ec2.AwsAutoScalingTag;
import pl.codewise.commons.aws.cqrs.utils.Awaitilities;
import pl.codewise.commons.aws.cqrs.utils.BatchQuery;

public class AutoScalingDiscovery {
    private static final Logger log = LoggerFactory.getLogger(AutoScalingDiscovery.class);
    private static final int MAX_NUMBER_OF_GROUP_NAMES_IN_DESCRIBE_REQUEST = 50;
    private final AmazonAutoScaling amazonAutoScaling;
    private final Ec2Discovery ec2Discovery;
    private final Awaitilities awaitilities;

    public AutoScalingDiscovery(AmazonAutoScaling amazonAutoScaling, Ec2Discovery ec2Discovery, Awaitilities awaitilities) {
        this.amazonAutoScaling = amazonAutoScaling;
        this.ec2Discovery = ec2Discovery;
        this.awaitilities = awaitilities;
    }

    public List<String> listAllAutoScalingGroupNames() {
        List<AutoScalingGroup> groups = this.describeAutoScalingGroupsQuery().execute();
        return groups.stream().map(AutoScalingGroup::getAutoScalingGroupName).collect(Collectors.toList());
    }

    public List<AwsAutoScalingGroup> getAutoScalingGroupsByNames(List<String> groupNames) {
        if (groupNames.isEmpty()) {
            return Collections.emptyList();
        }
        return this.getAutoScalingGroupsRaw(groupNames).stream().map(this::mapAutoScalingGroup).collect(Collectors.toList());
    }

    public AwsAutoScalingGroup getAutoScalingGroupByName(String autoScalingGroupName) {
        AutoScalingGroup autoScalingGroup = this.getAutoScalingGroupRaw(autoScalingGroupName);
        if (autoScalingGroup == null) {
            return null;
        }
        return this.mapAutoScalingGroup(autoScalingGroup);
    }

    public AutoScalingGroup getAutoScalingGroupRaw(String autoScalingGroupName) {
        List<AutoScalingGroup> autoScalingGroups = this.getAutoScalingGroupsRaw(Collections.singletonList(autoScalingGroupName));
        if (autoScalingGroups.size() != 1) {
            log.warn("Could not find ASG named " + autoScalingGroupName);
            return null;
        }
        return autoScalingGroups.get(0);
    }

    public AwsAutoScalingGroup getAutoScalingGroupByPrefix(String namePrefix) {
        List<AwsAutoScalingGroup> groupsWithPrefix = this.listAutoScalingGroupsByPrefix(namePrefix);
        Preconditions.checkState((groupsWithPrefix.size() <= 1 ? 1 : 0) != 0, (Object)String.format("Expected at most one auto-scaling group with prefix: %s, got %s auto-scaling groups: %s", namePrefix, groupsWithPrefix.size(), this.names(groupsWithPrefix)));
        return groupsWithPrefix.stream().findFirst().orElse(null);
    }

    public boolean isInstanceRemovedFromAutoScalingGroup(String instanceId, String autoScalingGroupName) {
        return ((AutoScalingGroup)Iterables.getOnlyElement((Iterable)this.amazonAutoScaling.describeAutoScalingGroups(new DescribeAutoScalingGroupsRequest().withAutoScalingGroupNames(new String[]{autoScalingGroupName})).getAutoScalingGroups())).getInstances().stream().peek(instance -> log.info("Discovered instance: {}", instance)).noneMatch(instance -> instance.getInstanceId().equals(instanceId));
    }

    public List<String> getNewInstancesRegisteredInAutoScalingGroup(Collection<String> previousInstancesSnapshot, String autoScalingGroupName) {
        List<String> possibleNewInstances = ((AutoScalingGroup)Iterables.getOnlyElement((Iterable)this.amazonAutoScaling.describeAutoScalingGroups(new DescribeAutoScalingGroupsRequest().withAutoScalingGroupNames(new String[]{autoScalingGroupName})).getAutoScalingGroups())).getInstances().stream().map(Instance::getInstanceId).filter(id -> !previousInstancesSnapshot.contains(id)).collect(Collectors.toList());
        log.info("New instances: {}", possibleNewInstances);
        return possibleNewInstances;
    }

    public void waitForInstanceInService(String instanceId, long instanceToBeInServiceWaitTime, long instancePoolingWaitTime) {
        log.info("Waiting for instance {} to be in service", (Object)instanceId);
        this.awaitilities.awaitTillActionSucceed(instanceToBeInServiceWaitTime, instancePoolingWaitTime, String.format("instance %s to be in service", instanceId), () -> {
            AutoScalingInstanceDetails instanceDetails = this.getAutoScalingInstanceDetails(instanceId);
            String lifecycleState = instanceDetails.getLifecycleState();
            log.info("Instance {} state: {}", (Object)instanceDetails.getInstanceId(), (Object)lifecycleState);
            return LifecycleState.InService.name().equals(lifecycleState);
        });
        log.info("Instance {} is in service", (Object)instanceId);
    }

    public List<AwsAutoScalingTag> findTags(String key, String value) {
        DescribeTagsResult result = this.amazonAutoScaling.describeTags(new DescribeTagsRequest().withFilters(new Filter[]{new Filter().withName("key").withValues(new String[]{key}), new Filter().withName("value").withValues(new String[]{value})}));
        return this.mapAwsTags(result.getTags());
    }

    public AwsAutoScalingGroup getAutoScalingGroupForInstanceId(String instanceId) {
        return this.getAutoScalingGroupByName(this.getAutoScalingInstanceDetails(instanceId).getAutoScalingGroupName());
    }

    public List<AwsAutoScalingGroup> listAutoScalingGroupsByPrefix(String namePrefix) {
        List<AutoScalingGroup> groups = this.describeAutoScalingGroupsQuery().execute();
        return this.getGroupsWithNamePrefixFrom(namePrefix, groups);
    }

    public List<Activity> getAutoScalingActivitiesInProgress(String autoScalingGroupName) {
        return this.amazonAutoScaling.describeScalingActivities(new DescribeScalingActivitiesRequest().withAutoScalingGroupName(autoScalingGroupName)).getActivities().stream().filter(a -> a.getProgress() < 100).collect(Collectors.toList());
    }

    public AwsScalingPolicies getScalingPolicies(String autoScalingGroupName) {
        List scalingPolicies = this.amazonAutoScaling.describePolicies(new DescribePoliciesRequest().withAutoScalingGroupName(autoScalingGroupName)).getScalingPolicies();
        AwsScalingPolicies awsScalingPolicies = new AwsScalingPolicies();
        awsScalingPolicies.setPolicies(scalingPolicies);
        return awsScalingPolicies;
    }

    private List<AutoScalingGroup> getAutoScalingGroupsRaw(List<String> groupNames) {
        return this.findInChunks(Lists.partition(groupNames, (int)50), this::getAutoScalingGroupsChunkRaw);
    }

    private List<AutoScalingGroup> getAutoScalingGroupsChunkRaw(Collection<String> groupNames) {
        ArrayList<AutoScalingGroup> groups = new ArrayList<AutoScalingGroup>();
        String nextToken = null;
        do {
            DescribeAutoScalingGroupsRequest request = this.prepareDescribeAutoScalingGroupRequestWithToken(nextToken);
            request.withAutoScalingGroupNames(groupNames);
            DescribeAutoScalingGroupsResult result = this.amazonAutoScaling.describeAutoScalingGroups(request);
            nextToken = result.getNextToken();
            groups.addAll(result.getAutoScalingGroups());
        } while (nextToken != null);
        return groups;
    }

    private <T> List<T> findInChunks(List<List<String>> chunks, Function<List<String>, List<T>> findAction) {
        return chunks.stream().map(findAction).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private AutoScalingInstanceDetails getAutoScalingInstanceDetails(String instanceId) {
        DescribeAutoScalingInstancesRequest request = new DescribeAutoScalingInstancesRequest().withInstanceIds(new String[]{instanceId});
        return (AutoScalingInstanceDetails)Iterables.getOnlyElement((Iterable)this.amazonAutoScaling.describeAutoScalingInstances(request).getAutoScalingInstances());
    }

    private BatchQuery<DescribeAutoScalingGroupsRequest, DescribeAutoScalingGroupsResult, AutoScalingGroup> describeAutoScalingGroupsQuery() {
        return new BatchQuery.Builder().requesting(new DescribeAutoScalingGroupsRequest()).settingNewToken((token, request) -> request.setNextToken(token)).executingRequest(arg_0 -> ((AmazonAutoScaling)this.amazonAutoScaling).describeAutoScalingGroups(arg_0)).havingResultIn(DescribeAutoScalingGroupsResult::getAutoScalingGroups).havingNextTokenIn(DescribeAutoScalingGroupsResult::getNextToken).build();
    }

    private DescribeAutoScalingGroupsRequest prepareDescribeAutoScalingGroupRequestWithToken(String nextToken) {
        return new DescribeAutoScalingGroupsRequest().withNextToken(nextToken);
    }

    private List<AwsAutoScalingGroup> getGroupsWithNamePrefixFrom(String namePrefix, List<AutoScalingGroup> groups) {
        return groups.stream().filter(autoScalingGroup -> autoScalingGroup.getAutoScalingGroupName().startsWith(namePrefix)).map(this::mapAutoScalingGroup).sorted((left, right) -> right.getCreated().compareTo(left.getCreated())).collect(Collectors.toList());
    }

    private List<String> names(List<AwsAutoScalingGroup> awsAutoScalingGroups) {
        return awsAutoScalingGroups.stream().map(AwsAutoScalingGroup::getAutoScalingGroupName).collect(Collectors.toList());
    }

    private AwsAutoScalingGroup mapAutoScalingGroup(AutoScalingGroup autoScalingGroup) {
        return new AwsAutoScalingGroup.Builder().withAutoScalingGroupName(autoScalingGroup.getAutoScalingGroupName()).withAwsInstances(this.toAwsInstances(autoScalingGroup.getInstances())).withLoadBalancerNames(autoScalingGroup.getLoadBalancerNames()).withTargetGroupArns(autoScalingGroup.getTargetGroupARNs()).withDesiredCapacity(autoScalingGroup.getDesiredCapacity()).withMinSize(autoScalingGroup.getMinSize()).withMaxSize(autoScalingGroup.getMaxSize()).withCreated(autoScalingGroup.getCreatedTime()).withLaunchConfigurationName(autoScalingGroup.getLaunchConfigurationName()).withDefaultCooldown(autoScalingGroup.getDefaultCooldown()).withAvailabilityZones(autoScalingGroup.getAvailabilityZones()).withHealthCheckType(autoScalingGroup.getHealthCheckType()).withHealthCheckGracePeriod(autoScalingGroup.getHealthCheckGracePeriod()).withPlacementGroup(autoScalingGroup.getPlacementGroup()).withVpcZoneIdentifier(autoScalingGroup.getVPCZoneIdentifier()).withNewInstancesProtectedFromScaleIn(autoScalingGroup.getNewInstancesProtectedFromScaleIn()).withTags(this.mapAwsTags(autoScalingGroup.getTags())).withTerminationPolicies(autoScalingGroup.getTerminationPolicies()).withSuspendedProcesses(this.mapSuspendedProcesses(autoScalingGroup)).build();
    }

    private List<AwsInstance> toAwsInstances(List<Instance> instances) {
        return this.ec2Discovery.getInstances(this.toInstanceIds(instances));
    }

    private List<String> toInstanceIds(List<Instance> instances) {
        return instances.stream().map(Instance::getInstanceId).collect(Collectors.toList());
    }

    private List<AwsAutoScalingTag> mapAwsTags(List<TagDescription> tags) {
        return tags.stream().map(tag -> new AwsAutoScalingTag(tag.getResourceId(), tag.getKey(), tag.getValue(), tag.getPropagateAtLaunch())).collect(Collectors.toList());
    }

    private List<String> mapSuspendedProcesses(AutoScalingGroup autoScalingGroup) {
        return autoScalingGroup.getSuspendedProcesses().stream().map(SuspendedProcess::getProcessName).collect(Collectors.toList());
    }
}

