/*
 * Decompiled with CFR 0.152.
 */
package pl.codewise.commons.aws.cqrs.discovery;

import com.amazonaws.services.elasticloadbalancingv2.AmazonElasticLoadBalancing;
import com.amazonaws.services.elasticloadbalancingv2.model.DescribeTargetHealthRequest;
import com.amazonaws.services.elasticloadbalancingv2.model.DescribeTargetHealthResult;
import com.amazonaws.services.elasticloadbalancingv2.model.TargetDescription;
import com.amazonaws.services.elasticloadbalancingv2.model.TargetHealth;
import com.amazonaws.services.elasticloadbalancingv2.model.TargetHealthDescription;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import pl.codewise.commons.aws.cqrs.model.AwsInstance;

public class ApplicationLoadBalancingDiscovery {
    private static final String HEALTHY = "healthy";
    private static final String UNUSED = "unused";
    private final AmazonElasticLoadBalancing amazonElasticLoadBalancing;

    public ApplicationLoadBalancingDiscovery(AmazonElasticLoadBalancing amazonElasticLoadBalancing) {
        this.amazonElasticLoadBalancing = amazonElasticLoadBalancing;
    }

    public List<TargetHealthDescription> getTargetHealthDescriptions(String targetGroupArn) {
        return this.amazonElasticLoadBalancing.describeTargetHealth(new DescribeTargetHealthRequest().withTargetGroupArn(targetGroupArn)).getTargetHealthDescriptions();
    }

    public boolean areInstancesInService(String targetGroupArn, List<AwsInstance> awsInstances) {
        return this.allTargetsMatch(targetGroupArn, awsInstances, HEALTHY::equals);
    }

    public boolean areInstancesOutOfService(String targetGroupArn, List<AwsInstance> awsInstances) {
        return this.allTargetsMatch(targetGroupArn, awsInstances, UNUSED::equals);
    }

    private boolean allTargetsMatch(String targetGroupArn, List<AwsInstance> awsInstances, Predicate<String> equals) {
        DescribeTargetHealthResult result = this.describeTargetHealth(targetGroupArn, awsInstances);
        List healthDescriptions = result.getTargetHealthDescriptions();
        return this.allHealthStatesMatch(healthDescriptions, equals);
    }

    private DescribeTargetHealthResult describeTargetHealth(String targetGroupArn, List<AwsInstance> awsInstances) {
        return this.amazonElasticLoadBalancing.describeTargetHealth(new DescribeTargetHealthRequest().withTargetGroupArn(targetGroupArn).withTargets(this.toTargets(awsInstances)));
    }

    private boolean allHealthStatesMatch(List<TargetHealthDescription> descriptions, Predicate<String> predicate) {
        return descriptions.stream().map(TargetHealthDescription::getTargetHealth).map(TargetHealth::getState).allMatch(predicate);
    }

    private List<TargetDescription> toTargets(List<AwsInstance> instances) {
        return instances.stream().map(AwsInstance::getInstanceId).map(id -> new TargetDescription().withId(id)).collect(Collectors.toList());
    }
}

